/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelId;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.MacAddressUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThreadLocalRandom;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

public final class DefaultChannelId
implements ChannelId {
    private static final long serialVersionUID = 3884076183504074063L;
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultChannelId.class);
    private static final Pattern MACHINE_ID_PATTERN = Pattern.compile("^(?:[0-9a-fA-F][:-]?){6,8}$");
    private static final int MACHINE_ID_LEN = 8;
    private static final byte[] MACHINE_ID;
    private static final int PROCESS_ID_LEN = 4;
    private static final int MAX_PROCESS_ID = 0x400000;
    private static final int PROCESS_ID;
    private static final int SEQUENCE_LEN = 4;
    private static final int TIMESTAMP_LEN = 8;
    private static final int RANDOM_LEN = 4;
    private static final AtomicInteger nextSequence;
    private final byte[] data = new byte[28];
    private int hashCode;
    private transient String shortValue;
    private transient String longValue;

    public static DefaultChannelId newInstance() {
        DefaultChannelId defaultChannelId = new DefaultChannelId();
        defaultChannelId.init();
        return defaultChannelId;
    }

    private static byte[] parseMachineId(String string) {
        string = string.replaceAll("[:-]", "");
        byte[] byArray = new byte[8];
        for (int i = 0; i < string.length(); i += 2) {
            byArray[i] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
        }
        return byArray;
    }

    private static byte[] defaultMachineId() {
        byte[] byArray = MacAddressUtil.bestAvailableMac();
        if (byArray == null) {
            byArray = new byte[8];
            ThreadLocalRandom.current().nextBytes(byArray);
            logger.warn("Failed to find a usable hardware address from the network interfaces; using random bytes: {}", (Object)MacAddressUtil.formatAddress(byArray));
        }
        return byArray;
    }

    private static int defaultProcessId() {
        int n;
        String string;
        Class<?> clazz;
        ClassLoader classLoader = PlatformDependent.getClassLoader(DefaultChannelId.class);
        try {
            Class<?> clazz2 = Class.forName("java.lang.management.ManagementFactory", true, classLoader);
            clazz = Class.forName("java.lang.management.RuntimeMXBean", true, classLoader);
            Method method = clazz2.getMethod("getRuntimeMXBean", EmptyArrays.EMPTY_CLASSES);
            Object object = method.invoke(null, EmptyArrays.EMPTY_OBJECTS);
            Method method2 = clazz.getMethod("getName", EmptyArrays.EMPTY_CLASSES);
            string = (String)method2.invoke(object, EmptyArrays.EMPTY_OBJECTS);
        }
        catch (Exception exception) {
            logger.debug("Could not invoke ManagementFactory.getRuntimeMXBean().getName(); Android?", exception);
            try {
                clazz = Class.forName("android.os.Process", true, classLoader);
                Method method = clazz.getMethod("myPid", EmptyArrays.EMPTY_CLASSES);
                string = method.invoke(null, EmptyArrays.EMPTY_OBJECTS).toString();
            }
            catch (Exception exception2) {
                logger.debug("Could not invoke Process.myPid(); not Android?", exception2);
                string = "";
            }
        }
        int n2 = string.indexOf(64);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0 || n > 0x400000) {
            n = ThreadLocalRandom.current().nextInt(0x400001);
            logger.warn("Failed to find the current process ID from '{}'; using a random value: {}", (Object)string, (Object)n);
        }
        return n;
    }

    private DefaultChannelId() {
    }

    private void init() {
        int n;
        int n2 = 0;
        System.arraycopy(MACHINE_ID, 0, this.data, n2, 8);
        n2 += 8;
        n2 = this.writeInt(n2, PROCESS_ID);
        n2 = this.writeInt(n2, nextSequence.getAndIncrement());
        n2 = this.writeLong(n2, Long.reverse(System.nanoTime()) ^ System.currentTimeMillis());
        this.hashCode = n = ThreadLocalRandom.current().nextInt();
        n2 = this.writeInt(n2, n);
        assert (n2 == this.data.length);
    }

    private int writeInt(int n, int n2) {
        this.data[n++] = (byte)(n2 >>> 24);
        this.data[n++] = (byte)(n2 >>> 16);
        this.data[n++] = (byte)(n2 >>> 8);
        this.data[n++] = (byte)n2;
        return n;
    }

    private int writeLong(int n, long l) {
        this.data[n++] = (byte)(l >>> 56);
        this.data[n++] = (byte)(l >>> 48);
        this.data[n++] = (byte)(l >>> 40);
        this.data[n++] = (byte)(l >>> 32);
        this.data[n++] = (byte)(l >>> 24);
        this.data[n++] = (byte)(l >>> 16);
        this.data[n++] = (byte)(l >>> 8);
        this.data[n++] = (byte)l;
        return n;
    }

    @Override
    public String asShortText() {
        String string = this.shortValue;
        if (string == null) {
            this.shortValue = string = ByteBufUtil.hexDump(this.data, 24, 4);
        }
        return string;
    }

    @Override
    public String asLongText() {
        String string = this.longValue;
        if (string == null) {
            this.longValue = string = this.newLongValue();
        }
        return string;
    }

    private String newLongValue() {
        StringBuilder stringBuilder = new StringBuilder(2 * this.data.length + 5);
        int n = 0;
        n = this.appendHexDumpField(stringBuilder, n, 8);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        n = this.appendHexDumpField(stringBuilder, n, 8);
        n = this.appendHexDumpField(stringBuilder, n, 4);
        assert (n == this.data.length);
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private int appendHexDumpField(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append(ByteBufUtil.hexDump(this.data, n, n2));
        stringBuilder.append('-');
        return n += n2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(ChannelId channelId) {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultChannelId)) {
            return false;
        }
        return Arrays.equals(this.data, ((DefaultChannelId)object).data);
    }

    public String toString() {
        return this.asShortText();
    }

    static {
        nextSequence = new AtomicInteger();
        int n = -1;
        String string = SystemPropertyUtil.get("io.netty.processId");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n < 0 || n > 0x400000) {
                n = -1;
                logger.warn("-Dio.netty.processId: {} (malformed)", (Object)string);
            } else if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (user-set)", (Object)n);
            }
        }
        if (n < 0) {
            n = DefaultChannelId.defaultProcessId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.processId: {} (auto-detected)", (Object)n);
            }
        }
        PROCESS_ID = n;
        byte[] byArray = null;
        String string2 = SystemPropertyUtil.get("io.netty.machineId");
        if (string2 != null) {
            if (MACHINE_ID_PATTERN.matcher(string2).matches()) {
                byArray = DefaultChannelId.parseMachineId(string2);
                logger.debug("-Dio.netty.machineId: {} (user-set)", (Object)string2);
            } else {
                logger.warn("-Dio.netty.machineId: {} (malformed)", (Object)string2);
            }
        }
        if (byArray == null) {
            byArray = DefaultChannelId.defaultMachineId();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dio.netty.machineId: {} (auto-detected)", (Object)MacAddressUtil.formatAddress(byArray));
            }
        }
        MACHINE_ID = byArray;
    }
}

