/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;

public final class UnpooledByteBufAllocator
extends AbstractByteBufAllocator {
    private final boolean disableLeakDetector;
    public static final UnpooledByteBufAllocator DEFAULT = new UnpooledByteBufAllocator(PlatformDependent.directBufferPreferred());

    public UnpooledByteBufAllocator(boolean bl) {
        this(bl, false);
    }

    public UnpooledByteBufAllocator(boolean bl, boolean bl2) {
        super(bl);
        this.disableLeakDetector = bl2;
    }

    @Override
    protected ByteBuf newHeapBuffer(int n, int n2) {
        return PlatformDependent.hasUnsafe() ? new UnpooledUnsafeHeapByteBuf((ByteBufAllocator)this, n, n2) : new UnpooledHeapByteBuf((ByteBufAllocator)this, n, n2);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n, int n2) {
        AbstractReferenceCountedByteBuf abstractReferenceCountedByteBuf = PlatformDependent.hasUnsafe() ? UnsafeByteBufUtil.newUnsafeDirectByteBuf(this, n, n2) : new UnpooledDirectByteBuf((ByteBufAllocator)this, n, n2);
        return this.disableLeakDetector ? abstractReferenceCountedByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(abstractReferenceCountedByteBuf);
    }

    @Override
    public CompositeByteBuf compositeHeapBuffer(int n) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, false, n);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public CompositeByteBuf compositeDirectBuffer(int n) {
        CompositeByteBuf compositeByteBuf = new CompositeByteBuf(this, true, n);
        return this.disableLeakDetector ? compositeByteBuf : UnpooledByteBufAllocator.toLeakAwareBuffer(compositeByteBuf);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return false;
    }
}

