/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PooledByteBuf;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

final class PoolChunkList<T>
implements PoolChunkListMetric {
    private static final Iterator<PoolChunkMetric> EMPTY_METRICS = Collections.emptyList().iterator();
    private final PoolChunkList<T> nextList;
    private final int minUsage;
    private final int maxUsage;
    private final int maxCapacity;
    private PoolChunk<T> head;
    private PoolChunkList<T> prevList;

    PoolChunkList(PoolChunkList<T> poolChunkList, int n, int n2, int n3) {
        assert (n <= n2);
        this.nextList = poolChunkList;
        this.minUsage = n;
        this.maxUsage = n2;
        this.maxCapacity = PoolChunkList.calculateMaxCapacity(n, n3);
    }

    private static int calculateMaxCapacity(int n, int n2) {
        if ((n = PoolChunkList.minUsage0(n)) == 100) {
            return 0;
        }
        return (int)((long)n2 * (100L - (long)n) / 100L);
    }

    void prevList(PoolChunkList<T> poolChunkList) {
        assert (this.prevList == null);
        this.prevList = poolChunkList;
    }

    boolean allocate(PooledByteBuf<T> pooledByteBuf, int n, int n2) {
        long l;
        if (this.head == null || n2 > this.maxCapacity) {
            return false;
        }
        PoolChunk<T> poolChunk = this.head;
        while ((l = poolChunk.allocate(n2)) < 0L) {
            poolChunk = poolChunk.next;
            if (poolChunk != null) continue;
            return false;
        }
        poolChunk.initBuf(pooledByteBuf, l, n);
        if (poolChunk.usage() >= this.maxUsage) {
            this.remove(poolChunk);
            this.nextList.add(poolChunk);
        }
        return true;
    }

    boolean free(PoolChunk<T> poolChunk, long l) {
        poolChunk.free(l);
        if (poolChunk.usage() < this.minUsage) {
            this.remove(poolChunk);
            return this.move0(poolChunk);
        }
        return true;
    }

    private boolean move(PoolChunk<T> poolChunk) {
        assert (poolChunk.usage() < this.maxUsage);
        if (poolChunk.usage() < this.minUsage) {
            return this.move0(poolChunk);
        }
        this.add0(poolChunk);
        return true;
    }

    private boolean move0(PoolChunk<T> poolChunk) {
        if (this.prevList == null) {
            assert (poolChunk.usage() == 0);
            return false;
        }
        return super.move(poolChunk);
    }

    void add(PoolChunk<T> poolChunk) {
        if (poolChunk.usage() >= this.maxUsage) {
            this.nextList.add(poolChunk);
            return;
        }
        this.add0(poolChunk);
    }

    void add0(PoolChunk<T> poolChunk) {
        poolChunk.parent = this;
        if (this.head == null) {
            this.head = poolChunk;
            poolChunk.prev = null;
            poolChunk.next = null;
        } else {
            poolChunk.prev = null;
            poolChunk.next = this.head;
            this.head.prev = poolChunk;
            this.head = poolChunk;
        }
    }

    private void remove(PoolChunk<T> poolChunk) {
        if (poolChunk == this.head) {
            this.head = poolChunk.next;
            if (this.head != null) {
                this.head.prev = null;
            }
        } else {
            PoolChunk poolChunk2;
            poolChunk.prev.next = poolChunk2 = poolChunk.next;
            if (poolChunk2 != null) {
                poolChunk2.prev = poolChunk.prev;
            }
        }
    }

    @Override
    public int minUsage() {
        return PoolChunkList.minUsage0(this.minUsage);
    }

    @Override
    public int maxUsage() {
        return Math.min(this.maxUsage, 100);
    }

    private static int minUsage0(int n) {
        return Math.max(1, n);
    }

    @Override
    public Iterator<PoolChunkMetric> iterator() {
        if (this.head == null) {
            return EMPTY_METRICS;
        }
        ArrayList<PoolChunk<T>> arrayList = new ArrayList<PoolChunk<T>>();
        PoolChunk<T> poolChunk = this.head;
        do {
            arrayList.add(poolChunk);
        } while ((poolChunk = poolChunk.next) != null);
        return arrayList.iterator();
    }

    public String toString() {
        if (this.head == null) {
            return "none";
        }
        StringBuilder stringBuilder = new StringBuilder();
        PoolChunk<T> poolChunk = this.head;
        while (true) {
            stringBuilder.append(poolChunk);
            poolChunk = poolChunk.next;
            if (poolChunk == null) break;
            stringBuilder.append(StringUtil.NEWLINE);
        }
        return stringBuilder.toString();
    }
}

