/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.os;

import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.security.Account;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FilenameUtils;

public class LinuxUtil {
    private LinuxUtil() {
    }

    public static String getDesktopEnvironment() {
        return System.getenv("XDG_CURRENT_DESKTOP");
    }

    public static boolean isNotKDE() {
        String string = LinuxUtil.getDesktopEnvironment();
        return null == string || !string.contains("KDE");
    }

    public static Path getDesktopDirPath() {
        Object object = System.getenv("XDG_DESKTOP_DIR");
        if (null == object) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-user-dir", "DESKTOP");
            try {
                Process process = processBuilder.start();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                object = bufferedReader.readLine();
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null == object) {
                object = System.getProperty("user.home") + System.getProperty("file.separator") + "Desktop";
            }
        }
        return null != object ? Paths.get((String)object, new String[0]) : null;
    }

    public static String mountWebDAV(ServerClient serverClient, String string) {
        Object object = FilenameUtils.getBaseName(string);
        if (!((String)object).endsWith(".webdav")) {
            object = (String)object + ".webdav";
        }
        Path path = serverClient.getController().getFolderRepository().getFoldersBasedir().resolve((String)object);
        String string2 = serverClient.isTokenLogin() ? serverClient.getWebDAVToken() : serverClient.getPasswordClearText();
        Account account = serverClient.getAccount();
        String string3 = account.isValid() ? account.getUsername() : serverClient.getUsername();
        return LinuxUtil.mountWebDAV(string3, string2, string, path, false);
    }

    public static String mountWebDAV(String string, Path path) throws MalformedURLException {
        String string2 = null;
        String string3 = null;
        URL uRL = new URL(string);
        String string4 = uRL.getProtocol();
        String string5 = uRL.getAuthority();
        String string6 = string.substring(string.lastIndexOf("@") + 1, string.length());
        if (null != string5) {
            string2 = string5.substring(0, string5.indexOf(":"));
            string3 = string5.substring(string5.indexOf(":") + 1, string5.lastIndexOf("@"));
        }
        string = !string6.contains("http") ? string4 + "://" + string6 : string6;
        return LinuxUtil.mountWebDAV(string2, string3, string, path, true);
    }

    public static String mountWebDAV(String string, String string2, String string3, Path path, boolean bl) {
        Path path2 = Paths.get("/bin/bash", new String[0]);
        Path path3 = Paths.get("/usr/bin/sudo", new String[0]);
        Path path4 = Paths.get("/usr/bin/pkexec", new String[0]);
        Path path5 = Paths.get("/sbin/mount.davfs", new String[0]);
        if (Files.notExists(path2, new LinkOption[0])) {
            return "N" + Translation.get("dialog.webdav.install_missing", "bash");
        }
        if (bl && Files.notExists(path3, new LinkOption[0])) {
            return "N" + Translation.get("dialog.webdav.install_missing", "sudo");
        }
        if (!bl && Files.notExists(path4, new LinkOption[0])) {
            return "N" + Translation.get("dialog.webdav.install_missing", "pkexec");
        }
        if (Files.notExists(path5, new LinkOption[0])) {
            return "N" + Translation.get("dialog.webdav.install_missing", "davfs2");
        }
        try {
            if (Files.notExists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
        }
        catch (IOException iOException) {
            return "N" + iOException.getMessage();
        }
        String string4 = String.format("echo '%s' | %s %s %s -o users,username=%s,uid=%s %s", string2.replace("'", "\\'"), bl ? path3 : path4, path5, string3, string, System.getProperty("user.name"), path);
        String[] stringArray = new String[]{path2.toString(), "-c", string4};
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder stringBuilder = new StringBuilder();
            String string5 = bufferedReader.readLine();
            while (string5 != null) {
                stringBuilder.append(string5 + " ");
                string5 = bufferedReader.readLine();
            }
            bufferedReader.close();
            return StringUtils.isBlank(stringBuilder.toString()) ? "Y" : "N" + stringBuilder;
        }
        catch (IOException iOException) {
            return "N" + iOException.getMessage();
        }
    }

    public static String checkRequirementsForWebDAV() {
        if (!OSUtil.isLinux()) {
            return Translation.get("dialog.webdav.install_missing");
        }
        Path path = Paths.get("/bin/bash", new String[0]);
        Path path2 = Paths.get("/usr/bin/sudo", new String[0]);
        Path path3 = Paths.get("/usr/bin/pkexec", new String[0]);
        Path path4 = Paths.get("/sbin/mount.davfs", new String[0]);
        if (Files.notExists(path, new LinkOption[0])) {
            return Translation.get("dialog.webdav.install_missing", "bash");
        }
        if (Files.notExists(path2, new LinkOption[0])) {
            return Translation.get("dialog.webdav.install_missing", "sudo");
        }
        if (Files.notExists(path3, new LinkOption[0])) {
            return Translation.get("dialog.webdav.install_missing", "pkexec");
        }
        if (Files.notExists(path4, new LinkOption[0])) {
            return Translation.get("dialog.webdav.install_missing", "davfs2");
        }
        return null;
    }
}

