/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging.handlers;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public abstract class AbstractSyslogHandler
extends Handler {
    private String prefix;
    private SimpleDateFormat smf;
    private final Object lock = new Object();
    private long lastConnectAttempt = 0L;
    private static final long reconnectDelayMillis = 10000L;

    public void init(String string) {
        this.smf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        this.prefix = string;
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        try {
            this.ensureConnected();
            String string = this.buildHeader(logRecord);
            String string2 = this.formatMessage(logRecord);
            this.send(this.concat(string.getBytes(StandardCharsets.US_ASCII), string2.getBytes(StandardCharsets.UTF_8)));
        }
        catch (IOException iOException) {
            this.reportError("Publish failed", iOException, 1);
            this.attemptReconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureConnected() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isConnected()) {
                if (System.currentTimeMillis() - this.lastConnectAttempt > 10000L) {
                    this.connect();
                } else {
                    throw new IOException("Syslog connection unavailable");
                }
            }
            this.lastConnectAttempt = System.currentTimeMillis();
        }
    }

    private void attemptReconnect() {
        try {
            Thread.sleep(500L);
            this.connect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    abstract boolean isConnected();

    public abstract void connect() throws IOException;

    private String getLoggerName(LogRecord logRecord) {
        String string = logRecord.getLoggerName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1, string.length());
        }
        return string;
    }

    private int getLevelPrio(LogRecord logRecord) {
        Level level = logRecord.getLevel();
        if (level.equals(Level.FINER)) {
            return 7;
        }
        if (level.equals(Level.FINE)) {
            return 6;
        }
        if (level.equals(Level.INFO)) {
            return 5;
        }
        if (level.equals(Level.WARNING)) {
            return 4;
        }
        if (level.equals(Level.SEVERE)) {
            return 3;
        }
        return 7;
    }

    private String buildHeader(LogRecord logRecord) {
        int n = 128;
        int n2 = this.getLevelPrio(logRecord);
        String string = "<" + (n + n2) + ">";
        return string + "1 " + this.smf.format(new Date(logRecord.getMillis())) + " " + this.prefix + " PowerFolder " + this.getPID("-") + " - - ";
    }

    private String formatMessage(LogRecord logRecord) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[").append(this.getLoggerName(logRecord)).append("] ");
        stringBuilder.append(this.getFormatter() != null ? this.getFormatter().formatMessage(logRecord) : logRecord.getMessage());
        return stringBuilder.toString();
    }

    protected abstract void send(byte[] var1) throws IOException;

    protected byte[] concat(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        byte[] byArray3 = new byte[n + n2];
        System.arraycopy(byArray, 0, byArray3, 0, n);
        System.arraycopy(byArray2, 0, byArray3, n, n2);
        return byArray3;
    }

    private String getPID(String string) {
        String string2 = ManagementFactory.getRuntimeMXBean().getName();
        if (string2.contains("@")) {
            String[] stringArray = string2.split("@");
            return stringArray[0];
        }
        return string;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

