/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util.logging;

import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LoggingFormatter
extends Formatter {
    private static final String POWERFOLDER_LCASE = "powerfolder";
    private static final String POWERFOLDER = "PowerFolder";
    private static final String DAL33T = ".dal33t";
    private boolean showDate;
    private boolean replacePF;

    public LoggingFormatter(boolean bl) {
        this.showDate = bl;
        this.replacePF = !POWERFOLDER.equals(Constants.MISC_DIR_NAME);
    }

    public LoggingFormatter() {
        this(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String format(LogRecord logRecord) {
        String string = logRecord.getLevel().equals(Level.OFF) ? "OFF   " : (logRecord.getLevel().equals(Level.WARNING) ? "WARN  " : (logRecord.getLevel().equals(Level.SEVERE) ? "SEVERE" : (logRecord.getLevel().equals(Level.FINE) ? "FINE  " : (logRecord.getLevel().equals(Level.FINER) ? "FINER " : (logRecord.getLevel().equals(Level.INFO) ? "INFO  " : logRecord.getLevel().getName())))));
        StringBuilder stringBuilder = new StringBuilder(300);
        stringBuilder.append('[');
        SimpleDateFormat simpleDateFormat = this.showDate ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss") : new SimpleDateFormat("HH:mm:ss");
        stringBuilder.append(simpleDateFormat.format(new Date(logRecord.getMillis())));
        stringBuilder.append("] ");
        stringBuilder.append(string);
        stringBuilder.append(" [");
        String string2 = logRecord.getLoggerName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            stringBuilder.append(string2.substring(n + 1, string2.length()));
        } else {
            stringBuilder.append(string2);
        }
        stringBuilder.append("]: ");
        stringBuilder.append(this.replacePFString(logRecord.getMessage()));
        stringBuilder.append(Util.getLineFeed());
        if (logRecord.getThrown() != null) {
            Throwable throwable = logRecord.getThrown();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter((Writer)stringWriter, true);
                throwable.printStackTrace(printWriter);
            }
            finally {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
            }
            stringWriter.flush();
            String string3 = this.replacePFString(stringWriter.toString());
            stringBuilder.append(string3).append(Util.getLineFeed());
        }
        return stringBuilder.toString();
    }

    private String replacePFString(String string) {
        if (!this.replacePF) {
            return string;
        }
        if (StringUtils.isBlank(string)) {
            return string;
        }
        return string.replace(POWERFOLDER, Constants.MISC_DIR_NAME).replace(POWERFOLDER_LCASE, Constants.MISC_DIR_NAME).replace(DAL33T, "");
    }
}

