/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public final class RingBuffer {
    private final byte[] data;
    private int rpos;
    private int wlen;

    public RingBuffer(int n) {
        this.data = new byte[n];
    }

    public void write(int n) {
        if (this.wlen >= this.data.length) {
            throw new BufferOverflowException();
        }
        this.data[(this.rpos + this.wlen) % this.data.length] = (byte)n;
        ++this.wlen;
    }

    public void write(byte[] byArray, int n, int n2) {
        if (n2 + this.wlen > this.data.length) {
            throw new BufferOverflowException();
        }
        while (n2 > 0) {
            int n3 = (this.rpos + this.wlen) % this.data.length;
            int n4 = Math.min(this.data.length - n3, n2);
            System.arraycopy(byArray, n, this.data, n3, n4);
            n += n4;
            this.wlen += n4;
            n2 -= n4;
        }
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public int read() {
        if (this.wlen <= 0) {
            throw new BufferUnderflowException();
        }
        int n = this.data[this.rpos] & 0xFF;
        this.rpos = (this.rpos + 1) % this.data.length;
        --this.wlen;
        return n;
    }

    public void skip(int n) {
        if (n > this.wlen) {
            throw new BufferUnderflowException();
        }
        this.rpos = (this.rpos + n) % this.data.length;
        this.wlen -= n;
    }

    public int peek() {
        if (this.wlen <= 0) {
            throw new BufferUnderflowException();
        }
        return this.data[this.rpos] & 0xFF;
    }

    public void read(byte[] byArray, int n, int n2) {
        if (n2 > this.wlen) {
            throw new BufferUnderflowException();
        }
        while (n2 > 0) {
            int n3 = (this.rpos + this.wlen) % this.data.length;
            int n4 = Math.min(this.data.length - n3, n2);
            System.arraycopy(this.data, n3, byArray, n, n4);
            n += n4;
            this.wlen -= n4;
            this.rpos = (this.rpos + n4) % this.data.length;
            n2 -= n4;
        }
    }

    public void peek(byte[] byArray, int n, int n2) {
        if (n2 > this.wlen) {
            throw new BufferUnderflowException();
        }
        int n3 = this.rpos;
        while (n2 > 0) {
            int n4 = Math.min(this.data.length - n3, n2);
            System.arraycopy(this.data, n3, byArray, n, n4);
            n += n4;
            n2 -= n4;
            n3 = (n3 + n4) % this.data.length;
        }
    }

    public int available() {
        return this.wlen;
    }

    public int remaining() {
        return this.data.length - this.wlen;
    }

    public int size() {
        return this.data.length;
    }

    public void reset() {
        this.rpos = 0;
        this.wlen = 0;
    }
}

