/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.ProfilingStat;
import de.dal33t.powerfolder.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Profiling {
    private static final Logger LOG = Logger.getLogger(Profiling.class.getName());
    public static boolean ENABLED;
    private static long startTime;
    private static long totalTime;
    private static long minimumTime;
    private static long maximumTime;
    private static long totalCount;
    private static final Map<String, ProfilingStat> stats;

    private Profiling() {
    }

    public static void setEnabled(boolean bl) {
        ENABLED = bl;
    }

    public static boolean isEnabled() {
        return ENABLED;
    }

    public static ProfilingEntry start() {
        if (!ENABLED) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = new RuntimeException().getStackTrace();
        String string = stackTraceElementArray[1].getClassName() + "#" + stackTraceElementArray[1].getMethodName();
        return new ProfilingEntry(string, null);
    }

    public static ProfilingEntry start(String string) {
        if (!ENABLED) {
            return null;
        }
        return new ProfilingEntry(string, null);
    }

    public static ProfilingEntry start(Class<?> clazz, String string) {
        if (!ENABLED) {
            return null;
        }
        String string2 = clazz.getSimpleName();
        if (StringUtils.isBlank(string2)) {
            string2 = clazz.getName();
        }
        return new ProfilingEntry(string2 + "#" + string, null);
    }

    public static ProfilingEntry start(Class<?> clazz, String string, String string2) {
        if (!ENABLED) {
            return null;
        }
        String string3 = clazz.getSimpleName();
        if (StringUtils.isBlank(string3)) {
            string3 = clazz.getName();
        }
        return new ProfilingEntry(string3 + "#" + string + ":" + string2, null);
    }

    public static void end(ProfilingEntry profilingEntry) {
        Profiling.end(profilingEntry, -1);
    }

    public static void end(ProfilingEntry profilingEntry, int n) {
        ProfilingStat profilingStat;
        if (!ENABLED) {
            return;
        }
        if (profilingEntry == null) {
            LOG.log(Level.SEVERE, "Cannot end profiling, entry is null", new RuntimeException("Cannot end profiling, entry is null"));
            return;
        }
        long l = profilingEntry.elapsedMilliseconds();
        String string = profilingEntry.getOperationName();
        if (n <= 0 || l >= (long)n) {
            // empty if block
        }
        totalTime += l;
        ++totalCount;
        if (l < minimumTime) {
            minimumTime = l;
        }
        if (l > maximumTime) {
            maximumTime = l;
        }
        if (stats.isEmpty()) {
            startTime = System.currentTimeMillis();
        }
        if ((profilingStat = stats.get(string)) == null) {
            profilingStat = new ProfilingStat(string);
            stats.put(string, profilingStat);
        }
        profilingStat.addElapsed(l);
    }

    public static String dumpStats() {
        if (!ENABLED) {
            LOG.warning("Unable to dump stats. Profiling is disabled");
            return "Unable to dump stats. Profiling is disabled";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("=== Profiling Statistics ===\n");
        try {
            stringBuilder.append("Uptime: " + Format.formatTimeframe(System.currentTimeMillis() - startTime) + "\n");
            stringBuilder.append("Total invocations: " + totalCount + "\n");
            stringBuilder.append("Total elapsed time: " + Format.formatTimeframe(totalTime) + "\n");
            if (totalCount > 0L) {
                stringBuilder.append("Avg time: " + Format.formatTimeframe(totalTime / totalCount) + "\n");
            }
            stringBuilder.append("Min elapsed time: " + Format.formatTimeframe(minimumTime) + "\n");
            stringBuilder.append("Max elapsed time: " + Format.formatTimeframe(maximumTime) + "\n");
            stringBuilder.append("\n");
            ArrayList<String> arrayList = new ArrayList<String>(stats.keySet());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                ProfilingStat profilingStat = stats.get(string);
                Object object = "";
                for (int i = 0; i < 70 - profilingStat.getOperationName().length(); ++i) {
                    object = (String)object + " ";
                }
                long l = System.currentTimeMillis() - startTime;
                double d = (double)profilingStat.getCount() / (double)l;
                int n = (int)(d * 1000.0 * 60.0 * 60.0);
                stringBuilder.append(profilingStat.getOperationName() + (String)object + " \t" + profilingStat.getCount() + "\tinvocations\t" + n + "\tinvocations per hour\t" + profilingStat.getElapsed() + "\tms elapsed\t" + profilingStat.getElapsed() / profilingStat.getCount() + "\tms average\n");
            }
            stringBuilder.append("============================");
        }
        catch (Throwable throwable) {
            stringBuilder.append("Error generating:\n");
            stringBuilder.append(throwable.toString());
        }
        return stringBuilder.toString();
    }

    public static void reset() {
        stats.clear();
        maximumTime = 0L;
        minimumTime = Long.MAX_VALUE;
        totalCount = 0L;
        totalTime = 0L;
    }

    public static final String shortenURI(String string) {
        if (string.startsWith("/dl/") || string.startsWith("/download/") || string.startsWith("/open/") || string.startsWith("/webdav/") || string.startsWith("/thumb/") || string.startsWith("/getlink/") || string.startsWith("/avatars/") || string.startsWith("/filestable/") || string.startsWith("/onlyoffice/") || string.startsWith("/editfile/") || string.startsWith("/upload/") || string.startsWith("/wapi/upload/") || string.startsWith("/api/upload/") || string.startsWith("/ul/") || string.startsWith("/gallery/") || string.startsWith("/settings/") || string.startsWith("/filesjson/") || string.startsWith("/files/") || string.startsWith("/folderstable/") || string.startsWith("/player/")) {
            return string.substring(0, string.indexOf(47, 2));
        }
        try {
            int n;
            int n2;
            int n3 = 0;
            if (string.startsWith("/")) {
                ++n3;
            }
            if ((n2 = string.indexOf(47, n3)) >= 0 && (n = string.indexOf(47, n2 + 1)) >= 0) {
                string = string.substring(0, Math.min(n + 1, string.length()));
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.WARNING, "Unable to shorten URI " + string + ". " + runtimeException, runtimeException);
        }
        return string;
    }

    static {
        minimumTime = Long.MAX_VALUE;
        stats = new ConcurrentHashMap<String, ProfilingStat>();
    }
}

