/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.EncryptedFileSystemUtils;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.util.ProgressListener;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamCallback;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import de.dal33t.powerfolder.util.os.mac.MacUtils;
import java.awt.Desktop;
import java.beans.ExceptionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.spi.FileSystemProvider;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class PathUtils {
    private static final Logger log = Logger.getLogger(PathUtils.class.getName());
    private static final int BYTE_CHUNK_SIZE = 8192;
    public static final String DOWNLOAD_INCOMPLETE_FILE = "(incomplete) ";
    public static final String DOWNLOAD_META_FILE = "(downloadmeta) ";
    public static final String TRANSFERS_DIR_NAME = "transfers";
    public static final String DESKTOP_INI_FILENAME = "desktop.ini";
    public static final String INVALID_CHARS = "/\\:*?\"<>|";
    private static ExceptionListener IO_EXCEPTION_LISTENER = new ExceptionListener(){

        @Override
        public void exceptionThrown(Exception exception) {
        }
    };
    private static final int MAX_SUBDIR_REPLICATION = 11;
    private static final long MS_31_OCT_2013 = 1383177600000L;
    private static final List<String> INCOMPLETE_FILES_PREFIXES = List.of("(incomplete) ", "(downloadmeta) ");

    private PathUtils() {
    }

    public static void setIOExceptionListener(ExceptionListener exceptionListener) {
        IO_EXCEPTION_LISTENER = exceptionListener == null ? new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception exception) {
            }
        } : exceptionListener;
    }

    public static boolean isReplicatedSubdir(Path path) {
        Reject.ifNull(path, "Path");
        Path path2 = path.getFileName();
        try {
            int n = 2;
            for (Path path3 = path.getParent(); path3 != null; path3 = path3.getParent()) {
                Path path4 = path3.getFileName();
                if (path4 == null || !path4.equals(path2)) {
                    return false;
                }
                if (n >= 11) {
                    return true;
                }
                ++n;
            }
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.WARNING, "Problem while checking if subdir is replicated: " + path, runtimeException);
        }
        return false;
    }

    public static boolean isDesktopIni(Path path) {
        if (path == null) {
            throw new NullPointerException("File is null");
        }
        return path.getFileName().toString().equalsIgnoreCase(DESKTOP_INI_FILENAME);
    }

    public static boolean isValidZipFile(Path path) {
        boolean bl;
        if (path == null) {
            throw new NullPointerException("File is null");
        }
        ZipFile zipFile = new ZipFile(path.toAbsolutePath().toString());
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ZipException zipException) {
                return false;
            }
            catch (IOException iOException) {
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
                return false;
            }
        }
        zipFile.close();
        return bl;
    }

    public static boolean isSameName(Path path, Path path2) {
        Reject.ifNull(path, "Path 1");
        Reject.ifNull(path2, "Path 2");
        Path path3 = path.getFileName();
        Path path4 = path2.getFileName();
        if (path3 == null || path4 == null) {
            return false;
        }
        String string = path3.toString();
        String string2 = path4.toString();
        return PathUtils.isSameName(string, string2);
    }

    public static boolean isSameName(String string, String string2) {
        String string3;
        Reject.ifBlank(string, "Name 1");
        Reject.ifBlank(string2, "Name 2");
        boolean bl = string.equals(string2);
        if (bl) {
            return true;
        }
        int n = string.lastIndexOf(" (");
        if (n > 0 && string.endsWith(")") && (string3 = string.substring(0, n)).equals(string2)) {
            return true;
        }
        int n2 = string2.lastIndexOf(" (");
        if (n2 > 0 && string2.endsWith(")")) {
            String string4 = string2.substring(0, n2);
            return string4.equals(string);
        }
        return false;
    }

    public static boolean isNetworkPath(Path path) throws IOException {
        Reject.ifNull(path, "Path");
        if (Files.isSymbolicLink(path)) {
            path = path.toRealPath(new LinkOption[0]);
        }
        if (OSUtil.isLinux()) {
            return PathUtils.isNetworkPathUnix(path);
        }
        if (OSUtil.isMacOS()) {
            return MacUtils.getInstance().isNetworkPath(path);
        }
        if (OSUtil.isWindowsSystem()) {
            return PathUtils.isNetworkPathWindows(path);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNetworkPathUnix(Path path) {
        try {
            Process process = Runtime.getRuntime().exec("df");
            InputStream inputStream = process.getInputStream();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                int n;
                String string;
                Path path2;
                String string2;
                do {
                    if ((string2 = bufferedReader.readLine()) == null) return false;
                } while (!string2.contains("//") && !string2.contains("\\\\") && !string2.contains(":") || !path.startsWith(path2 = Paths.get(string = string2.substring((n = string2.lastIndexOf(" ")) + 1), new String[0])));
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            log.warning("Unable to check, if path " + path.toString() + " is a network drive. " + iOException);
            return false;
        }
    }

    private static boolean isNetworkPathWindows(Path path) {
        boolean bl = path.toString().contains(":");
        if (!bl) {
            return path.toString().startsWith("\\\\");
        }
        String string = path.toString().substring(0, path.toString().indexOf(":") + 1);
        String string2 = "cmd /c net use " + string;
        try {
            String string3;
            Process process = Runtime.getRuntime().exec(string2);
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer2.append(string3);
            }
            bufferedReader.close();
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string3 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string3);
            }
            bufferedReader.close();
            int n = process.waitFor();
            return n == 0;
        }
        catch (Exception exception) {
            log.warning("Unable to check if path is network drive: " + path + ". " + exception);
            return false;
        }
    }

    public static Path createEmptyDirectory(Path path) {
        Reject.ifNull(path, "Base dir is null");
        Path path2 = path;
        int n = 2;
        String string = path.getFileName().toString();
        String string2 = "";
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(n2);
            string = string.substring(0, n2);
        }
        while (Files.exists(path2, new LinkOption[0])) {
            path2 = path.getParent().resolve(string + " (" + n + ")" + string2);
            if (++n <= 999999999) continue;
            throw new IllegalStateException("Unable to find empty directory Tried " + path2);
        }
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            log.info("Could not create directory (unsupported). " + unsupportedOperationException);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            log.fine("File already exists. " + fileAlreadyExistsException);
        }
        catch (IOException iOException) {
            log.info("Could not create driectory. " + iOException);
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
        }
        return path2;
    }

    public static Path createEmptyDirectory(Path path, String string) {
        Reject.ifNull(path, "Base dir is null");
        Reject.ifBlank(string, "Raw name is null");
        return PathUtils.createEmptyDirectory(path.resolve(PathUtils.removeInvalidFilenameChars(string)));
    }

    public static int getNumberOfSiblings(Path path) {
        return PathUtils.getNumberOfSiblings(path, new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return true;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getNumberOfSiblings(Path path, DirectoryStream.Filter<Path> filter) {
        int n = 0;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, filter);){
            if (directoryStream == null) {
                int n2 = 0;
                return n2;
            }
            Iterator<Path> iterator = directoryStream.iterator();
            while (iterator.hasNext()) {
                Path path2 = iterator.next();
                ++n;
            }
            return n;
        }
        catch (IOException iOException) {
            log.warning("Could not count number of siblings. " + iOException);
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            return 0;
        }
    }

    public static boolean isEmptyDir(Path path2) {
        return PathUtils.isEmptyDir(path2, path -> true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmptyDir(Path path, DirectoryStream.Filter<Path> filter) {
        if (path == null) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, filter);){
            if (directoryStream == null) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = !directoryStream.iterator().hasNext();
            return bl;
        }
        catch (NoSuchFileException noSuchFileException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(noSuchFileException);
            return false;
        }
        catch (IOException iOException) {
            log.warning("Error checking for empty directory. " + iOException);
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
        }
        return false;
    }

    public static String getSuggestedFolderName(Path path) {
        if (path == null) {
            return null;
        }
        if (path.getFileName() != null && StringUtils.isNotBlank(path.getFileName().toString())) {
            return path.getFileName().toString();
        }
        return path.toAbsolutePath().toString();
    }

    public static String getDiskFileName(String string, String string2) {
        if (!OSUtil.isMacOS()) {
            return string2;
        }
        Path path = Paths.get(string, new String[0]).toAbsolutePath().relativize(Paths.get(string, string2).toAbsolutePath());
        return path.toString();
    }

    public static void copyFile(Path path, Path path2) throws IOException {
        if (path == null) {
            throw new NullPointerException("From file is null");
        }
        if (Files.notExists(path, new LinkOption[0])) {
            throw new IOException("From file does not exists " + path.toAbsolutePath().toString());
        }
        if (path.equals(path2)) {
            throw new IOException("cannot copy onto itself");
        }
        try {
            if (EncryptedFileSystemUtils.isCryptoInstance(path) || EncryptedFileSystemUtils.isCryptoInstance(path2)) {
                Files.copy(path, path2, StandardCopyOption.REPLACE_EXISTING);
            } else {
                PathUtils.copyFromStreamToFile(Files.newInputStream(path, new OpenOption[0]), path2);
            }
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw new IOException(path + " -> " + path2 + ":" + iOException.getMessage(), iOException);
        }
    }

    public static void copyFromStreamToFile(InputStream inputStream, Path path) throws IOException {
        PathUtils.copyFromStreamToFile(inputStream, path, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFromStreamToFile(InputStream inputStream, Path path, StreamCallback streamCallback, int n) throws IOException {
        if (inputStream == null) {
            throw new NullPointerException("InputStream file is null");
        }
        if (path == null) {
            throw new NullPointerException("To file is null");
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw new IOException("Unable to delete old file " + path.toAbsolutePath().toString(), iOException);
        }
        if (path.getParent() != null && Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        try {
            Files.createFile(path, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw new IOException("Unable to create file " + path.toAbsolutePath().toString(), iOException);
        }
        if (!Files.isWritable(path)) {
            throw new IOException("Unable to write to " + path.toAbsolutePath().toString());
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            int n2;
            byte[] byArray = new byte[8192];
            long l = 0L;
            while ((n2 = inputStream.read(byArray)) >= 0) {
                boolean bl;
                ((OutputStream)bufferedOutputStream).write(byArray, 0, n2);
                if (streamCallback == null || !(bl = streamCallback.streamPositionReached(l += (long)n2, n))) continue;
                throw new IOException("Stream read break requested by callback. " + streamCallback);
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void rawCopy(Path path, Path path2) throws IOException {
        Reject.ifNull(path, "Source file is null");
        Reject.ifNull(path2, "Target file is null");
        FileSystemProvider fileSystemProvider = path2.getFileSystem().provider();
        FileSystemProvider fileSystemProvider2 = path.getFileSystem().provider();
        try (OutputStream outputStream = fileSystemProvider.newOutputStream(path2, new OpenOption[0]);
             InputStream inputStream = fileSystemProvider2.newInputStream(path, new OpenOption[0]);){
            int n = 8192;
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            while (n2 != -1) {
                outputStream.write(byArray, 0, n2);
                n2 = inputStream.read(byArray);
            }
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static void rawCopy(InputStream inputStream, OutputStream outputStream) throws IOException {
        Reject.ifNull(inputStream, "Source is null");
        Reject.ifNull(outputStream, "Target is null");
        try (InputStream inputStream2 = inputStream;
             OutputStream outputStream2 = outputStream;){
            int n = 8192;
            byte[] byArray = new byte[n];
            int n2 = inputStream2.read(byArray);
            while (n2 != -1) {
                outputStream2.write(byArray, 0, n2);
                n2 = inputStream2.read(byArray);
            }
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static void recursiveDelete(Path path) throws IOException {
        PathUtils.recursiveDelete(path, new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path path) {
                return true;
            }
        });
    }

    public static void recursiveDelete(Path path, DirectoryStream.Filter<Path> filter) throws IOException {
        if (path == null || filter == null) {
            return;
        }
        if (!filter.accept(path)) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, filter);){
                for (Path path2 : directoryStream) {
                    PathUtils.recursiveDelete(path2);
                }
            }
            catch (IOException iOException) {
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
                throw iOException;
            }
        }
        try {
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw new IOException("Could not delete file " + path.toAbsolutePath(), iOException);
        }
    }

    public static void recursiveMove(Path path, Path path2) throws IOException {
        Reject.ifNull(path, "Source directory is null");
        Reject.ifNull(path2, "Target directory is null");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        boolean bl = Files.isHidden(path);
        if (Files.isDirectory(path, new LinkOption[0]) && Files.notExists(path2, new LinkOption[0])) {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.isDirectory(path2, new LinkOption[0])) {
            if (PathUtils.isSubdirectory(path, path2)) {
                throw new IOException("Move to a subdirectory not permitted");
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path3 : directoryStream) {
                    PathUtils.recursiveMove(path3, path2.resolve(path3.getFileName()));
                }
                Files.delete(path);
            }
        } else if (!Files.isDirectory(path, new LinkOption[0]) && !Files.isDirectory(path2, new LinkOption[0])) {
            Files.move(path, path2, new CopyOption[0]);
        } else {
            throw new UnsupportedOperationException("Can only move directory to directory or file to file: " + path.toAbsolutePath().toString() + " --> " + path2.toAbsolutePath().toString());
        }
        if (bl) {
            PathUtils.setAttributesOnWindows(path2, true, null);
        }
    }

    public static void recursiveCopy(Path path2, Path path3) throws IOException {
        PathUtils.recursiveCopy(path2, path3, path -> true);
    }

    public static void recursiveCopy(Path path, Path path2, DirectoryStream.Filter<Path> filter) throws IOException {
        Reject.ifNull(path, "Source directory is null");
        Reject.ifNull(path2, "Target directory is null");
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.notExists(path2, new LinkOption[0])) {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        if (Files.isDirectory(path, new LinkOption[0]) && Files.isDirectory(path2, new LinkOption[0])) {
            if (PathUtils.isSubdirectory(path, path2)) {
                throw new IOException("Copy to a subdirectory not permitted");
            }
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, filter);){
                for (Path path3 : directoryStream) {
                    String string = path3.getFileName().toString();
                    Path path4 = path2.resolve(string);
                    PathUtils.recursiveCopy(path3, path4, filter);
                }
            }
        } else if (!Files.isDirectory(path, new LinkOption[0]) && !Files.isDirectory(path2, new LinkOption[0]) && filter.accept(path)) {
            PathUtils.copyFile(path, path2);
        } else {
            throw new UnsupportedOperationException("Can only copy directory to directory or file to file: " + path.toAbsolutePath().toString() + " --> " + path2.toAbsolutePath().toString());
        }
    }

    public static byte[] digest(Path path, MessageDigest messageDigest, ProgressListener progressListener) throws IOException, InterruptedException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            int n;
            byte[] byArray = new byte[8192];
            long l = Files.size(path);
            long l2 = 0L;
            while ((n = inputStream.read(byArray)) > 0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                messageDigest.update(byArray, 0, n);
                l2 += (long)n;
                if (progressListener == null) continue;
                progressListener.progressReached((double)l2 * 100.0 / (double)l);
            }
            byte[] byArray2 = messageDigest.digest();
            return byArray2;
        }
    }

    public static boolean isSubdirectory(Path path, Path path2) {
        String string = path.toAbsolutePath().toString();
        if (path2.getParent() == null) {
            return false;
        }
        String string2 = path2.getParent().toAbsolutePath().toString();
        if (string == null || string2 == null) {
            return false;
        }
        return string2.startsWith(string);
    }

    public static Path buildFileFromRelativeName(Path path, String string) {
        Reject.ifNull(path, "Need a base directory");
        Reject.ifNull(string, "RelativeName required");
        if (string.indexOf(47) == -1) {
            return path.resolve(string);
        }
        String[] stringArray = string.split("/");
        Path path2 = path;
        for (String string2 : stringArray) {
            path2 = path2.resolve(string2);
        }
        return path2;
    }

    public static boolean isFileInDirectory(Path path, Path path2) {
        Reject.ifTrue(path == null || path2 == null, "File and directory may not be null");
        Path path3 = path.getParent();
        String string = path3 == null ? path.getFileSystem().getSeparator() : path3.toAbsolutePath().toString();
        String string2 = path2.toAbsolutePath().toString();
        if (log.isLoggable(Level.FINER)) {
            log.finer("File parent: " + string);
            log.finer("Directory: " + string2);
        }
        return string.startsWith(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void maintainDesktopIni(Controller controller, Path path) {
        if (!OSUtil.isWindowsSystem() || OSUtil.isWebStart()) {
            return;
        }
        if (path == null || Files.notExists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            return;
        }
        Path path2 = path.resolve(DESKTOP_INI_FILENAME);
        boolean bl = Files.exists(path2, new LinkOption[0]);
        boolean bl2 = ConfigurationEntry.USE_PF_ICON.getValueBoolean(controller);
        try {
            if (bl && Files.getLastModifiedTime(path2, new LinkOption[0]).toMillis() < 1383177600000L) {
                try {
                    Files.delete(path2);
                    bl = false;
                }
                catch (IOException iOException) {
                    bl = true;
                }
            }
        }
        catch (IOException iOException) {
            log.info("Could not access last modification date. " + iOException);
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            return;
        }
        if (!bl && bl2) {
            PrintWriter printWriter = null;
            try {
                Path path3 = PathUtils.findDistributionFile(controller, "Folder.ico");
                if (path3 == null) {
                    String string = controller.getDistribution().getBinaryName() + ".exe";
                    path3 = PathUtils.findDistributionFile(controller, string);
                }
                if (path3 == null || Files.notExists(path3, new LinkOption[0])) {
                    return;
                }
                printWriter = new PrintWriter(Files.newOutputStream(path.resolve(DESKTOP_INI_FILENAME), new OpenOption[0]));
                printWriter.println("[.ShellClassInfo]");
                printWriter.println("ConfirmFileOp=0");
                printWriter.println("IconFile=" + path3.toAbsolutePath());
                printWriter.println("IconIndex=0");
                printWriter.println("InfoTip=" + Translation.get("folder.info_tip"));
                printWriter.println("IconResource=" + path3.toAbsolutePath() + ",0");
                printWriter.println("[ViewState]");
                printWriter.println("Mode=");
                printWriter.println("Vid=");
                printWriter.println("FolderType=Generic");
                printWriter.flush();
                PathUtils.setAttributesOnWindows(path2, true, true);
                PathUtils.setAttributesOnWindows(path, null, true);
            }
            catch (IOException iOException) {
                log.warning("Problem writing Desktop.ini file(s). " + iOException);
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            }
            finally {
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (bl && !bl2) {
            try {
                Files.delete(path2);
                PathUtils.setAttributesOnWindows(path, null, false);
            }
            catch (IOException iOException) {
                log.info("Could not delete ini file. " + iOException);
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            }
        }
    }

    private static Path findDistributionFile(Controller controller, String string) {
        Path path = Controller.getMiscFilesLocation().resolve("skin/client/" + string);
        if (Files.notExists(path, new LinkOption[0]) && Files.notExists(path = Paths.get(".", new String[0]).toAbsolutePath().resolve(string), new LinkOption[0]) && Files.notExists(path = WinUtils.getProgramInstallationPath(controller).resolve(string), new LinkOption[0])) {
            log.fine("Could not find " + path.getFileName() + " at " + path.getParent().toAbsolutePath());
            return null;
        }
        return path;
    }

    public static void deleteDesktopIni(Path path) {
        Path path2 = path.resolve(DESKTOP_INI_FILENAME);
        boolean bl = Files.exists(path2, new LinkOption[0]);
        if (bl) {
            try {
                Files.delete(path2);
                PathUtils.setAttributesOnWindows(path, null, false);
            }
            catch (IOException iOException) {
                log.info("Could not delete ini file. " + iOException);
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            }
        }
    }

    public static Long[] calculateDirectorySizeAndCount(Path path) {
        return PathUtils.calculateDirectorySizeAndCount0(path, 0);
    }

    private static Long[] calculateDirectorySizeAndCount0(Path path, int n) {
        if (n == 100) {
            return new Long[]{0L, 0L};
        }
        long l = 0L;
        long l2 = 0L;
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    Long[] longArray = PathUtils.calculateDirectorySizeAndCount0(path2, n + 1);
                    l += longArray[0].longValue();
                    l2 += longArray[1].longValue();
                    continue;
                }
                l += Files.size(path2);
                ++l2;
            }
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            return new Long[]{0L, 0L};
        }
        return new Long[]{l, l2};
    }

    public static void zipFile(Path path, Path path2) throws IOException {
        int n;
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Not a file:  " + path);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(Files.newOutputStream(path2, new OpenOption[0]));
        InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
        ZipEntry zipEntry = new ZipEntry(path.getFileName().toString());
        zipOutputStream.putNextEntry(zipEntry);
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        inputStream.close();
        zipOutputStream.close();
    }

    public static boolean containsInvalidChar(String string) {
        if (".".equals(string) || "..".equals(string)) {
            return true;
        }
        if (string.endsWith(" ")) {
            return true;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (-1 == INVALID_CHARS.indexOf(c)) continue;
            return true;
        }
        return false;
    }

    public static String removeInvalidFilenameChars(String object) {
        Reject.ifBlank((String)object, "Filename is blank");
        for (int i = 0; i < INVALID_CHARS.length(); ++i) {
            char c = INVALID_CHARS.charAt(i);
            while (((String)object).indexOf(c) != -1) {
                int n = ((String)object).indexOf(c);
                object = ((String)object).substring(0, n) + "_" + ((String)object).substring(n + 1);
            }
        }
        Object object2 = "";
        while (((String)object).endsWith(".")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
            object2 = (String)object2 + "_";
        }
        object = (String)object + (String)object2;
        object = ((String)object).trim();
        Reject.ifBlank((String)object, "Filename is blank");
        return object;
    }

    @NotNull
    public static Path removeInvalidFilenameChars(@NotNull Path path) {
        if (path.getFileName() == null) {
            return path;
        }
        String string = path.getFileName().toString();
        String string2 = PathUtils.removeInvalidFilenameChars(string);
        if (path.getParent() == null) {
            return Paths.get(string2, new String[0]);
        }
        return path.getParent().resolve(string2);
    }

    @NotNull
    public static String encodeURLinFilename(@NotNull String string) {
        string = string.replace("://", "___");
        string = string.replace("/", "_");
        string = string.replace(":", "_");
        return "_s_" + string + "_";
    }

    public static String decodeURLFromFilename(String string) {
        if (!string.contains("_s_")) {
            return null;
        }
        int n = string.indexOf("_s_");
        int n2 = string.lastIndexOf("_");
        if (n < 0 || n2 < 0) {
            return null;
        }
        String string2 = string.substring(n + 3, n2);
        string2 = string2.replace("___", "://");
        try {
            new URL(string2.replace("_", ":"));
            string2 = string2.replace("_", ":");
        }
        catch (Exception exception) {
            string2 = string2.replace("_", "/");
        }
        return string2;
    }

    public static void ncopy(RandomAccessFile randomAccessFile, RandomAccessFile randomAccessFile2, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0; i -= n2) {
            n2 = randomAccessFile.read(byArray);
            if (n2 < 0) {
                throw new EOFException();
            }
            randomAccessFile2.write(byArray, 0, n2);
        }
    }

    public static void ncopy(FileChannel fileChannel, FileChannel fileChannel2, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0; i -= n2) {
            n2 = fileChannel.read(ByteBuffer.wrap(byArray));
            if (n2 < 0) {
                throw new EOFException();
            }
            fileChannel2.write(ByteBuffer.wrap(byArray, 0, n2));
        }
    }

    public static void ncopy(InputStream inputStream, RandomAccessFile randomAccessFile, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0; i -= n2) {
            n2 = inputStream.read(byArray);
            if (n2 < 0) {
                throw new EOFException();
            }
            randomAccessFile.write(byArray, 0, n2);
        }
    }

    public static void ncopy(InputStream inputStream, FileChannel fileChannel, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        for (int i = n; i > 0; i -= n2) {
            n2 = inputStream.read(byArray);
            if (n2 < 0) {
                throw new EOFException();
            }
            fileChannel.write(ByteBuffer.wrap(byArray, 0, n2));
        }
    }

    public static boolean openFileIfExists(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            log.fine("File to open does not exist: " + path.toAbsolutePath().toString());
            return false;
        }
        return PathUtils.openFile(path);
    }

    public static boolean openFile(Path path) {
        Reject.ifNull(path, "File is null");
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(path.toFile());
                return true;
            }
            catch (IOException iOException) {
                log.warning("Unable to open file " + path + ". " + iOException);
                IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
                return false;
            }
        }
        if (OSUtil.isLinux()) {
            try {
                Runtime.getRuntime().exec("/usr/bin/xdg-open " + path.toUri().toString());
                return true;
            }
            catch (Exception exception) {
                log.warning("Unable to open file " + path + ". " + exception);
                return false;
            }
        }
        if (OSUtil.isWindowsSystem()) {
            try {
                new ProcessBuilder("cmd", "/c", "start", path.toString()).start();
                return true;
            }
            catch (IOException iOException) {
                log.warning("Unable to open file " + path + ". " + iOException);
                return false;
            }
        }
        log.warning("Unable to open file " + path + ". Java Desktop not supported");
        return false;
    }

    public static boolean setAttributesOnWindows(Path path, Boolean bl, Boolean bl2) {
        if (!OSUtil.isWindowsSystem() || OSUtil.isWindowsMEorOlder()) {
            return false;
        }
        if (bl == null && bl2 == null) {
            return true;
        }
        boolean bl3 = false;
        if (bl != null) {
            try {
                Files.setAttribute(path, "dos:hidden", bl, new LinkOption[0]);
            }
            catch (IOException iOException) {
                log.warning("Unable to set/unset hidden attribute for " + path + ". " + iOException);
                bl3 = true;
            }
        }
        if (bl2 != null) {
            try {
                Files.setAttribute(path, "dos:system", bl2, new LinkOption[0]);
            }
            catch (IOException iOException) {
                log.warning("Unable to set/unset system attribute for " + path + ". " + iOException);
                bl3 = true;
            }
        }
        if (!bl3) {
            return true;
        }
        try {
            Object object = "attrib ";
            if (bl != null) {
                object = bl != false ? (String)object + "+" : (String)object + "-";
                object = (String)object + "h";
                object = (String)object + " ";
            }
            if (bl2 != null) {
                object = bl2 != false ? (String)object + "+" : (String)object + "-";
                object = (String)object + "s";
                object = (String)object + " ";
            }
            object = (String)object + " \"" + path.toAbsolutePath().toString() + "\"";
            Process process = Runtime.getRuntime().exec((String)object);
            process.getOutputStream();
            process.waitFor();
            return true;
        }
        catch (IOException iOException) {
            log.log(Level.FINER, "IOException", iOException);
            return false;
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.FINER, "InterruptedException", interruptedException);
            return false;
        }
    }

    public static boolean isScannable(Path path, Folder folder) {
        return PathUtils.isScannable(path.toString(), folder);
    }

    public static boolean isScannable(String string, Folder folder) {
        int n;
        Reject.ifNull(folder, "Folder must not be null");
        Reject.ifNull(string, "File name must not be null");
        if (string.endsWith(".temp-dir")) {
            return false;
        }
        if (string.endsWith("Icon\r")) {
            return false;
        }
        int n2 = string.indexOf(Constants.POWERFOLDER_SYSTEM_SUBDIR);
        if (n2 < 0) {
            return true;
        }
        if (folder.getInfo().isMetaFolder() && (n = string.indexOf("meta", n2)) >= 0) {
            int n3 = string.indexOf(Constants.POWERFOLDER_SYSTEM_SUBDIR, n + "meta".length());
            return n3 < 0;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasContents(Path path2) {
        Reject.ifNull(path2, "Base is null");
        Reject.ifFalse(Files.isDirectory(path2, new LinkOption[0]), "Base is not folder");
        DirectoryStream.Filter<Path> filter = path -> !path.getFileName().toString().equals(Constants.POWERFOLDER_SYSTEM_SUBDIR);
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, filter);){
            if (directoryStream == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<Path> iterator = directoryStream.iterator();
            if (iterator == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = iterator.hasNext();
            return bl;
        }
        catch (IOException iOException) {
            log.info("Could not check for content. " + iOException);
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            return false;
        }
    }

    public static boolean hasFiles(Path path) {
        Reject.ifNull(path, "Base is null");
        Reject.ifFalse(Files.isDirectory(path, new LinkOption[0]), "Base is not folder");
        return PathUtils.hasFilesInternal(path, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasFilesInternal(Path path, int n) {
        if (n > 100) {
            // empty if block
        }
        if (path.getFileName().toString().equals(Constants.POWERFOLDER_SYSTEM_SUBDIR)) {
            return false;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
            for (Path path2 : directoryStream) {
                if (!Files.isDirectory(path2, new LinkOption[0])) {
                    boolean bl = true;
                    return bl;
                }
                if (!PathUtils.hasFilesInternal(path2, n + 1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            log.info(iOException.getMessage());
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            return false;
        }
    }

    public static void recursiveCopyVisitor(final Path path, final Path path2) throws IOException {
        if (Files.exists(path2, new LinkOption[0]) && !EncryptedFileSystemUtils.isEmptyCryptoContainerRootDir(path2)) {
            throw new FileAlreadyExistsException("Copy from " + path + " to " + path2 + " failed! Target directory already exists " + path2);
        }
        if (PathUtils.isSubdirectory(path, path2)) {
            throw new IOException("Target " + path2 + " must not be a subdirectory of source " + path);
        }
        try {
            Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                    Path path22 = path2.resolve(path.relativize(path3));
                    Files.copy(path3, path22, copyOptionArray);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES};
                    Path path22 = path2.resolve(path.relativize(path3));
                    try {
                        Files.copy(path3, path22, copyOptionArray);
                        FileTime fileTime = Files.getLastModifiedTime(path3, new LinkOption[0]);
                        FileTime fileTime2 = Files.getLastModifiedTime(path22, new LinkOption[0]);
                        if (!fileTime.equals(fileTime2)) {
                            Files.setLastModifiedTime(path22, fileTime);
                        }
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        log.warning("Source file not available while copy: " + path3 + " to " + path22 + ": " + noSuchFileException);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path3, IOException iOException) throws IOException {
                    if (iOException == null) {
                        FileTime fileTime;
                        Path path22 = path2.resolve(path.relativize(path3));
                        FileTime fileTime2 = Files.getLastModifiedTime(path3, new LinkOption[0]);
                        if (!fileTime2.equals(fileTime = Files.getLastModifiedTime(path22, new LinkOption[0]))) {
                            Files.setLastModifiedTime(path22, fileTime2);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path3, IOException iOException) throws IOException {
                    throw iOException;
                }
            });
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static void recursiveMoveVisitor(final Path path, final Path path2) throws IOException {
        if (Files.exists(path2, new LinkOption[0]) && !EncryptedFileSystemUtils.isEmptyCryptoContainerRootDir(path2)) {
            throw new FileAlreadyExistsException("Move from " + path + " to " + path2 + " failed! Target directory already exists " + path2);
        }
        try {
            Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path22 = path2.resolve(path.relativize(path3).toString());
                    if (Files.notExists(path22, new LinkOption[0])) {
                        Files.createDirectories(path22, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path22 = path2.resolve(path.relativize(path3).toString());
                    try {
                        Files.move(path3, path22, new CopyOption[0]);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        log.warning("Source file not available while move: " + path3 + " to " + path22 + ": " + noSuchFileException);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path3, IOException iOException) throws IOException {
                    if (iOException == null) {
                        try {
                            Files.delete(path3);
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                            log.warning("Source directory not empty while move: " + path3 + ": " + directoryNotEmptyException);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw iOException;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path3, IOException iOException) throws IOException {
                    throw iOException;
                }
            });
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static void recursiveMoveCopyFallbackVisitor(final Path path, final Path path2) throws IOException {
        if (Files.exists(path2, new LinkOption[0]) && !EncryptedFileSystemUtils.isEmptyCryptoContainerRootDir(path2)) {
            throw new FileAlreadyExistsException("Move from " + path + " to " + path2 + " failed! Target directory already exists " + path2);
        }
        try {
            Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path4, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path22 = path.relativize(path4);
                    Path path3 = path2.resolve(path22.toString());
                    if (Files.notExists(path3, new LinkOption[0])) {
                        Files.createDirectories(path3, new FileAttribute[0]);
                        try {
                            Files.setLastModifiedTime(path3, Files.getLastModifiedTime(path4, new LinkOption[0]));
                        }
                        catch (IOException iOException) {
                            log.warning("Unable to set same modification date to new dir " + path3 + ". from " + path4 + ". " + iOException);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path path3, BasicFileAttributes basicFileAttributes) throws IOException {
                    Path path22 = path2.resolve(path.relativize(path3).toString());
                    try {
                        Files.move(path3, path22, new CopyOption[0]);
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        log.warning("Source file not available while move: " + path3 + " to " + path22 + ": " + noSuchFileException);
                    }
                    catch (IOException iOException) {
                        log.fine("Coping file. Not able to move file " + path3 + " to " + path22 + ": " + iOException);
                        try {
                            Files.copy(path3, path22, new CopyOption[0]);
                            Files.setLastModifiedTime(path22, Files.getLastModifiedTime(path3, new LinkOption[0]));
                            Files.delete(path3);
                        }
                        catch (IOException iOException2) {
                            log.warning("Unable to copy new file " + path22 + " from " + path3 + ". " + iOException2);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path3, IOException iOException) throws IOException {
                    if (iOException == null) {
                        try {
                            Files.delete(path3);
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                            log.warning("Source directory not empty while move: " + path3 + ": " + directoryNotEmptyException);
                        }
                        catch (IOException iOException2) {
                            log.warning("Not able to remove directory in source: " + path3 + ": " + iOException2);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                    throw iOException;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path3, IOException iOException) throws IOException {
                    throw iOException;
                }
            });
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static void recursiveDeleteVisitor(Path path) throws IOException {
        try {
            Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException == null) {
                        Files.delete(path);
                        return FileVisitResult.CONTINUE;
                    }
                    throw iOException;
                }

                @Override
                public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
                    throw iOException;
                }
            });
        }
        catch (IOException iOException) {
            IO_EXCEPTION_LISTENER.exceptionThrown(iOException);
            throw iOException;
        }
    }

    public static boolean deleteIncompletedTransferFiles(Path path2, int n) {
        boolean bl;
        block11: {
            Reject.ifFalse(Files.isDirectory(path2, new LinkOption[0]), "Invalid directory: " + path2.toAbsolutePath());
            Instant instant = Instant.now().minus(n, ChronoUnit.DAYS);
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path2, path -> {
                try {
                    if (!Files.isRegularFile(path, new LinkOption[0])) {
                        return false;
                    }
                    String string = path.getFileName().toString();
                    boolean bl = INCOMPLETE_FILES_PREFIXES.stream().anyMatch(string::startsWith);
                    boolean bl2 = Files.getLastModifiedTime(path, new LinkOption[0]).toInstant().isBefore(instant);
                    return bl && bl2;
                }
                catch (IOException iOException) {
                    log.fine("[SKIPPED] Could not check file " + path.toAbsolutePath() + " - " + iOException.getMessage());
                    return false;
                }
            });
            try {
                for (Path path3 : directoryStream) {
                    try {
                        Files.delete(path3);
                        log.fine("[DELETED] " + path3.toAbsolutePath());
                    }
                    catch (IOException iOException) {
                        log.fine("[FAILED] to delete " + path3.toAbsolutePath() + " - " + iOException.getMessage());
                    }
                }
                bl = true;
                if (directoryStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    log.warning("[FAILED] to delete incompleted download files at " + path2.toAbsolutePath() + " - " + iOException.getMessage());
                    return false;
                }
            }
            directoryStream.close();
        }
        return bl;
    }

    public static boolean isWebDAVFolder(Path path) {
        if (path.getFileName() == null) {
            return false;
        }
        String string = path.getFileName().toString();
        return string.contains(".webdav");
    }

    public static boolean isFilenameTooLong(Exception exception) {
        Reject.ifNull(exception, "Exception");
        return exception.getMessage().toLowerCase().contains("name too long") || exception.toString().toLowerCase().contains("name too long");
    }

    public static boolean isQuotaLimitHit(Exception exception) {
        Reject.ifNull(exception, "Exception");
        return exception.getMessage().toLowerCase().contains("quota exceeded");
    }
}

