/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.util;

import java.math.BigInteger;

public class Base58 {
    private static final String ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static final BigInteger BASE = BigInteger.valueOf(58L);

    public static String encode(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        StringBuffer stringBuffer = new StringBuffer();
        while (bigInteger.compareTo(BASE) >= 0) {
            BigInteger bigInteger2 = bigInteger.mod(BASE);
            stringBuffer.insert(0, ALPHABET.charAt(bigInteger2.intValue()));
            bigInteger = bigInteger.subtract(bigInteger2).divide(BASE);
        }
        stringBuffer.insert(0, ALPHABET.charAt(bigInteger.intValue()));
        for (Object object : (BigInteger)byArray) {
            if (object != false) break;
            stringBuffer.insert(0, ALPHABET.charAt(0));
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        byte[] byArray = Base58.decodeToBigInteger(string).toByteArray();
        boolean bl = byArray.length > 1 && byArray[0] == 0 && byArray[1] < 0;
        int n = 0;
        int n2 = 0;
        while (string.charAt(n2) == ALPHABET.charAt(0)) {
            ++n;
            ++n2;
        }
        byte[] byArray2 = new byte[byArray.length - (bl ? 1 : 0) + n];
        System.arraycopy(byArray, bl ? 1 : 0, byArray2, n, byArray2.length - n);
        return byArray2;
    }

    private static BigInteger decodeToBigInteger(String string) throws IllegalArgumentException {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        for (int i = string.length() - 1; i >= 0; --i) {
            int n = ALPHABET.indexOf(string.charAt(i));
            if (n == -1) {
                throw new IllegalArgumentException("Illegal character " + string.charAt(i) + " at " + i);
            }
            bigInteger = bigInteger.add(BigInteger.valueOf(n).multiply(BASE.pow(string.length() - 1 - i)));
        }
        return bigInteger;
    }
}

