/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Constants;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Waiter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import jwf.WizardPanel;

public class TextPanelPanel
extends PFWizardPanel {
    private boolean autoFadeOut;
    private String title;
    private String text;

    public TextPanelPanel(Controller controller, String string, String string2) {
        this(controller, string, string2, false);
    }

    public TextPanelPanel(Controller controller, String string, String string2, boolean bl) {
        super(controller);
        this.title = string;
        this.text = string2;
        this.autoFadeOut = bl;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    protected void afterDisplay() {
        Object object;
        if (PFWizard.hideFolderJoinWizard(this.getController())) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDialog jDialog = TextPanelPanel.this.getWizardDialog();
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            });
        }
        new FadeOutWorker().execute();
        Object object2 = this.getWizardContext().getAttribute("folder.is.invite");
        if (object2 != null && object2 instanceof Boolean && ((Boolean)object2).booleanValue() && (object = this.getWizardContext().getAttribute("disklocation.folder_info")) != null && object instanceof FolderInfo) {
            this.getController().getUIController().displayInviteFolderContents((FolderInfo)object);
        }
    }

    @Override
    public WizardPanel next() {
        return null;
    }

    @Override
    public boolean canFinish() {
        return true;
    }

    @Override
    public boolean canCancel() {
        return false;
    }

    @Override
    protected JPanel buildContent() {
        Folder folder;
        Object object;
        FormLayout formLayout = new FormLayout("pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
        int n = 1;
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
            } else {
                panelBuilder.appendRow("pref");
                ++n;
            }
            panelBuilder.addLabel((String)object, cellConstraints.xy(1, n));
        }
        if (!this.autoFadeOut && (object = (FolderInfo)this.getWizardContext().getAttribute("disklocation.folder_info")) != null && (folder = this.getController().getFolderRepository().getFolder((FolderInfo)object)) != null) {
            panelBuilder.appendRow("10dlu");
            ++n;
            panelBuilder.appendRow("pref");
            ActionLabel actionLabel = new ActionLabel(this.getController(), new OpenFolderAction(this.getController(), (FolderInfo)object));
            actionLabel.convertToBigLabel();
            panelBuilder.add((Component)actionLabel.getUIComponent(), cellConstraints.xy(1, ++n));
            if (ConfigurationEntry.SERVER_INVITE_ENABLED.getValueBoolean(this.getController()).booleanValue()) {
                panelBuilder.appendRow("7dlu");
                ++n;
                panelBuilder.appendRow("pref");
                ActionLabel actionLabel2 = new ActionLabel(this.getController(), new SendInviteAction(this.getController(), (FolderInfo)object));
                actionLabel2.convertToBigLabel();
                panelBuilder.add((Component)actionLabel2.getUIComponent(), cellConstraints.xy(1, ++n));
                actionLabel2.setVisible(false);
                new SwingWorker<Boolean, Boolean>((FolderInfo)object, actionLabel2){
                    final /* synthetic */ FolderInfo val$folderInfo;
                    final /* synthetic */ ActionLabel val$sendInviteLabel;
                    {
                        this.val$folderInfo = folderInfo;
                        this.val$sendInviteLabel = actionLabel;
                    }

                    @Override
                    protected Boolean doInBackground() {
                        Waiter waiter = new Waiter(5000L);
                        while (!waiter.isTimeout()) {
                            waiter.waitABit();
                            boolean bl = TextPanelPanel.this.getController().getSecurityManager().hasPermission(TextPanelPanel.this.getController().getOSClient().getAccount(), (Permission)FolderPermission.admin(this.val$folderInfo));
                            if (!bl) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.val$sendInviteLabel.setVisible((Boolean)this.get());
                        }
                        catch (Exception exception) {
                            this.val$sendInviteLabel.setVisible(true);
                        }
                    }
                }.execute();
            }
        }
        return panelBuilder.getPanel();
    }

    @Override
    protected void initComponents() {
    }

    @Override
    protected String getTitle() {
        return this.title;
    }

    private JDialog getWizardDialog() {
        return (JDialog)this.getWizardContext().getAttribute("dialog");
    }

    private class FadeOutWorker
    extends SwingWorker<Void, Integer> {
        private FadeOutWorker() {
        }

        @Override
        protected void process(List<Integer> list) {
            if (!TextPanelPanel.this.getWizardDialog().isVisible()) {
                return;
            }
            float f = 1.0f - (float)list.get(0).intValue() / 100.0f;
            UIUtil.applyTranslucency(TextPanelPanel.this.getWizardDialog(), Float.valueOf(f));
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.sleep(1000L);
            if (!Constants.OPACITY_SUPPORTED) {
                Thread.sleep(1000L);
                return null;
            }
            for (int i = 0; i < 100; ++i) {
                this.publish(i);
                Thread.sleep(10L);
            }
            this.publish(100);
            return null;
        }

        @Override
        protected void done() {
            JDialog jDialog = TextPanelPanel.this.getWizardDialog();
            jDialog.setVisible(false);
            jDialog.dispose();
        }
    }

    private static class OpenFolderAction
    extends BaseAction {
        private final FolderInfo folderInfo;

        private OpenFolderAction(Controller controller, FolderInfo folderInfo) {
            super("action_open_folder", controller);
            this.folderInfo = folderInfo;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Folder folder = this.folderInfo.getFolder(this.getController());
            PathUtils.openFile(folder.getLocalBase());
        }
    }

    private class SendInviteAction
    extends BaseAction {
        private final FolderInfo folderInfo;

        private SendInviteAction(Controller controller, FolderInfo folderInfo) {
            super("action_invite_friend", controller);
            this.folderInfo = folderInfo;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDialog jDialog = TextPanelPanel.this.getWizardDialog();
            jDialog.setVisible(false);
            jDialog.dispose();
            PFWizard.openSendInvitationWizard(this.getController(), this.folderInfo);
        }
    }
}

