/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.wizard.SendInvitationsPanel;
import de.dal33t.powerfolder.ui.wizard.SwingWorkerPanel;
import de.dal33t.powerfolder.util.Translation;
import jwf.WizardPanel;

public class FolderAutoConfigPanel
extends SwingWorkerPanel {
    public FolderAutoConfigPanel(Controller controller) {
        super(controller, null, Translation.get("wizard.create_folder.title"), Translation.get("wizard.create_folder.working"), null);
        this.setTask(new MyFolderCreateWorker());
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.create_folder.title");
    }

    @Override
    public WizardPanel next() {
        boolean bl = Boolean.TRUE.equals(this.getWizardContext().getAttribute("disklocation.send_invitations"));
        if (bl) {
            return new SendInvitationsPanel(this.getController());
        }
        return (WizardPanel)this.getWizardContext().getAttribute("successpanel");
    }

    private class MyFolderCreateWorker
    implements Runnable {
        private MyFolderCreateWorker() {
        }

        @Override
        public void run() {
            FolderInfo folderInfo = (FolderInfo)FolderAutoConfigPanel.this.getWizardContext().getAttribute("disklocation.folder_info");
            boolean bl = (Boolean)FolderAutoConfigPanel.this.getWizardContext().getAttribute("use.cloud.storage");
            SyncProfile syncProfile = (SyncProfile)FolderAutoConfigPanel.this.getWizardContext().getAttribute("disklocation.sync_profile");
            Folder folder = FolderAutoConfigPanel.this.getController().getFolderRepository().getFolder(folderInfo);
            folder.setSyncProfile(syncProfile);
            ServerClient serverClient = FolderAutoConfigPanel.this.getController().getOSClient();
            if (serverClient.isConnected() && serverClient.isLoggedIn()) {
                boolean bl2 = serverClient.joinedByCloud(folder);
                if (!bl2 && bl) {
                    serverClient.getFolderService().createFolder(folderInfo, null);
                } else if (bl2 && !bl) {
                    serverClient.getFolderService(folderInfo).removeFolder(folderInfo, true, false);
                }
            }
        }
    }
}

