/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.wizard;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.clientserver.FolderService;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.disk.FileArchiver;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.FileConflictProblem;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.ui.wizard.MultiFileRestorePanel;
import de.dal33t.powerfolder.ui.wizard.PFWizardPanel;
import de.dal33t.powerfolder.ui.wizard.TextPanelPanel;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;
import jwf.WizardPanel;

public class FileRestoringPanel
extends PFWizardPanel {
    private static final Logger log = Logger.getLogger(MultiFileRestorePanel.class.getName());
    private final List<FileInfo> fileInfosToRestore;
    private final JLabel statusLabel;
    private final JProgressBar bar;
    private SwingWorker<List<FileInfo>, FileInfo> worker;
    private int filesProcessedSuccessfully;
    private Path alternateLocation;
    private String alternateName;

    public FileRestoringPanel(Controller controller, List<FileInfo> list) {
        super(controller);
        this.fileInfosToRestore = list;
        this.bar = new JProgressBar(0, 100);
        this.statusLabel = new JLabel();
    }

    private FileRestoringPanel(Controller controller, FileInfo fileInfo, Path path, String string) {
        this(controller, Collections.singletonList(fileInfo));
        if (path != null && string != null) {
            throw new IllegalArgumentException("Can't have both alternates.");
        }
        this.alternateLocation = path;
        this.alternateName = string;
    }

    public FileRestoringPanel(Controller controller, Folder folder, FileInfo fileInfo) {
        this(controller, fileInfo, null, null);
    }

    public FileRestoringPanel(Controller controller, Folder folder, FileInfo fileInfo, Path path) {
        this(controller, fileInfo, path, null);
    }

    public FileRestoringPanel(Controller controller, Folder folder, FileInfo fileInfo, String string) {
        this(controller, fileInfo, null, string);
    }

    @Override
    protected JComponent buildContent() {
        FormLayout formLayout = new FormLayout("140dlu, 3dlu, pref:grow", "pref, 3dlu, pref, 3dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setBorder(this.createFewContentBorder());
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.statusLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.bar, cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    @Override
    protected String getTitle() {
        return Translation.get("wizard.file_restoring.title");
    }

    @Override
    protected void initComponents() {
        this.bar.setIndeterminate(true);
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public boolean canGoBackTo() {
        return false;
    }

    @Override
    public WizardPanel next() {
        Object object = Translation.get("wizard.file_restoring.processed_success.text", String.valueOf(this.filesProcessedSuccessfully));
        if (this.filesProcessedSuccessfully < this.fileInfosToRestore.size()) {
            object = (String)object + "\n\n" + Translation.get("wizard.file_restoring.processed_fail.text", String.valueOf(this.fileInfosToRestore.size() - this.filesProcessedSuccessfully));
        }
        return new TextPanelPanel(this.getController(), Translation.get("wizard.file_restoring.processed.title"), (String)object);
    }

    @Override
    protected void afterDisplay() {
        if (this.worker != null) {
            this.worker.cancel(false);
        }
        this.worker = new RestoreWorker();
        this.worker.execute();
    }

    private class RestoreWorker
    extends SwingWorker<List<FileInfo>, FileInfo> {
        private int fileInfosProcessed;

        private RestoreWorker() {
        }

        @Override
        protected List<FileInfo> doInBackground() {
            FileRestoringPanel.this.filesProcessedSuccessfully = 0;
            ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
            for (FileInfo fileInfo : FileRestoringPanel.this.fileInfosToRestore) {
                arrayList.add(fileInfo);
                this.restore(fileInfo);
            }
            return arrayList;
        }

        private void restore(FileInfo fileInfo) {
            try {
                Object object;
                boolean bl = FileRestoringPanel.this.alternateLocation != null;
                boolean bl2 = FileRestoringPanel.this.alternateName != null;
                Folder folder = fileInfo.getFolder(FileRestoringPanel.this.getController().getFolderRepository());
                if (folder == null) {
                    log.fine("Could not find folder for file " + fileInfo + " to restore.");
                    return;
                }
                FileArchiver fileArchiver = folder.getFileArchiver();
                boolean bl3 = false;
                if (!bl2 && (bl3 = fileArchiver.restore(fileInfo, (Path)(object = bl ? FileRestoringPanel.this.alternateLocation.resolve(fileInfo.getFilenameOnly()) : fileInfo.getDiskFile(FileRestoringPanel.this.getController().getFolderRepository()))))) {
                    folder.scanChangedFile(fileInfo);
                    folder.scanAllParentDirectories(fileInfo);
                    log.info("Restored " + fileInfo.getFilenameOnly() + " from local version history");
                    FileRestoringPanel.this.filesProcessedSuccessfully++;
                }
                if (!bl3 && !bl && ((ServerClient)(object = FileRestoringPanel.this.getController().getOSClient())).isConnected() && ((ServerClient)object).isLoggedIn()) {
                    FolderService folderService = ((ServerClient)object).getFolderService(fileInfo.getFolderInfo());
                    String string = fileInfo.getRelativeName();
                    String string2 = bl2 ? FileInfo.renameRelativeFileName(string, FileRestoringPanel.this.alternateName) : string;
                    FileInfo fileInfo2 = folderService.restore(fileInfo, string2);
                    log.info("Restored " + fileInfo2.toDetailString() + " from cloud");
                    FileRestoringPanel.this.filesProcessedSuccessfully++;
                    bl3 = true;
                }
                if (bl3) {
                    this.removeFileConflictProblem(folder, fileInfo);
                } else {
                    log.warning("Failed to restore " + fileInfo.getFilenameOnly());
                }
                this.publish(fileInfo);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Failed to restore " + fileInfo.getFilenameOnly(), exception);
            }
        }

        private void removeFileConflictProblem(Folder folder, FileInfo fileInfo) {
            for (Problem problem : folder.getProblems()) {
                FileConflictProblem fileConflictProblem;
                if (!(problem instanceof FileConflictProblem) || !(fileConflictProblem = (FileConflictProblem)problem).getFileInfo().equals(fileInfo)) continue;
                folder.removeProblem(problem);
            }
        }

        @Override
        protected void process(List<FileInfo> list) {
            this.fileInfosProcessed += list.size();
            if (FileRestoringPanel.this.fileInfosToRestore.isEmpty()) {
                FileRestoringPanel.this.bar.setIndeterminate(true);
            } else {
                FileRestoringPanel.this.bar.setIndeterminate(false);
                FileRestoringPanel.this.statusLabel.setText(Translation.get("general.processed", String.valueOf(this.fileInfosProcessed), String.valueOf(FileRestoringPanel.this.fileInfosToRestore.size())));
                FileRestoringPanel.this.bar.setValue(100 * this.fileInfosProcessed / FileRestoringPanel.this.fileInfosToRestore.size());
            }
        }

        @Override
        protected void done() {
            FileRestoringPanel.this.getWizard().next();
        }
    }
}

