/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.skin.Origin;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.ui.TrayIconManager;
import de.dal33t.powerfolder.ui.util.OverlayedIcon;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.os.OSUtil;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.IconUIResource;

public class Icons {
    public static final String FILTER_TEXT_FIELD_CLEAR_BUTTON_NORMAL = "filter_text_field_clear_button_normal.icon";
    public static final String FILTER_TEXT_FIELD_CLEAR_BUTTON_HOVER = "filter_text_field_clear_button_hover.icon";
    public static final String FILTER_TEXT_FIELD_CLEAR_BUTTON_PUSH = "filter_text_field_clear_button_push.icon";
    public static final String FILTER_TEXT_FIELD_GLASS = "filter_text_field_glass.icon";
    public static final String FILTER_TEXT_FIELD_GLASS_ARROW = "filter_text_field_glass_arrow.icon";
    public static final String WINDOW_MAXIMIZE_NORMAL = "window_maximize_normal.icon";
    public static final String WINDOW_MAXIMIZE_HOVER = "window_maximize_hover.icon";
    public static final String WINDOW_MAXIMIZE_PUSH = "window_maximize_push.icon";
    public static final String WINDOW_PLUS_NORMAL = "window_plus_normal.icon";
    public static final String WINDOW_PLUS_HOVER = "window_plus_hover.icon";
    public static final String WINDOW_PLUS_PUSH = "window_plus_push.icon";
    public static final String WINDOW_MINUS_NORMAL = "window_minus_normal.icon";
    public static final String WINDOW_MINUS_HOVER = "window_minus_hover.icon";
    public static final String WINDOW_MINUS_PUSH = "window_minus_push.icon";
    public static final String ACTION_ARROW = "action_arrow.icon";
    public static final String BLANK = "blank.icon";
    public static final String WARNING = "warning.icon";
    public static final String DEBUG = "bug.icon";
    public static final String SYSTEM_MONITOR = "system_monitor.icon";
    public static final String STOP = "stop.icon";
    public static final String RUN = "run.icon";
    public static final String PAUSE = "pause.icon";
    public static final String STATUS = "status.icon";
    public static final String ADD = "add.icon";
    public static final String EDIT = "edit.icon";
    public static final String DELETE = "delete.icon";
    public static final String UNKNOWN_FILE = "unknown.icon";
    public static final String UNKNOWN_FILE_GRAY = "unknown_file_gray";
    public static final String UNKNOWN_FILE_RED = "unknown_file_red";
    public static final String SETTINGS = "settings.icon";
    public static final String PROBLEMS = "problems.icon";
    public static final String INFORMATION = "information.icon";
    public static final String ARROW_LEFT = "arrow_left.icon";
    public static final String ARROW_RIGHT = "arrow_right.icon";
    public static final String EXPAND = "expand.icon";
    public static final String COLLAPSE = "collapse.icon";
    public static final String QUESTION = "question.icon";
    public static final String SORT_UP = "sort_up.icon";
    public static final String SORT_DOWN = "sort_down.icon";
    public static final String SORT_BLANK = "sort_blank.icon";
    public static final String DIRECTORY = "directory.icon";
    public static final String DIRECTORY_OPEN = "directory_open.icon";
    public static final String NODE_MYSELF = "node_myself.icon";
    public static final String NODE_CONNECTED = "node_friend_connected.icon";
    public static final String NODE_DISCONNECTED = "node_friend_disconnected.icon";
    public static final String NODE_CONNECTING = "node_friend_disconnected.icon";
    public static final String NODE_POOR = "node_friend_poor.icon";
    public static final String NODE_MEDIUM = "node_friend_medium.icon";
    public static final String NODE_LAN = "node_friend_lan.icon";
    public static final String NODE_GROUP = "node_group.icon";
    public static final String FOLDER = "folder.icon";
    public static final String FILES = "files.icon";
    public static final String LOCAL_FOLDER = "local_folder.icon";
    public static final String ONLINE_FOLDER = "online_folder.icon";
    public static final String ONLINE_FOLDER_SMALL = "online_folder_small.icon";
    public static final String TYPICAL_FOLDER = "typical_folder.icon";
    public static final String BLACK_LIST = "black_list.icon";
    public static final String WHITE_LIST = "white_list.icon";
    public static final String DOWNLOAD = "download.icon";
    public static final String DOWNLOAD_ACTIVE = "download_active.icon";
    public static final String UPLOAD = "upload.icon";
    public static final String INACTIVE = "inactive.icon";
    public static final String TRANSFERS = "transfers.icon";
    public static final String EXPECTED = "expected.icon";
    public static final String CHECKED = "checked.icon";
    public static final String STATS = "stats.icon";
    public static final String STATUS_TAB_TELL_A_FRIEND = "status_tab_tell_friend_icon";
    public static final String TWITTER_BUTTON = "twitter.icon";
    public static final String FACEBOOK_BUTTON = "facebook.icon";
    public static final String LINKEDIN_BUTTON = "linkedin.icon";
    public static final String EMAIL_BUTTON = "email.icon";
    public static final String SYNC_COMPLETE = "sync_complete.icon";
    public static final String SYNC_INCOMPLETE = "sync_incomplete.icon";
    public static final String[] SYNC_ANIMATION = new String[]{"sync00.icon", "sync01.icon", "sync02.icon", "sync03.icon", "sync04.icon", "sync05.icon", "sync06.icon", "sync07.icon", "sync08.icon", "sync09.icon", "sync10.icon", "sync11.icon"};
    public static final String[] SYSTRAY_SYNC_ANIMATION;
    private static final String[] SYSTRAY_SYNC_ANIMATION_LOW_RES;
    private static final String[] SYSTRAY_SYNC_ANIMATION_LOW_LIGHT_RES;
    private static final String[] SYSTRAY_SYNC_ANIMATION_HI_RES;
    private static final String[] SYSTRAY_SYNC_ANIMATION_HI_LIGHT_RES;
    public static final String SYSTRAY_SYNC_COMPLETE;
    private static final String SYSTRAY_SYNC_COMPLETE_LOW_RES = "systray_sync_complete_lowres.icon";
    private static final String SYSTRAY_SYNC_COMPLETE_HIGH_RES = "systray_sync_complete_hires.icon";
    private static final String SYSTRAY_SYNC_COMPLETE_LOW_LIGHT_RES = "systray_sync_complete_lowres_light.icon";
    private static final String SYSTRAY_SYNC_COMPLETE_HIGH_LIGHT_RES = "systray_sync_complete_hires_light.icon";
    public static final String SYSTRAY_SYNC_INCOMPLETE;
    private static final String SYSTRAY_SYNC_INCOMPLETE_LOW_RES = "systray_sync_incomplete_lowres.icon";
    private static final String SYSTRAY_SYNC_INCOMPLETE_HIGH_RES = "systray_sync_incomplete_hires.icon";
    private static final String SYSTRAY_SYNC_INCOMPLETE_LOW_LIGHT_RES = "systray_sync_incomplete_lowres_light.icon";
    private static final String SYSTRAY_SYNC_INCOMPLETE_HIGH_LIGHT_RES = "systray_sync_incomplete_hires_light.icon";
    public static final String SYSTRAY_WARNING;
    private static final String SYSTRAY_WARNING_LOW_RES = "systray_warning_lowres.icon";
    private static final String SYSTRAY_WARNING_HIGH_RES = "systray_warning_hires.icon";
    private static final String SYSTRAY_WARNING_LOW_LIGHT_RES = "systray_warning_lowres_light.icon";
    private static final String SYSTRAY_WARNING_HIGH_LIGHT_RES = "systray_warning_hires_light.icon";
    public static final String SYSTRAY_PAUSE;
    private static final String SYSTRAY_PAUSE_LOW_RES = "systray_pause_lowres.icon";
    private static final String SYSTRAY_PAUSE_HIGH_RES = "systray_pause_hires.icon";
    private static final String SYSTRAY_PAUSE_LOW_LIGHT_RES = "systray_pause_lowres_light.icon";
    private static final String SYSTRAY_PAUSE_HIGH_LIGHT_RES = "systray_pause_hires_light.icon";
    public static final String LOGO128X128 = "picto_logo_128.icon";
    public static final String LOGO400UI = "power_folder_logo_400_ui.icon";
    public static final String SMALL_LOGO = "powerfolder_32.icon";
    public static final String SPLASH = "splash.icon";
    public static final String POWERED_BY = "poweredby.icon";
    private static final Logger log;
    private static final String DISABLED_EXTENSION_ADDITION = "_disabled";
    private static final Object FILE_LOCK;
    private static final Map<String, Icon> ID_ICON_MAP;
    private static final Map<String, Image> ID_IMAGE_MAP;
    private static final Map<String, Icon> EXTENSION_ICON_MAP;
    private static final Map<String, Icon> USERNAME_ICON_MAP;
    private static final String DEFAULT_PROPERTIES_FILENAME;
    private static Properties iconProperties;
    private static final List<String> UNKNOWN_ICONS;

    protected Icons() {
    }

    public static void setIconProperties(Properties properties) {
        Object object;
        Reject.ifNull(properties, "iconProperties");
        Reject.ifTrue(properties.isEmpty(), "iconProperties are empty");
        iconProperties = properties;
        for (Map.Entry<String, Icon> entry : ID_ICON_MAP.entrySet()) {
            object = entry.getValue();
            if (!(object instanceof ImageIcon)) continue;
            ImageIcon imageIcon = (ImageIcon)object;
            imageIcon.getImage().flush();
        }
        ID_ICON_MAP.clear();
        for (Map.Entry<String, Object> entry : ID_IMAGE_MAP.entrySet()) {
            object = (Image)entry.getValue();
            ((Image)object).flush();
        }
        ID_IMAGE_MAP.clear();
    }

    public static synchronized Properties getIconProperties() {
        if (iconProperties == null) {
            iconProperties = Icons.loadProperties(DEFAULT_PROPERTIES_FILENAME);
        }
        return new Properties(iconProperties);
    }

    public static Icon getIconById(String string) {
        URL uRL;
        if (string == null) {
            log.severe("Icon id null ???");
            return null;
        }
        if (UNKNOWN_ICONS.contains(string)) {
            return null;
        }
        Icon icon = ID_ICON_MAP.get(string);
        if (icon != null) {
            return icon;
        }
        if (string.equals(UNKNOWN_FILE_GRAY)) {
            icon = Icons.getGrayIcon(Icons.getIconById(UNKNOWN_FILE));
            if (icon != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Cached icon " + string);
                }
                ID_ICON_MAP.put(string, icon);
            }
            return icon;
        }
        if (string.equals(UNKNOWN_FILE_RED)) {
            icon = Icons.convertToRed(Icons.getGrayIcon(Icons.getIconById(UNKNOWN_FILE)));
            if (icon != null) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Cached icon " + string);
                }
                ID_ICON_MAP.put(string, icon);
            }
            return icon;
        }
        String string2 = Icons.getIconId(string);
        if (string2 == null) {
            if (log.isLoggable(Level.FINER)) {
                log.finer("Icon not found ID: '" + string + "'");
            }
            UNKNOWN_ICONS.add(string);
            return null;
        }
        if (Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
            try {
                if (OSUtil.isWindowsSystem()) {
                    uRL = new URL("file:///" + string2);
                }
                uRL = new URL("file://" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("Invalid icon URL");
                return null;
            }
        } else {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string2);
            if (uRL == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Icon not found '" + string + "'");
                }
                return null;
            }
        }
        icon = new ImageIcon(uRL);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Cached icon " + string);
        }
        ID_ICON_MAP.put(string, icon);
        return icon;
    }

    public static Image getImageById(String string) {
        URL uRL;
        Image image = ID_IMAGE_MAP.get(string);
        if (image != null) {
            return image;
        }
        String string2 = Icons.getIconId(string);
        if (string2 == null) {
            log.severe("Image not found ID: '" + string + "'");
            return null;
        }
        if (Files.exists(Paths.get(string2, new String[0]), new LinkOption[0])) {
            try {
                if (OSUtil.isWindowsSystem()) {
                    uRL = new URL("file:///" + string2);
                }
                uRL = new URL("file://" + string2);
            }
            catch (MalformedURLException malformedURLException) {
                log.severe("Invalid icon URL");
                return null;
            }
        } else {
            uRL = Thread.currentThread().getContextClassLoader().getResource(string2);
            if (uRL == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Image not found '" + string + "'");
                }
                return null;
            }
        }
        image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (log.isLoggable(Level.FINER)) {
            log.finer("Cached image " + string);
        }
        ID_IMAGE_MAP.put(string, image);
        return image;
    }

    private static String getIconId(String string) {
        return Icons.getIconProperties().getProperty(string);
    }

    public static Icon getSimpleIconFor(Member member) {
        if (member == null) {
            return Icons.getIconById(NODE_CONNECTED);
        }
        Icon icon = member.isFriend() ? Icons.getIconById(NODE_CONNECTED) : Icons.getIconById(NODE_CONNECTED);
        if (!member.isOnSameNetwork()) {
            icon = new OverlayedIcon(icon, Icons.getIconById(DELETE), 0, 0);
        }
        return icon;
    }

    public static Icon getIconFor(Member member) {
        Object object;
        String string;
        if (member == null) {
            return Icons.getIconById(NODE_CONNECTED);
        }
        if (member.isMySelf()) {
            string = NODE_MYSELF;
        } else if (member.isCompletelyConnected()) {
            ConnectionQuality connectionQuality;
            object = member.getPeer();
            string = NODE_CONNECTED;
            if (member.isOnLAN()) {
                string = NODE_LAN;
            } else if (object != null && (connectionQuality = object.getConnectionQuality()) != null) {
                switch (connectionQuality) {
                    case GOOD: {
                        string = NODE_CONNECTED;
                        break;
                    }
                    case MEDIUM: {
                        string = NODE_MEDIUM;
                        break;
                    }
                    case POOR: {
                        string = NODE_POOR;
                    }
                }
            }
        } else {
            string = "node_friend_disconnected.icon";
        }
        object = Icons.getIconById(string);
        if (!member.isOnSameNetwork()) {
            object = new OverlayedIcon((Icon)object, Icons.getIconById(DELETE), 0, 0);
        }
        return object;
    }

    public static Icon getIconByAccount(AccountInfo accountInfo, Controller controller) {
        String string;
        String string2 = string = accountInfo != null ? accountInfo.getUsername() : null;
        if (string == null) {
            return Icons.getIconById("node_friend_disconnected.icon");
        }
        if (USERNAME_ICON_MAP.containsKey(string)) {
            return USERNAME_ICON_MAP.get(string);
        }
        new IconBackgroundLoader(accountInfo, controller).execute();
        return Icons.getIconById("node_friend_disconnected.icon");
    }

    public static Icon getIconFor(FileInfo fileInfo, Controller controller) {
        String string = fileInfo.getExtension();
        if (string == null) {
            return Icons.getUnknownIcon(fileInfo, controller);
        }
        Path path = fileInfo.getDiskFile(controller.getFolderRepository());
        boolean bl = path != null && Files.exists(path, new LinkOption[0]);
        Icon icon = Icons.getCachedIcon(string, bl);
        if (icon == null) {
            if (bl) {
                icon = FileSystemView.getFileSystemView().getSystemIcon(path.toFile());
                if (icon == null) {
                    return Icons.getIconById(UNKNOWN_FILE);
                }
                if (!Icons.hasUniqueIcon(string)) {
                    EXTENSION_ICON_MAP.put(string, icon);
                    Icon icon2 = Icons.getGrayIcon(icon);
                    EXTENSION_ICON_MAP.put(string + DISABLED_EXTENSION_ADDITION, icon2);
                }
            } else if (Icons.hasUniqueIcon(string)) {
                icon = Icons.getIconById(UNKNOWN_FILE_GRAY);
            } else {
                icon = Icons.getIconExtension(string);
                if (icon == null) {
                    icon = Icons.getIconById(UNKNOWN_FILE_GRAY);
                } else {
                    Icon icon3 = Icons.getGrayIcon(icon);
                    if (!Icons.hasUniqueIcon(string)) {
                        EXTENSION_ICON_MAP.put(string, icon);
                        EXTENSION_ICON_MAP.put(string + DISABLED_EXTENSION_ADDITION, icon3);
                    }
                    icon = icon3;
                }
            }
        }
        if (fileInfo.isDeleted()) {
            icon = Icons.convertToRed(icon);
        }
        return icon;
    }

    public static Icon getEnabledIconFor(FileInfo fileInfo, Controller controller) {
        boolean bl;
        String string = fileInfo.getExtension();
        if (string == null) {
            return Icons.getIconById(UNKNOWN_FILE);
        }
        if (EXTENSION_ICON_MAP.containsKey(string)) {
            return EXTENSION_ICON_MAP.get(string);
        }
        Path path = fileInfo.getDiskFile(controller.getFolderRepository());
        boolean bl2 = bl = path != null && Files.exists(path, new LinkOption[0]);
        if (bl) {
            Icon icon = FileSystemView.getFileSystemView().getSystemIcon(path.toFile());
            if (!Icons.hasUniqueIcon(string)) {
                EXTENSION_ICON_MAP.put(string, icon);
                Icon icon2 = Icons.getGrayIcon(icon);
                EXTENSION_ICON_MAP.put(string + DISABLED_EXTENSION_ADDITION, icon2);
            }
            return icon;
        }
        Icon icon = Icons.getIconExtension(string);
        EXTENSION_ICON_MAP.put(string, icon);
        Icon icon3 = Icons.getGrayIcon(icon);
        EXTENSION_ICON_MAP.put(string + DISABLED_EXTENSION_ADDITION, icon3);
        return icon;
    }

    public static Icon getIconFor(Controller controller, FileInfo fileInfo) {
        DownloadManager downloadManager;
        Icon icon = fileInfo.isDownloading(controller) ? ((downloadManager = controller.getTransferManager().getActiveDownload(fileInfo)) != null && downloadManager.isStarted() ? Icons.getIconById(DOWNLOAD_ACTIVE) : Icons.getIconById(DOWNLOAD)) : (fileInfo.isDeleted() ? Icons.getIconById(DELETE) : (fileInfo.isExpected(controller.getFolderRepository()) ? Icons.getIconById(EXPECTED) : (fileInfo.getFolder(controller.getFolderRepository()) == null ? Icons.getIconById(EXPECTED) : null)));
        return icon;
    }

    private static boolean hasUniqueIcon(String string) {
        return string.equals("EXE") || string.equals("SCR") || string.equals("ICO");
    }

    private static Icon getCachedIcon(String string, boolean bl) {
        if (bl) {
            if (EXTENSION_ICON_MAP.containsKey(string)) {
                return EXTENSION_ICON_MAP.get(string);
            }
        } else if (EXTENSION_ICON_MAP.containsKey(string + DISABLED_EXTENSION_ADDITION)) {
            return EXTENSION_ICON_MAP.get(string + DISABLED_EXTENSION_ADDITION);
        }
        return null;
    }

    private static Icon getUnknownIcon(FileInfo fileInfo, Controller controller) {
        if (fileInfo.diskFileExists(controller)) {
            return Icons.getIconById(UNKNOWN_FILE);
        }
        if (fileInfo.isDeleted()) {
            return Icons.getIconById(UNKNOWN_FILE_RED);
        }
        return Icons.getIconById(UNKNOWN_FILE_GRAY);
    }

    public static Image getImageExtension(String string) {
        Icon icon = Icons.getIconExtension(string);
        if (icon == null) {
            log.severe("Image Icon not found for extension '" + string + "'");
            return null;
        }
        return Icons.getImageFromIcon(icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Icon getIconExtension(String string) {
        Path path = Controller.getTempFilesLocation().resolve("temp." + string);
        Object object = FILE_LOCK;
        synchronized (object) {
            try {
                Files.createFile(path, new FileAttribute[0]);
                Icon icon = FileSystemView.getFileSystemView().getSystemIcon(path.toFile());
                try {
                    Files.delete(path);
                }
                catch (IOException iOException) {
                    log.warning("Failed to delete temporary file.");
                    path.toFile().deleteOnExit();
                }
                return icon;
            }
            catch (IOException iOException) {
                log.severe("Couldn't create temporary file for icon retrieval for extension:'" + string + "'");
            }
        }
        return null;
    }

    private static ImageIcon convertToRed(Icon icon) {
        Image image = Icons.getImageFromIcon(icon);
        BufferedImage bufferedImage = Icons.toBufferedImage(image);
        int n = 0xFF0000;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        BufferedImage bufferedImage2 = new BufferedImage(n2, n3, 2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = bufferedImage.getRGB(i, j);
                int n5 = n4 & 0xFF000000;
                if (n5 == -16777216) {
                    int n6 = 255 - (bufferedImage.getRGB(i, j) & 0xFF);
                    bufferedImage2.setRGB(i, j, n6 << 24 | n);
                    continue;
                }
                bufferedImage2.setRGB(i, j, n4);
            }
        }
        return new ImageIcon(bufferedImage2);
    }

    private static Icon getGrayIcon(Icon icon) {
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
        Image image = Icons.getImageFromIcon(icon);
        if (image == null) {
            return icon;
        }
        return new ImageIcon(colorConvertOp.filter(Icons.toBufferedImage(image), null));
    }

    private static Image getImageFromIcon(Icon icon) {
        if (icon == null) {
            log.log(Level.SEVERE, "Icon is null", new RuntimeException("Icon is null"));
            return null;
        }
        if (icon instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)icon;
            return imageIcon.getImage();
        }
        if (icon instanceof IconUIResource) {
            try {
                IconUIResource iconUIResource = (IconUIResource)icon;
                Field field = iconUIResource.getClass().getDeclaredField("delegate");
                field.setAccessible(true);
                Icon icon2 = (Icon)field.get(iconUIResource);
                return Icons.getImageFromIcon(icon2);
            }
            catch (Exception exception) {
                log.log(Level.SEVERE, "Could not get icon from IconUIResource", exception);
            }
        }
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = Icons.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            log.log(Level.FINER, "HeadlessException", headlessException);
        }
        if (bufferedImage == null) {
            int n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            return bufferedImage.getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            log.log(Level.INFO, "InterruptedException", interruptedException);
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        return colorModel.hasAlpha();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String string) {
        Reject.ifBlank(string, "Properties blank");
        BufferedInputStream bufferedInputStream = null;
        try {
            Properties properties = new Properties();
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
            if (inputStream == null) {
                throw new FileNotFoundException("File not found");
            }
            bufferedInputStream = new BufferedInputStream(inputStream);
            properties.load(bufferedInputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            log.log(Level.INFO, "Cannot read properties file: " + string + ". " + iOException, iOException);
            Properties properties = null;
            return properties;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static Image getGrayImage(Image image) {
        BufferedImage bufferedImage = Icons.toBufferedImage(image);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
        return bufferedImage2;
    }

    static {
        SYSTRAY_SYNC_ANIMATION_LOW_RES = new String[]{"systray_sync00_lowres.icon", "systray_sync01_lowres.icon", "systray_sync02_lowres.icon", "systray_sync03_lowres.icon", "systray_sync04_lowres.icon", "systray_sync05_lowres.icon", "systray_sync06_lowres.icon", "systray_sync07_lowres.icon", "systray_sync08_lowres.icon", "systray_sync09_lowres.icon", "systray_sync10_lowres.icon", "systray_sync11_lowres.icon"};
        SYSTRAY_SYNC_ANIMATION_LOW_LIGHT_RES = new String[]{"systray_sync00_lowres_light.icon", "systray_sync01_lowres_light.icon", "systray_sync02_lowres_light.icon", "systray_sync03_lowres_light.icon", "systray_sync04_lowres_light.icon", "systray_sync05_lowres_light.icon", "systray_sync06_lowres_light.icon", "systray_sync07_lowres_light.icon", "systray_sync08_lowres_light.icon", "systray_sync09_lowres_light.icon", "systray_sync10_lowres_light.icon", "systray_sync11_lowres_light.icon"};
        SYSTRAY_SYNC_ANIMATION_HI_RES = new String[]{"systray_sync00_hires.icon", "systray_sync01_hires.icon", "systray_sync02_hires.icon", "systray_sync03_hires.icon", "systray_sync04_hires.icon", "systray_sync05_hires.icon", "systray_sync06_hires.icon", "systray_sync07_hires.icon", "systray_sync08_hires.icon", "systray_sync09_hires.icon", "systray_sync10_hires.icon", "systray_sync11_hires.icon"};
        SYSTRAY_SYNC_ANIMATION_HI_LIGHT_RES = new String[]{"systray_sync00_hires_light.icon", "systray_sync01_hires_light.icon", "systray_sync02_hires_light.icon", "systray_sync03_hires_light.icon", "systray_sync04_hires_light.icon", "systray_sync05_hires_light.icon", "systray_sync06_hires_light.icon", "systray_sync07_hires_light.icon", "systray_sync08_hires_light.icon", "systray_sync09_hires_light.icon", "systray_sync10_hires_light.icon", "systray_sync11_hires_light.icon"};
        if (!TrayIconManager.isHiRes()) {
            if (!TrayIconManager.isMacMenuBarDarkMode()) {
                SYSTRAY_SYNC_ANIMATION = SYSTRAY_SYNC_ANIMATION_LOW_RES;
                SYSTRAY_SYNC_COMPLETE = SYSTRAY_SYNC_COMPLETE_LOW_RES;
                SYSTRAY_SYNC_INCOMPLETE = SYSTRAY_SYNC_INCOMPLETE_LOW_RES;
                SYSTRAY_WARNING = SYSTRAY_WARNING_LOW_RES;
                SYSTRAY_PAUSE = SYSTRAY_PAUSE_LOW_RES;
            } else {
                SYSTRAY_SYNC_ANIMATION = SYSTRAY_SYNC_ANIMATION_LOW_LIGHT_RES;
                SYSTRAY_SYNC_COMPLETE = SYSTRAY_SYNC_COMPLETE_LOW_LIGHT_RES;
                SYSTRAY_SYNC_INCOMPLETE = SYSTRAY_SYNC_INCOMPLETE_LOW_LIGHT_RES;
                SYSTRAY_WARNING = SYSTRAY_WARNING_LOW_LIGHT_RES;
                SYSTRAY_PAUSE = SYSTRAY_PAUSE_LOW_LIGHT_RES;
            }
        } else if (!TrayIconManager.isMacMenuBarDarkMode()) {
            SYSTRAY_SYNC_ANIMATION = SYSTRAY_SYNC_ANIMATION_HI_RES;
            SYSTRAY_SYNC_COMPLETE = SYSTRAY_SYNC_COMPLETE_HIGH_RES;
            SYSTRAY_SYNC_INCOMPLETE = SYSTRAY_SYNC_INCOMPLETE_HIGH_RES;
            SYSTRAY_WARNING = SYSTRAY_WARNING_HIGH_RES;
            SYSTRAY_PAUSE = SYSTRAY_PAUSE_HIGH_RES;
        } else {
            SYSTRAY_SYNC_ANIMATION = SYSTRAY_SYNC_ANIMATION_HI_LIGHT_RES;
            SYSTRAY_SYNC_COMPLETE = SYSTRAY_SYNC_COMPLETE_HIGH_LIGHT_RES;
            SYSTRAY_SYNC_INCOMPLETE = SYSTRAY_SYNC_INCOMPLETE_HIGH_LIGHT_RES;
            SYSTRAY_WARNING = SYSTRAY_WARNING_HIGH_LIGHT_RES;
            SYSTRAY_PAUSE = SYSTRAY_PAUSE_HIGH_LIGHT_RES;
        }
        log = Logger.getLogger(Icons.class.getName());
        FILE_LOCK = new Object();
        ID_ICON_MAP = new ConcurrentHashMap<String, Icon>();
        ID_IMAGE_MAP = new ConcurrentHashMap<String, Image>();
        EXTENSION_ICON_MAP = new HashMap<String, Icon>();
        USERNAME_ICON_MAP = new WeakHashMap<String, Icon>();
        DEFAULT_PROPERTIES_FILENAME = Origin.ICON_PROPERTIES_FILENAME;
        UNKNOWN_ICONS = new ArrayList<String>();
    }

    private static class IconBackgroundLoader
    extends SwingWorker<Void, Void> {
        private final AccountInfo member;
        private final Controller controller;
        private ImageIcon image;

        IconBackgroundLoader(AccountInfo accountInfo, Controller controller) {
            this.member = accountInfo;
            this.controller = controller;
        }

        @Override
        protected Void doInBackground() throws Exception {
            String string = this.controller.getOSClient().getAvatarURL(this.member, true);
            try {
                URL uRL = new URL(string);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.connect();
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    ImageIcon imageIcon = new ImageIcon(uRL);
                    Image image = imageIcon.getImage().getScaledInstance(25, 25, 4);
                    this.image = new ImageIcon(image);
                }
            }
            catch (MalformedURLException malformedURLException) {
                log.warning("Avatar URL was malformed: " + string);
            }
            catch (IOException iOException) {
                log.warning(iOException.getMessage());
            }
            return null;
        }

        @Override
        protected void done() {
            USERNAME_ICON_MAP.put(this.member.getUsername(), this.image);
            this.controller.getUIController().getActiveFrame().repaint();
        }
    }
}

