/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.LinkJButton;
import de.dal33t.powerfolder.ui.widget.LinkLabel;
import de.dal33t.powerfolder.util.BrowserLauncher;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Help {
    private static final Logger LOG = Logger.getLogger(Help.class.getName());

    private Help() {
    }

    public static void openQuickstartGuides(Controller controller) {
        if (StringUtils.isBlank(ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(controller))) {
            return;
        }
        LOG.fine("Opening quickstart guides");
        BrowserLauncher.openURL(controller, ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(controller));
    }

    public static void openWikiArticle(Controller controller, String string) {
        LOG.fine("Opening wiki article '" + string + "'");
        if (Help.hasWiki(controller)) {
            BrowserLauncher.openURL(controller, Help.getWikiArticleURL(controller, string));
        }
    }

    public static LinkLabel createQuickstartGuideLabel(Controller controller, String string) {
        String string2 = ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(controller);
        if (StringUtils.isNotBlank(string2)) {
            return new LinkLabel(controller, string, ConfigurationEntry.PROVIDER_QUICKSTART_URL.getValue(controller));
        }
        return new LinkLabel(controller, "", "");
    }

    public static boolean hasWiki(Controller controller) {
        String string = ConfigurationEntry.PROVIDER_WIKI_URL.getValue(controller);
        return StringUtils.isNotBlank(string);
    }

    public static String getWikiArticleURL(Controller controller, String string) {
        String string2 = ConfigurationEntry.PROVIDER_WIKI_URL.getValue(controller);
        if (StringUtils.isBlank(string2)) {
            return null;
        }
        LOG.log(Level.FINE, "Wiki URL is " + string2 + "/" + string);
        return string2;
    }

    public static LinkJButton createWikiLinkButton(Controller controller, String string) {
        String string2 = Translation.get("general.what_is_this");
        String string3 = Help.getWikiArticleURL(controller, string);
        LinkJButton linkJButton = new LinkJButton(Icons.getIconById("question.icon"), string2, string3);
        linkJButton.setVisible(StringUtils.isNotBlank(string3));
        return linkJButton;
    }
}

