/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.util;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Reject;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelayedUpdater {
    private final Logger log = Logger.getLogger(DelayedUpdater.class.getName());
    public static final long DEFAULT_DELAY = 250L;
    private static final int NOT_SCHEDULED = -1;
    private long delay;
    private final ScheduledExecutorService executorService;
    private volatile long nextMandatoryEvent = -1L;
    private volatile DelayedTimerTask currentTask;

    public DelayedUpdater(Controller controller) {
        this(controller, 250L);
    }

    public DelayedUpdater(Controller controller, long l) {
        this.executorService = controller.getThreadPool();
        this.delay = l;
    }

    public synchronized void setDelay(long l) {
        Reject.ifTrue(l < 0L, "Illegal delay value: " + l);
        this.delay = l;
    }

    public long getDelay() {
        return this.delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void schedule(Runnable runnable) {
        DelayedUpdater delayedUpdater = this;
        synchronized (delayedUpdater) {
            if (this.currentTask != null) {
                this.currentTask.cancel();
                this.currentTask.canceled = true;
            }
        }
        this.currentTask = new DelayedTimerTask(runnable);
        try {
            long l = System.currentTimeMillis();
            if (this.nextMandatoryEvent == -1L) {
                this.nextMandatoryEvent = l + this.delay;
            }
            long l2 = Math.max(this.nextMandatoryEvent - l, 0L);
            this.executorService.schedule(this.currentTask, l2, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.log.log(Level.FINER, "Unable to schedule task to timer: " + exception, exception);
        }
    }

    private class DelayedTimerTask
    extends TimerTask {
        private final Runnable task;
        private volatile boolean canceled;

        private DelayedTimerTask(Runnable runnable) {
            this.task = runnable;
            this.canceled = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DelayedUpdater delayedUpdater = DelayedUpdater.this;
            synchronized (delayedUpdater) {
                DelayedUpdater.this.currentTask = null;
                DelayedUpdater.this.nextMandatoryEvent = -1L;
                if (this.canceled) {
                    return;
                }
            }
            UIUtil.invokeLaterInEDT(new Runnable(){

                @Override
                public void run() {
                    if (DelayedTimerTask.this.canceled) {
                        return;
                    }
                    try {
                        DelayedTimerTask.this.task.run();
                    }
                    catch (Exception exception) {
                        DelayedUpdater.this.log.log(Level.SEVERE, "Exception while executing delayed task: " + exception, exception);
                    }
                }
            });
        }
    }
}

