/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.render;

import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.util.UIUtil;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortedTableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private SortedTableModel sortedTableModel;

    public static void associateHeaderRenderer(final SortedTableModel sortedTableModel, TableColumnModel tableColumnModel, final int n, final boolean bl) {
        SortedTableHeaderRenderer sortedTableHeaderRenderer = new SortedTableHeaderRenderer();
        sortedTableHeaderRenderer.sortedTableModel = sortedTableModel;
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setHeaderRenderer(sortedTableHeaderRenderer);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                sortedTableModel.setAscending(bl);
                sortedTableModel.sortBy(n);
            }
        };
        UIUtil.invokeLaterInEDT(runnable);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.setText(object.toString());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setHorizontalAlignment(0);
        this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        if (n2 == this.sortedTableModel.getSortColumn()) {
            if (this.sortedTableModel.isSortAscending()) {
                this.setIcon(Icons.getIconById("sort_up.icon"));
            } else {
                this.setIcon(Icons.getIconById("sort_down.icon"));
            }
        } else {
            this.setIcon(Icons.getIconById("sort_blank.icon"));
        }
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

