/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.preferences;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.ui.dialog.AddressEditor;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.ui.widget.JButtonMini;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.net.AddressRange;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LANList
extends PFComponent {
    private JPanel panel;
    private JList<String> networklist;
    private JButton addButton;
    private JButton removeButton;
    private JButton editButton;
    private boolean modified = false;

    public LANList(Controller controller) {
        super(controller);
        this.initComponents();
    }

    private void initComponents() {
        this.networklist = new JList(new DefaultListModel());
        this.networklist.setSelectionMode(2);
        this.addButton = new JButtonMini(Icons.getIconById("add.icon"), Translation.get("folder_panel.settings_tab.addbutton.name"));
        this.removeButton = new JButtonMini(Icons.getIconById("delete.icon"), Translation.get("folder_panel.settings_tab.removebutton.name"));
        this.editButton = new JButtonMini(Icons.getIconById("edit.icon"), Translation.get("folder_panel.settings_tab.editbutton.name"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddressEditor addressEditor = new AddressEditor(LANList.this.getController());
                addressEditor.open();
                if (addressEditor.getResult() == AddressEditor.EditorResult.OK) {
                    LANList.this.modified = true;
                    ((DefaultListModel)LANList.this.networklist.getModel()).addElement(addressEditor.getAddressRange());
                }
            }
        });
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (LANList.this.networklist.isSelectionEmpty()) {
                    return;
                }
                AddressEditor addressEditor = new AddressEditor(LANList.this.getController(), ((String)LANList.this.networklist.getSelectedValue()).toString());
                addressEditor.open();
                if (addressEditor.getResult() == AddressEditor.EditorResult.OK) {
                    ((DefaultListModel)LANList.this.networklist.getModel()).set(LANList.this.networklist.getSelectedIndex(), addressEditor.getAddressRange());
                    LANList.this.modified = true;
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (String string : LANList.this.networklist.getSelectedValuesList()) {
                    ((DefaultListModel)LANList.this.networklist.getModel()).removeElement(string);
                    LANList.this.modified = true;
                }
            }
        });
    }

    public JPanel getUIPanel() {
        if (this.panel == null) {
            FormLayout formLayout = new FormLayout("pref, pref, pref, pref:grow", "40dlu, 3dlu, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)new JScrollPane(this.networklist), cellConstraints.xyw(1, 1, 4));
            panelBuilder.add((Component)this.addButton, cellConstraints.xy(1, 3));
            panelBuilder.add((Component)this.editButton, cellConstraints.xy(2, 3));
            panelBuilder.add((Component)this.removeButton, cellConstraints.xy(3, 3));
            this.panel = panelBuilder.getPanel();
        }
        return this.panel;
    }

    public boolean save() {
        Object[] objectArray = ((DefaultListModel)this.networklist.getModel()).toArray();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append((String)object);
        }
        ConfigurationEntry.LANLIST.setValue(this.getController(), stringBuilder.toString());
        return this.modified;
    }

    public void load() {
        String[] stringArray;
        String string = ConfigurationEntry.LANLIST.getValue(this.getController());
        if (StringUtils.isBlank(string)) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            AddressRange addressRange;
            try {
                addressRange = AddressRange.parseRange(string2);
            }
            catch (ParseException parseException) {
                this.logWarning("Invalid lanlist entry in configuration file!");
                continue;
            }
            ((DefaultListModel)this.networklist.getModel()).addElement(addressRange.toString());
        }
    }
}

