/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.notification;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.Translation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class NotificationForm
extends JPanel {
    private final Controller controller;
    private JCheckBox neverShowSystemNotificationCB;
    private final String messageText;

    NotificationForm(Controller controller, String string, String string2, String string3, Action action, String string4, Action action2) {
        this.controller = controller;
        this.messageText = string2.length() > 200 ? string2.substring(0, 200) + "..." : string2;
        this.setLayout(new BorderLayout());
        JPanel jPanel = this.createPanel(string, string3, action, string4, action2);
        this.add((Component)jPanel, "Center");
        this.setBorder(new LineBorder(Color.lightGray, 1));
    }

    private JPanel createPanel(String string, String string2, Action action, String string3, Action action2) {
        int n;
        FormLayout formLayout;
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        CellConstraints cellConstraints = new CellConstraints();
        if (string2 == null && string3 == null) {
            formLayout = new FormLayout("3dlu, 150dlu:grow, 3dlu", "3dlu, pref, 15dlu, pref, 3dlu");
            n = 1;
        } else if (string2 != null && string3 != null) {
            formLayout = new FormLayout("3dlu, 10dlu, 80dlu:grow, 10dlu, 80dlu:grow, 10dlu, 3dlu", "3dlu, pref, 15dlu, pref, 15dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
            n = 5;
        } else {
            formLayout = new FormLayout("3dlu, 45dlu, 80dlu:grow, 45dlu, 3dlu", "3dlu, pref, 15dlu, pref, 15dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu");
            n = 3;
        }
        jPanel.setLayout(formLayout);
        jPanel.add((Component)NotificationForm.createHeaderPanel(string), cellConstraints.xyw(2, 2, n));
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(this.messageText);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jPanel.add((Component)jTextArea, new CellConstraints(2, 4, n, 1, CellConstraints.DEFAULT, CellConstraints.TOP));
        if (string2 != null || string3 != null) {
            jPanel.add((Component)new JSeparator(), cellConstraints.xyw(2, 6, n));
            this.neverShowSystemNotificationCB = new JCheckBox(Translation.get("notification_form.never_show_system_notifications"));
            this.neverShowSystemNotificationCB.addActionListener(new MyActionListener());
            jPanel.add((Component)this.neverShowSystemNotificationCB, cellConstraints.xyw(2, 8, n));
            if (string2 != null && string3 != null) {
                JButton jButton = new JButton();
                jButton.setAction(action);
                jButton.setText(string2);
                jPanel.add((Component)jButton, cellConstraints.xy(3, 10));
                JButton jButton2 = new JButton();
                jButton2.setAction(action2);
                jButton2.setText(string3);
                jPanel.add((Component)jButton2, cellConstraints.xy(5, 10));
            } else if (string2 != null) {
                JButton jButton = new JButton();
                jButton.setAction(action);
                jButton.setText(string2);
                jPanel.add((Component)jButton, cellConstraints.xy(3, 10));
            } else {
                JButton jButton = new JButton();
                jButton.setAction(action2);
                jButton.setText(string3);
                jPanel.add((Component)jButton, cellConstraints.xy(3, 10));
            }
        }
        return jPanel;
    }

    private static JPanel createHeaderPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(null);
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout(formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(Translation.get("notification_form.title", string));
        jLabel.setHorizontalAlignment(2);
        jPanel.add((Component)jLabel, cellConstraints.xy(3, 1));
        JLabel jLabel2 = new JLabel(Icons.getIconById("powerfolder_32.icon"));
        jLabel2.setSize(new Dimension(Icons.getIconById("powerfolder_32.icon").getIconWidth(), Icons.getIconById("powerfolder_32.icon").getIconHeight()));
        jPanel.add((Component)jLabel2, cellConstraints.xy(1, 1));
        return jPanel;
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == NotificationForm.this.neverShowSystemNotificationCB) {
                NotificationForm.this.controller.getUIController().getApplicationModel().getSystemNotificationsValueModel().setValue(!NotificationForm.this.neverShowSystemNotificationCB.isSelected());
            }
        }
    }
}

