/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.model;

import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.event.NodeManagerAdapter;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerModelListener;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.security.SecurityManagerEvent;
import de.dal33t.powerfolder.security.SecurityManagerListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.util.compare.MemberComparator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.ListModel;

public class NodeManagerModel
extends PFUIComponent {
    private ValueModel showOfflineModel;
    private ArrayListModel<Member> friendsListModel;
    private final Set<Member> nodes = new CopyOnWriteArraySet<Member>();
    private final NodeManager nodeManager = this.getController().getNodeManager();
    private final Set<NodeManagerModelListener> listeners = new CopyOnWriteArraySet<NodeManagerModelListener>();

    public NodeManagerModel(Controller controller) {
        super(controller);
        this.initalize();
    }

    public void addNodeManagerModelListener(NodeManagerModelListener nodeManagerModelListener) {
        this.listeners.add(nodeManagerModelListener);
    }

    public void removeNodeManagerModelListener(NodeManagerModelListener nodeManagerModelListener) {
        this.listeners.remove(nodeManagerModelListener);
    }

    private synchronized void initalize() {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                NodeManagerModel.this.rebuildSet();
            }
        };
        this.friendsListModel = new ArrayListModel();
        this.showOfflineModel = PreferencesEntry.NODE_MANAGER_MODEL_SHOW_OFFLINE.getModel(this.getController());
        this.showOfflineModel.addValueChangeListener(propertyChangeListener);
        this.rebuildSet();
        this.nodeManager.addNodeManagerListener(new MyNodeManagerListener());
        this.getController().getSecurityManager().addListener(new MySecurityManagerListener());
        this.getController().getOSClient().addListener(new MyServerClientListener());
    }

    private void rebuildSet() {
        Collection<Member> collection = this.nodeManager.getNodesAsCollection();
        TreeSet<Member> treeSet = new TreeSet<Member>(MemberComparator.NICK);
        for (Member object : collection) {
            if (!this.required(object)) continue;
            treeSet.add(object);
        }
        this.nodes.clear();
        this.nodes.addAll(treeSet);
        for (NodeManagerModelListener nodeManagerModelListener : this.listeners) {
            nodeManagerModelListener.changed();
        }
        Iterator<Object> iterator = this.getController().getNodeManager().getFriends();
        this.friendsListModel.clear();
        this.friendsListModel.addAll(Arrays.asList(iterator));
        Collections.sort(this.friendsListModel, MemberComparator.IN_GUI);
    }

    private boolean required(Member member) {
        boolean bl = member.isCompletelyConnected();
        if (member.isMySelf()) {
            return false;
        }
        if (member.isMyComputer() || member.isFriend() || member.isOnLAN() && bl) {
            boolean bl2 = (Boolean)this.showOfflineModel.getValue();
            boolean bl3 = bl || member.isConnectedToNetwork();
            return bl2 || bl3;
        }
        return false;
    }

    public Map<Type, Set<Member>> getNodesMap() {
        Member member2;
        HashSet<Member> hashSet = new HashSet<Member>();
        HashSet<Member> hashSet2 = new HashSet<Member>();
        HashSet<Member> hashSet3 = new HashSet<Member>();
        HashSet<Member> hashSet4 = new HashSet<Member>();
        hashSet4.addAll(this.nodes);
        Object object = hashSet4.iterator();
        while (object.hasNext()) {
            member2 = (Member)object.next();
            if (!member2.isFriend() || !member2.isMyComputer()) continue;
            hashSet.add(member2);
            object.remove();
        }
        object = hashSet4.iterator();
        while (object.hasNext()) {
            member2 = (Member)object.next();
            if (!member2.isOnLAN() || !member2.isCompletelyConnected()) continue;
            hashSet3.add(member2);
            object.remove();
        }
        for (Member member2 : hashSet4) {
            if (!member2.isFriend()) continue;
            hashSet2.add(member2);
        }
        object = new TreeMap();
        object.put(Type.MY_COMPUTERS_INDEX, hashSet);
        object.put(Type.FRIENDS_INDEX, hashSet2);
        object.put(Type.CONNECTED_LAN, hashSet3);
        return object;
    }

    public int getSize() {
        int n = 0;
        Map<Type, Set<Member>> map = this.getNodesMap();
        for (Set<Member> set : map.values()) {
            n += set.size();
        }
        return n;
    }

    public ValueModel getShowOfflineModel() {
        return this.showOfflineModel;
    }

    public ListModel getFriendsListModel() {
        return this.friendsListModel;
    }

    private void updateNode(Member member) {
        boolean bl = false;
        boolean bl2 = this.required(member);
        if (bl2) {
            if (!this.nodes.contains(member)) {
                this.nodes.add(member);
                bl = true;
            }
        } else if (this.nodes.contains(member)) {
            this.nodes.remove(member);
            bl = true;
        }
        if (this.nodes.contains(member)) {
            bl = true;
        }
        if (bl) {
            for (NodeManagerModelListener nodeManagerModelListener : this.listeners) {
                nodeManagerModelListener.changed();
            }
        }
    }

    private class MyNodeManagerListener
    extends NodeManagerAdapter {
        private MyNodeManagerListener() {
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
            if (!NodeManagerModel.this.friendsListModel.contains(nodeManagerEvent.getNode())) {
                NodeManagerModel.this.friendsListModel.add(nodeManagerEvent.getNode());
                Collections.sort(NodeManagerModel.this.friendsListModel, MemberComparator.IN_GUI);
            }
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.friendsListModel.remove(nodeManagerEvent.getNode());
            Collections.sort(NodeManagerModel.this.friendsListModel, MemberComparator.IN_GUI);
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeAdded(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOffline(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeOnline(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void nodeRemoved(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
            NodeManagerModel.this.updateNode(nodeManagerEvent.getNode());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MySecurityManagerListener
    implements SecurityManagerListener {
        private MySecurityManagerListener() {
        }

        @Override
        public void nodeAccountStateChanged(SecurityManagerEvent securityManagerEvent) {
            NodeManagerModel.this.updateNode(securityManagerEvent.getNode());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            NodeManagerModel.this.updateNode(NodeManagerModel.this.getController().getMySelf());
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            NodeManagerModel.this.updateNode(NodeManagerModel.this.getController().getMySelf());
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            NodeManagerModel.this.updateNode(serverClientEvent.getServerNode());
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }

    public static enum Type {
        MY_COMPUTERS_INDEX,
        FRIENDS_INDEX,
        CONNECTED_LAN;

    }
}

