/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.problems;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.problem.Problem;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.model.SortedTableModel;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.util.Translation;
import de.dal33t.powerfolder.util.compare.ReverseComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ProblemsTableModel
extends PFUIComponent
implements TableModel,
SortedTableModel {
    public static final int COL_ICON = 0;
    public static final int COL_DESCRIPTION = 1;
    public static final int COL_SOLUTION = 2;
    public static final int COL_DATE = 3;
    private String[] columnHeaders = new String[]{"", Translation.get("folder_problem.table_model.description"), Translation.get("folder_problem.table_model.solution"), Translation.get("folder_problem.table_model.date")};
    private final List<Problem> problems = new ArrayList<Problem>();
    private final List<TableModelListener> listeners = new CopyOnWriteArrayList<TableModelListener>();
    private int sortColumn = -1;
    private boolean sortAscending = true;

    public ProblemsTableModel(Controller controller) {
        super(controller);
    }

    @Override
    public int getRowCount() {
        return this.problems.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeaders.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnHeaders[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Problem.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.problems.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        throw new IllegalStateException("Unable to set value in ProblemTableModel; not editable");
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public int getSortColumn() {
        return this.sortColumn;
    }

    @Override
    public boolean isSortAscending() {
        return this.sortAscending;
    }

    @Override
    public boolean sortBy(int n) {
        boolean bl = this.sortColumn != n;
        this.sortColumn = n;
        switch (n) {
            case 1: {
                this.sortMe(FolderProblemComparator.BY_DESCRIPTION, bl);
                break;
            }
            case 3: {
                this.sortMe(FolderProblemComparator.BY_DATE, bl);
                break;
            }
            case 2: {
                this.sortMe(FolderProblemComparator.BY_SOLUTION, bl);
            }
        }
        return true;
    }

    private void sortMe(FolderProblemComparator folderProblemComparator, boolean bl) {
        if (!bl) {
            boolean bl2 = this.sortAscending = !this.sortAscending;
        }
        if (this.sortAscending) {
            Collections.sort(this.problems, folderProblemComparator);
        } else {
            Collections.sort(this.problems, new ReverseComparator<Problem>(folderProblemComparator));
        }
        this.modelChanged(new TableModelEvent(this, 0, this.problems.size() - 1));
    }

    public void updateProblems(List<Problem> list) {
        this.problems.clear();
        this.problems.addAll(list);
        this.modelChanged(new TableModelEvent(this));
    }

    private void modelChanged(final TableModelEvent tableModelEvent) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List list = ProblemsTableModel.this.listeners;
                synchronized (list) {
                    for (TableModelListener tableModelListener : ProblemsTableModel.this.listeners) {
                        tableModelListener.tableChanged(tableModelEvent);
                    }
                }
            }
        };
        try {
            UIUtil.invokeAndWaitInEDT(runnable);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void setAscending(boolean bl) {
        this.sortAscending = bl;
    }

    private static class FolderProblemComparator
    implements Comparator<Problem> {
        private static final int TYPE_DESCRIPTION = 0;
        private static final int TYPE_DATE = 3;
        private static final int TYPE_WIKI = 2;
        private static final int TYPE_SOLUTION = 1;
        public static final FolderProblemComparator BY_DESCRIPTION = new FolderProblemComparator(0);
        public static final FolderProblemComparator BY_DATE = new FolderProblemComparator(3);
        public static final FolderProblemComparator BY_WIKI = new FolderProblemComparator(2);
        public static final FolderProblemComparator BY_SOLUTION = new FolderProblemComparator(1);
        private int type;

        private FolderProblemComparator(int n) {
            this.type = n;
        }

        @Override
        public int compare(Problem problem, Problem problem2) {
            if (this.type == 0) {
                return problem.getDescription().compareTo(problem2.getDescription());
            }
            if (this.type == 3) {
                return problem.getDate().compareTo(problem2.getDate());
            }
            if (this.type == 2) {
                return problem.getWikiLinkKey().compareTo(problem2.getWikiLinkKey());
            }
            if (this.type == 1) {
                return problem.getDescription().compareTo(problem2.getDescription());
            }
            return 0;
        }
    }
}

