/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files;

import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.event.NodeManagerEvent;
import de.dal33t.powerfolder.event.NodeManagerListener;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.DiskItem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.action.BaseAction;
import de.dal33t.powerfolder.ui.information.folder.files.DirectoryFilter;
import de.dal33t.powerfolder.ui.information.folder.files.DirectoryFilterListener;
import de.dal33t.powerfolder.ui.information.folder.files.FilesStatsPanel;
import de.dal33t.powerfolder.ui.information.folder.files.FilteredDirectoryEvent;
import de.dal33t.powerfolder.ui.information.folder.files.breadcrumb.FilesBreadcrumbPanel;
import de.dal33t.powerfolder.ui.information.folder.files.table.FilesTablePanel;
import de.dal33t.powerfolder.ui.widget.FileFilterTextField;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class FilesTab
extends PFUIComponent
implements DirectoryFilterListener {
    private JPanel uiComponent;
    private FilesTablePanel tablePanel;
    private FileFilterTextField filterTextField;
    private JComboBox<String> filterSelectionComboBox;
    private FilesStatsPanel statsPanel;
    private DirectoryFilter directoryFilter;
    private ValueModel flatMode = new ValueHolder();
    private Folder folder;
    private JCheckBox flatViewCB;
    private FilesBreadcrumbPanel breadcrumbPanel;
    private MyFileArchiveAction fileArchiveAction;

    public FilesTab(Controller controller) {
        super(controller);
        this.statsPanel = new FilesStatsPanel(this.getController());
        this.filterTextField = new FileFilterTextField(this.getController());
        this.directoryFilter = new DirectoryFilter(controller, this.filterTextField.getSearchTextValueModel(), this.filterTextField.getSearchModeValueModel());
        this.directoryFilter.addListener(this);
        this.tablePanel = new FilesTablePanel(controller, this);
        this.directoryFilter.addListener(this.tablePanel);
        this.directoryFilter.setFlatMode(this.flatMode);
        this.breadcrumbPanel = new FilesBreadcrumbPanel(this.getController(), this);
        this.getController().getNodeManager().addNodeManagerListener(new MyNodeManagerListener());
        this.filterSelectionComboBox = new JComboBox();
        this.filterSelectionComboBox.setToolTipText(Translation.get("files_tab.combo.tool_tip"));
        this.filterSelectionComboBox.addItem(Translation.get("files_tab.combo.local_and_incoming"));
        this.filterSelectionComboBox.addItem(Translation.get("files_tab.combo.local_files_only"));
        this.filterSelectionComboBox.addItem(Translation.get("files_tab.combo.new_files_only"));
        this.filterSelectionComboBox.addItem(Translation.get("files_tab.combo.deleted_and_previous_files"));
        this.filterSelectionComboBox.addItem(Translation.get("files_tab.combo.unsynchronized_files"));
        this.filterSelectionComboBox.addActionListener(new MyActionListener());
    }

    public void scheduleDirectoryFiltering() {
        this.directoryFilter.scheduleFiltering();
    }

    public void setFolderInfo(FolderInfo folderInfo) {
        this.folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.updateNodes();
        this.directoryFilter.setFolder(this.folder, this.folder.getBaseDirectoryInfo());
        this.tablePanel.setFolder(this.folder);
        this.flatViewCB.setSelected(false);
        this.flatMode.setValue(this.flatViewCB.isSelected());
        this.setFilterComboBox(0);
        this.filterTextField.reset();
        this.breadcrumbPanel.setRoot(folderInfo);
        this.statsPanel.setDirectory(folderInfo.getFolder(this.getController()).getBaseDirectoryInfo());
        this.setupArchive(folderInfo);
    }

    public void setFolderInfoLatest(FolderInfo folderInfo) {
        this.folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.updateNodes();
        this.directoryFilter.setFolder(this.folder, this.folder.getBaseDirectoryInfo());
        this.tablePanel.setFolder(this.folder);
        this.tablePanel.sortLatestDate();
        this.flatViewCB.setSelected(true);
        this.flatMode.setValue(this.flatViewCB.isSelected());
        this.setFilterComboBox(2);
        this.filterTextField.reset();
        this.setupArchive(folderInfo);
    }

    public void setFolderInfoDeleted(FolderInfo folderInfo) {
        this.folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.updateNodes();
        this.directoryFilter.setFolder(this.folder, this.folder.getBaseDirectoryInfo());
        this.tablePanel.setFolder(this.folder);
        this.tablePanel.sortLatestDate();
        this.flatMode.setValue(this.flatViewCB.isSelected());
        this.setFilterComboBox(3);
        this.filterTextField.reset();
        this.setupArchive(folderInfo);
    }

    public void setFolderInfoUnsynced(FolderInfo folderInfo) {
        this.folder = this.getController().getFolderRepository().getFolder(folderInfo);
        this.updateNodes();
        this.directoryFilter.setFolder(this.folder, this.folder.getBaseDirectoryInfo());
        this.tablePanel.setFolder(this.folder);
        this.tablePanel.sortLatestDate();
        this.flatViewCB.setSelected(true);
        this.flatMode.setValue(this.flatViewCB.isSelected());
        this.setFilterComboBox(4);
        this.filterTextField.reset();
        this.setupArchive(folderInfo);
    }

    private void setupArchive(FolderInfo folderInfo) {
        this.fileArchiveAction.allowWith(FolderPermission.get(folderInfo, AccessMode.READ_WRITE));
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUIComponent();
        }
        return this.uiComponent;
    }

    private void buildUIComponent() {
        FormLayout formLayout = new FormLayout("3dlu, pref:grow, 3dlu", "3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu, pref, pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.createToolBar(), cellConstraints.xy(2, 2));
        defaultFormBuilder.add(this.padBreadcrumb(), cellConstraints.xy(2, 4));
        defaultFormBuilder.addSeparator(null, cellConstraints.xyw(1, 6, 3));
        defaultFormBuilder.add((Component)this.tablePanel.getUIComponent(), cellConstraints.xy(2, 8));
        defaultFormBuilder.addSeparator(null, cellConstraints.xy(2, 10));
        defaultFormBuilder.add((Component)this.statsPanel.getUiComponent(), cellConstraints.xy(2, 11));
        this.uiComponent = defaultFormBuilder.getPanel();
    }

    private Component padBreadcrumb() {
        FormLayout formLayout = new FormLayout("pref, pref:grow", "pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        defaultFormBuilder.add((Component)this.breadcrumbPanel.getUiComponent(), cellConstraints.xy(1, 1));
        return defaultFormBuilder.getPanel();
    }

    private JPanel createToolBar() {
        DetailsAction detailsAction = new DetailsAction(this.getController());
        JToggleButton jToggleButton = new JToggleButton(detailsAction);
        jToggleButton.setIcon(null);
        this.fileArchiveAction = new MyFileArchiveAction(this.getController());
        JButton jButton = new JButton(this.fileArchiveAction);
        jButton.setIcon(null);
        this.flatViewCB = new JCheckBox(Translation.get("files_tab.flat_view.text"));
        this.flatViewCB.setToolTipText(Translation.get("files_tab.flat_view.tip"));
        this.flatViewCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FilesTab.this.flatMode.setValue(FilesTab.this.flatViewCB.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("pref, 3dlu:grow, pref, 3dlu, pref, 3dlu, pref", "pref");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        ButtonBarBuilder buttonBarBuilder = ButtonBarBuilder.createLeftToRightBuilder();
        buttonBarBuilder.addGridded(jToggleButton);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addGridded(jButton);
        defaultFormBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(1, 1));
        defaultFormBuilder.add((Component)this.flatViewCB, cellConstraints.xy(3, 1));
        defaultFormBuilder.add(this.filterSelectionComboBox, cellConstraints.xy(5, 1));
        defaultFormBuilder.add((Component)this.filterTextField.getUIComponent(), cellConstraints.xy(7, 1));
        return defaultFormBuilder.getPanel();
    }

    @Override
    public void adviseOfChange(FilteredDirectoryEvent filteredDirectoryEvent) {
        this.statsPanel.setStats(filteredDirectoryEvent.getLocalFiles(), filteredDirectoryEvent.getDeletedFiles());
    }

    @Override
    public void adviseOfFilteringBegin() {
    }

    @Override
    public void invalidate() {
        this.statsPanel.setStats(0L, 0L);
    }

    private void updateNodes() {
        if (this.folder != null) {
            this.filterTextField.setMembers(Arrays.asList(this.folder.getConnectedMembers()));
        } else {
            this.filterTextField.setMembers(null);
        }
    }

    public void selectionChanged(String string) {
        DirectoryInfo directoryInfo = FileInfoFactory.lookupDirectory(this.folder.getInfo(), string);
        this.selectionChanged(directoryInfo);
    }

    public void selectionChanged(DirectoryInfo directoryInfo) {
        this.directoryFilter.setFolder(this.folder, directoryInfo);
        this.breadcrumbPanel.setDirectory(this.folder.getInfo(), directoryInfo);
        this.statsPanel.setDirectory(directoryInfo);
    }

    public void fileArchive() {
        if (this.folder != null) {
            DiskItem[] diskItemArray = this.tablePanel.getSelectedRows();
            ArrayList<FileInfo> arrayList = new ArrayList<FileInfo>();
            if (diskItemArray.length > 0) {
                for (DiskItem diskItem : diskItemArray) {
                    if (diskItem instanceof DirectoryInfo) {
                        DirectoryInfo directoryInfo = (DirectoryInfo)diskItem;
                        FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
                        fileInfoCriteria.addWriteMembersAndMyself(this.folder);
                        fileInfoCriteria.setType(FileInfoCriteria.Type.FILES_ONLY);
                        fileInfoCriteria.setPath(directoryInfo);
                        fileInfoCriteria.setRecursive(true);
                        Collection<FileInfo> collection = this.folder.getDAO().findFiles(fileInfoCriteria);
                        for (FileInfo fileInfo : collection) {
                            arrayList.add(fileInfo);
                        }
                        continue;
                    }
                    if (!(diskItem instanceof FileInfo)) continue;
                    arrayList.add((FileInfo)diskItem);
                }
            } else {
                FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
                fileInfoCriteria.addWriteMembersAndMyself(this.folder);
                fileInfoCriteria.setType(FileInfoCriteria.Type.FILES_ONLY);
                fileInfoCriteria.setPath(this.directoryFilter.getCurrentDirectoryInfo());
                fileInfoCriteria.setRecursive(true);
                Collection<FileInfo> collection = this.folder.getDAO().findFiles(fileInfoCriteria);
                for (FileInfo fileInfo : collection) {
                    arrayList.add(fileInfo);
                }
            }
            PFWizard.openMultiFileRestoreWizard(this.getController(), arrayList);
        }
    }

    public void resetFilters() {
        this.filterTextField.reset();
        this.flatViewCB.setSelected(false);
        this.flatMode.setValue(this.flatViewCB.isSelected());
        this.setFilterComboBox(0);
    }

    private void setFilterComboBox(int n) {
        int n2 = this.filterSelectionComboBox.getSelectedIndex();
        if (n2 != n) {
            this.filterSelectionComboBox.setSelectedIndex(n);
        }
    }

    private class MyNodeManagerListener
    implements NodeManagerListener {
        private MyNodeManagerListener() {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }

        @Override
        public void nodeConnected(NodeManagerEvent nodeManagerEvent) {
            FilesTab.this.updateNodes();
        }

        @Override
        public void nodeDisconnected(NodeManagerEvent nodeManagerEvent) {
            FilesTab.this.updateNodes();
        }

        @Override
        public void friendAdded(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void friendRemoved(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeAdded(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeConnecting(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeOffline(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeOnline(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void nodeRemoved(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void settingsChanged(NodeManagerEvent nodeManagerEvent) {
        }

        @Override
        public void startStop(NodeManagerEvent nodeManagerEvent) {
        }
    }

    private class MyActionListener
    implements ActionListener {
        private MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(FilesTab.this.filterSelectionComboBox)) {
                FilesTab.this.directoryFilter.setFileFilterMode(FilesTab.this.filterSelectionComboBox.getSelectedIndex());
                FilesTab.this.directoryFilter.scheduleFiltering();
            }
        }
    }

    private class MyFileArchiveAction
    extends BaseAction {
        private MyFileArchiveAction(Controller controller) {
            super("action_file_archive", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTab.this.fileArchive();
        }
    }

    private class DetailsAction
    extends BaseAction {
        DetailsAction(Controller controller) {
            super("action_details", controller);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FilesTab.this.tablePanel.toggleDetails();
        }
    }
}

