/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.information.folder.files;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class FilesStatsPanel
extends PFUIComponent {
    private JPanel uiComponent;
    private JLabel pathLabel = new JLabel("");
    private JLabel localLabel = new JLabel(Translation.get("files_stats_panel.local_label", ""));
    private JLabel deletedLabel = new JLabel(Translation.get("files_stats_panel.deleted_label", ""));

    public FilesStatsPanel(Controller controller) {
        super(controller);
    }

    public JPanel getUiComponent() {
        if (this.uiComponent == null) {
            this.buildUiComponent();
        }
        return this.uiComponent;
    }

    public void setStats(long l, long l2) {
        this.localLabel.setText(Translation.get("files_stats_panel.local_label", String.valueOf(l)));
        this.deletedLabel.setText(Translation.get("files_stats_panel.deleted_label", String.valueOf(l2)));
    }

    private void buildUiComponent() {
        FormLayout formLayout = new FormLayout("fill:pref:grow, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", "pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 12));
        JSeparator jSeparator2 = new JSeparator(1);
        jSeparator2.setPreferredSize(new Dimension(2, 12));
        panelBuilder.add((Component)this.pathLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)jSeparator, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.localLabel, cellConstraints.xy(5, 1));
        panelBuilder.add((Component)jSeparator2, cellConstraints.xy(7, 1));
        panelBuilder.add((Component)this.deletedLabel, cellConstraints.xy(9, 1));
        this.uiComponent = panelBuilder.getPanel();
    }

    public void setDirectory(DirectoryInfo directoryInfo) {
        String string = directoryInfo.getDiskFile(this.getController().getFolderRepository()).toAbsolutePath().toString();
        if (string.length() > 100) {
            int n = (string = string.substring(0, 100)).lastIndexOf(directoryInfo.getDiskFile(this.getController().getFolderRepository()).getFileSystem().getSeparator());
            if (n > -1) {
                string = string.substring(0, n + 1);
            }
            this.pathLabel.setText(string + "...");
        } else {
            this.pathLabel.setText(string);
        }
    }
}

