/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.folders;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.ui.folders.FoldersList;
import de.dal33t.powerfolder.ui.util.UIUtil;
import de.dal33t.powerfolder.ui.widget.ActionLabel;
import de.dal33t.powerfolder.ui.wizard.PFWizard;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class FoldersTab
extends PFUIComponent {
    private JPanel uiComponent;
    private FoldersList foldersList;
    private JScrollPane scrollPane;
    private JLabel connectingLabel = new JLabel(Translation.get("folders_tab.connecting"));
    private JLabel couldNotConnect = new JLabel(Translation.get("folders_tab.could_not_connect"));
    private JLabel notLoggedInLabel = new JLabel(Translation.get("folders_tab.not_logged_in"));
    private ActionLabel loginActionLabel = new ActionLabel(this.getController(), new MyLoginAction());
    private ActionLabel newFolderLink;
    private JLabel noFoldersFoundLabel;
    private ActionLabel folderWizardActionLabel;
    private ActionLabel newFolderActionLabel;
    private JPanel emptyPanelOuter;
    private ServerClient client;

    public FoldersTab(Controller controller) {
        super(controller);
        this.loginActionLabel.setText(Translation.get("folders_tab.login"));
        this.noFoldersFoundLabel = new JLabel(Translation.get("folders_tab.no_folders_found"));
        this.foldersList = new FoldersList(this.getController(), this);
        this.folderWizardActionLabel = new ActionLabel(this.getController(), this.getApplicationModel().getActionModel().getFolderWizardAction());
        this.folderWizardActionLabel.setText(Translation.get("folders_tab.folder_wizard"));
        this.folderWizardActionLabel.setVisible(false);
        this.newFolderActionLabel = new ActionLabel(this.getController(), this.getApplicationModel().getActionModel().getNewFolderAction());
        this.newFolderActionLabel.setText(Translation.get("folders_tab.new_folder"));
        this.newFolderActionLabel.setVisible(false);
        this.client = this.getApplicationModel().getServerClientModel().getClient();
        controller.getThreadPool().scheduleWithFixedDelay(() -> SwingUtilities.invokeLater(() -> this.updateEmptyLabel()), 0L, 30L, TimeUnit.SECONDS);
    }

    public FoldersList getFoldersList() {
        return this.foldersList;
    }

    public JPanel getUIComponent() {
        if (this.uiComponent == null) {
            this.buildUI();
        }
        return this.uiComponent;
    }

    private void buildUI() {
        FormLayout formLayout = new FormLayout("pref:grow", "pref, 3dlu, fill:0:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addSeparator(null, cellConstraints.xy(1, n));
        this.scrollPane = new JScrollPane(this.foldersList.getUIComponent());
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.foldersList.setScroller(this.scrollPane);
        UIUtil.removeBorder(this.scrollPane);
        this.buildEmptyPanel();
        panelBuilder.add((Component)this.emptyPanelOuter, cellConstraints.xywh(1, n += 2, 1, 1));
        panelBuilder.add((Component)this.scrollPane, cellConstraints.xywh(1, n, 1, 1));
        if (!PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder.appendRow("3dlu");
            panelBuilder.appendRow("pref");
            panelBuilder.addSeparator("", cellConstraints.xy(1, n += 2));
        }
        this.uiComponent = panelBuilder.getPanel();
        this.updateEmptyLabel();
    }

    private void buildEmptyPanel() {
        FormLayout formLayout = new FormLayout("center:pref:grow", "center:pref:grow");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        FormLayout formLayout2 = new FormLayout("fill:pref:grow, 3dlu, fill:pref:grow, 3dlu, fill:pref:grow", "pref");
        PanelBuilder panelBuilder2 = new PanelBuilder(formLayout2);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder2.add((Component)this.connectingLabel, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.couldNotConnect, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.notLoggedInLabel, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.loginActionLabel.getUIComponent(), cellConstraints.xy(3, 1));
        panelBuilder2.add((Component)this.noFoldersFoundLabel, cellConstraints.xy(1, 1));
        panelBuilder2.add((Component)this.newFolderActionLabel.getUIComponent(), cellConstraints.xy(3, 1));
        if (PreferencesEntry.EXPERT_MODE.getValueBoolean(this.getController()).booleanValue()) {
            panelBuilder2.add((Component)this.folderWizardActionLabel.getUIComponent(), cellConstraints.xy(5, 1));
        }
        JPanel jPanel = panelBuilder2.getPanel();
        panelBuilder.add((Component)jPanel, cellConstraints.xy(1, 1));
        this.emptyPanelOuter = panelBuilder.getPanel();
    }

    public void updateEmptyLabel() {
        if (this.foldersList == null) {
            return;
        }
        if (this.emptyPanelOuter != null) {
            if (this.foldersList.isEmpty()) {
                String string = this.client.getUsername();
                if (this.client.getServer().isUnableToConnect() && !this.client.isConnected()) {
                    this.connectingLabel.setVisible(false);
                    this.couldNotConnect.setVisible(true);
                    this.notLoggedInLabel.setVisible(false);
                    this.loginActionLabel.setVisible(false);
                    this.noFoldersFoundLabel.setVisible(false);
                    if (this.getController().getOSClient().isAllowedToCreateFolders()) {
                        this.folderWizardActionLabel.setVisible(false);
                        this.newFolderActionLabel.setVisible(false);
                        if (this.newFolderLink != null) {
                            this.newFolderLink.setEnabled(false);
                        }
                    }
                } else if (!this.client.isConnected()) {
                    this.connectingLabel.setVisible(true);
                    this.couldNotConnect.setVisible(false);
                    this.notLoggedInLabel.setVisible(false);
                    this.loginActionLabel.setVisible(false);
                    this.noFoldersFoundLabel.setVisible(false);
                    if (this.getController().getOSClient().isAllowedToCreateFolders()) {
                        this.folderWizardActionLabel.setVisible(false);
                        this.newFolderActionLabel.setVisible(false);
                        if (this.newFolderLink != null) {
                            this.newFolderLink.setEnabled(false);
                        }
                    }
                } else if (string == null || string.trim().length() == 0 || this.client.isPasswordRequired() && this.client.isPasswordEmpty() || !this.client.isLoggedIn()) {
                    this.connectingLabel.setVisible(false);
                    this.couldNotConnect.setVisible(false);
                    this.notLoggedInLabel.setVisible(true);
                    this.loginActionLabel.setVisible(true);
                    this.noFoldersFoundLabel.setVisible(false);
                    if (this.getController().getOSClient().isAllowedToCreateFolders()) {
                        this.folderWizardActionLabel.setVisible(false);
                        this.newFolderActionLabel.setVisible(false);
                        if (this.newFolderLink != null) {
                            this.newFolderLink.setEnabled(false);
                        }
                    }
                } else {
                    this.connectingLabel.setVisible(false);
                    this.couldNotConnect.setVisible(false);
                    this.notLoggedInLabel.setVisible(false);
                    this.loginActionLabel.setVisible(false);
                    this.noFoldersFoundLabel.setVisible(true);
                    if (this.getController().getOSClient().isAllowedToCreateFolders()) {
                        this.folderWizardActionLabel.setVisible(true);
                        this.newFolderActionLabel.setVisible(true);
                        if (this.newFolderLink != null) {
                            this.newFolderLink.setEnabled(true);
                        }
                    } else {
                        this.folderWizardActionLabel.setVisible(false);
                        this.newFolderActionLabel.setVisible(false);
                        if (this.newFolderLink != null) {
                            this.newFolderLink.setEnabled(false);
                        }
                    }
                }
            }
            this.emptyPanelOuter.setVisible(this.foldersList.isEmpty());
        }
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(!this.foldersList.isEmpty());
        }
    }

    public void populate() {
        this.foldersList.populate();
    }

    private class MyLoginAction
    extends AbstractAction {
        MyLoginAction() {
            boolean bl = ConfigurationEntry.SERVER_CONNECT_CHANGE_LOGIN_ALLOWED.getValueBoolean(FoldersTab.this.getController());
            this.setEnabled(bl);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = ConfigurationEntry.SERVER_CONNECT_CHANGE_LOGIN_ALLOWED.getValueBoolean(FoldersTab.this.getController());
            if (bl) {
                PFWizard.openLoginWizard(FoldersTab.this.getController(), FoldersTab.this.getController().getOSClient());
            }
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        ActionLabel label;

        MyServerClientListener(ActionLabel actionLabel) {
            this.label = actionLabel;
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(FoldersTab.this.getController().getOSClient().isAllowedToCreateFolders());
            FoldersTab.this.updateEmptyLabel();
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(FoldersTab.this.getController().getOSClient().isAllowedToCreateFolders());
            FoldersTab.this.updateEmptyLabel();
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(FoldersTab.this.getController().getOSClient().isAllowedToCreateFolders());
            FoldersTab.this.updateEmptyLabel();
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(FoldersTab.this.getController().getOSClient().isAllowedToCreateFolders());
            FoldersTab.this.updateEmptyLabel();
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(FoldersTab.this.getController().getOSClient().isAllowedToCreateFolders());
            FoldersTab.this.updateEmptyLabel();
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

