/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui.action;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.ui.action.FindComputersAction;
import de.dal33t.powerfolder.ui.action.FolderWizardAction;
import de.dal33t.powerfolder.ui.action.NewFolderAction;
import javax.swing.Action;

public class ActionModel
extends PFComponent {
    private FolderWizardAction folderWizardAction;
    private NewFolderAction newFolderAction;
    private FindComputersAction findComputersAction;

    public ActionModel(Controller controller) {
        super(controller);
    }

    public NewFolderAction getNewFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new NewFolderAction(this.getController());
            this.newFolderAction.allowWith(FolderCreatePermission.INSTANCE);
            this.newFolderAction.setEnabled(this.getController().getOSClient().isAllowedToCreateFolders());
            this.getController().getOSClient().addListener(new MyServerClientListener(this.newFolderAction));
            if (!ConfigurationEntry.SHOW_CREATE_FOLDER.getValueBoolean(this.getController()).booleanValue()) {
                this.newFolderAction.setEnabled(false);
            }
        }
        return this.newFolderAction;
    }

    public FolderWizardAction getFolderWizardAction() {
        if (this.folderWizardAction == null) {
            this.folderWizardAction = new FolderWizardAction(this.getController());
            this.folderWizardAction.allowWith(FolderCreatePermission.INSTANCE);
        }
        return this.folderWizardAction;
    }

    public FindComputersAction getFindComputersAction() {
        if (this.findComputersAction == null) {
            this.findComputersAction = new FindComputersAction(this.getController());
        }
        return this.findComputersAction;
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private Action label;

        MyServerClientListener(Action action) {
            this.label = action;
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(ActionModel.this.getController().getOSClient().isAllowedToCreateFolders());
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(ActionModel.this.getController().getOSClient().isAllowedToCreateFolders());
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(ActionModel.this.getController().getOSClient().isAllowedToCreateFolders());
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(ActionModel.this.getController().getOSClient().isAllowedToCreateFolders());
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
            this.label.setEnabled(ActionModel.this.getController().getOSClient().isAllowedToCreateFolders());
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return true;
        }
    }
}

