/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.ui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.FolderRepository;
import de.dal33t.powerfolder.net.NodeManager;
import de.dal33t.powerfolder.ui.PFUIComponent;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.Translation;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NetworkStatisticsPanel
extends PFUIComponent {
    private JPanel panel;
    private JPanel networkStatsPanel;
    private JLabel connectedUsers;
    private JLabel onlineUsers;
    private JLabel knownUsers;
    private JLabel publicFolderCount;
    private JLabel localFolderCount;
    private JLabel publicFoldersSize;
    private JLabel localFoldersSize;
    private JLabel numberOfPublicFiles;
    private JLabel numberOfLocalFiles;
    private JLabel reconnectionQueueSize;
    private JButton updateButton;

    public NetworkStatisticsPanel(Controller controller) {
        super(controller);
    }

    public Component getUIComponent() {
        if (this.panel == null) {
            this.initComponents();
            FormLayout formLayout = new FormLayout("fill:pref:grow", "fill:pref:grow, pref, pref");
            PanelBuilder panelBuilder = new PanelBuilder(formLayout);
            CellConstraints cellConstraints = new CellConstraints();
            panelBuilder.add((Component)this.networkStatsPanel, cellConstraints.xy(1, 1));
            this.panel = panelBuilder.getPanel();
        }
        this.update();
        return this.panel;
    }

    public String getTitle() {
        return Translation.get("exp.network.statistics.title");
    }

    private void initComponents() {
        NodeManager nodeManager = this.getController().getNodeManager();
        FolderRepository folderRepository = this.getController().getFolderRepository();
        this.connectedUsers = new JLabel();
        this.onlineUsers = new JLabel();
        this.knownUsers = new JLabel();
        this.publicFolderCount = new JLabel();
        this.localFolderCount = new JLabel();
        this.publicFoldersSize = new JLabel();
        this.localFoldersSize = new JLabel();
        this.numberOfLocalFiles = new JLabel();
        this.numberOfPublicFiles = new JLabel();
        this.reconnectionQueueSize = new JLabel();
        this.updateButton = new JButton(Translation.get("general.update"));
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NetworkStatisticsPanel.this.update();
            }
        });
        FormLayout formLayout = new FormLayout("pref, 3dlu, pref", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 6dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.connected_computers")), cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.connectedUsers, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.online_computers")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.onlineUsers, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.known_computers")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.knownUsers, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.reconnection_queue_size")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.reconnectionQueueSize, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.local_folder_count")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.localFolderCount, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.number_of_local_files")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.numberOfLocalFiles, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.local_folders_size")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.localFoldersSize, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.public_folder_count")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.publicFolderCount, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.number_of_public_files")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.numberOfPublicFiles, cellConstraints.xy(3, n));
        panelBuilder.add((Component)new JLabel(Translation.get("exp.network_statistics_panel.public_folders_size")), cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.publicFoldersSize, cellConstraints.xy(3, n));
        panelBuilder.add((Component)this.updateButton, cellConstraints.xy(3, n += 2));
        this.networkStatsPanel = panelBuilder.getPanel();
    }

    private void update() {
        int n = this.getController().getNodeManager().countConnectedNodes();
        int n2 = this.getController().getNodeManager().countConnectedSupernodes();
        int n3 = this.getController().getNodeManager().countOnlineNodes();
        int n4 = this.getController().getNodeManager().countOnlineSupernodes();
        int n5 = this.getController().getNodeManager().getNodesAsCollection().size();
        int n6 = this.getController().getNodeManager().countSupernodes();
        int n7 = 0;
        int n8 = 0;
        for (Member object2 : this.getController().getNodeManager().getNodesAsCollection()) {
            if (object2.isDontConnect()) {
                ++n7;
            }
            if (!object2.isUnableToConnect()) continue;
            ++n8;
        }
        this.connectedUsers.setText(n + " (" + n2 + ") X: " + n8 + " R: " + n7 + " ");
        this.onlineUsers.setText(n3 + " (" + n4 + ")");
        this.knownUsers.setText(n5 + " (" + n6 + ")");
        this.reconnectionQueueSize.setText("" + this.getController().getReconnectManager().countReconnectionQueue());
        FolderRepository folderRepository = this.getController().getFolderRepository();
        Collection<Folder> collection = folderRepository.getFolders();
        long l = 0L;
        long l2 = 0L;
        for (Folder folder : collection) {
            l += (long)folder.getKnownItemCount();
            l2 += folder.getStatistic().getSize(this.getController().getMySelf());
        }
        long l3 = 0L;
        this.publicFoldersSize.setText(Format.formatBytes(l3));
        this.localFoldersSize.setText(Format.formatBytes(l2));
        long l4 = 0L;
        this.numberOfPublicFiles.setText(Format.formatLong(l4));
        this.numberOfLocalFiles.setText(Format.formatLong(l));
        int n9 = folderRepository.getFoldersCount();
        this.publicFolderCount.setText("n/a");
        this.localFolderCount.setText("" + n9);
    }
}

