/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.message.AbortDownload;
import de.dal33t.powerfolder.message.FileChunk;
import de.dal33t.powerfolder.message.RequestDownload;
import de.dal33t.powerfolder.message.RequestDownloadExt;
import de.dal33t.powerfolder.message.RequestFilePartsRecord;
import de.dal33t.powerfolder.message.RequestPart;
import de.dal33t.powerfolder.message.RequestPartExt;
import de.dal33t.powerfolder.message.StopUpload;
import de.dal33t.powerfolder.message.StopUploadExt;
import de.dal33t.powerfolder.transfer.BrokenDownloadException;
import de.dal33t.powerfolder.transfer.DownloadManager;
import de.dal33t.powerfolder.transfer.Transfer;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.util.Range;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.Validate;
import de.dal33t.powerfolder.util.delta.FilePartsRecord;
import de.dal33t.powerfolder.util.logging.Loggable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class Download
extends Transfer {
    private static final long serialVersionUID = 100L;
    private Date lastTouch;
    private final boolean automatic;
    private boolean queued;
    private boolean markedBroken;
    private Queue<RequestPart> pendingRequests = new ConcurrentLinkedQueue<RequestPart>();
    private transient DownloadManager dlManager;
    private long lastBrokenCheck;
    private boolean brokenCache;

    public Download() {
        this.automatic = false;
    }

    Download(TransferManager transferManager, FileInfo fileInfo, boolean bl) {
        super(transferManager, fileInfo, null);
        this.lastTouch = new Date();
        this.automatic = bl;
        this.queued = false;
        this.markedBroken = false;
    }

    @Override
    void init(TransferManager transferManager) {
        super.init(transferManager);
        this.queued = false;
        this.markedBroken = false;
    }

    public boolean isRequestedAutomatic() {
        return this.automatic;
    }

    public synchronized void setDownloadManager(DownloadManager downloadManager) {
        Reject.ifNull(downloadManager, "Handler is null!");
        if (!downloadManager.getFileInfo().isVersionDateAndSizeIdentical(this.getFile())) {
            throw new IllegalArgumentException("Fileinfos mismatch. expected " + this.getFile().toDetailString() + ", got " + downloadManager.getFileInfo().toDetailString());
        }
        if (this.dlManager != null) {
            throw new IllegalStateException("DownloadManager already set!");
        }
        this.dlManager = downloadManager;
    }

    public DownloadManager getDownloadManager() {
        return this.dlManager;
    }

    public void uploadStarted(FileInfo fileInfo) {
        this.checkFileInfo(fileInfo);
        this.lastTouch.setTime(System.currentTimeMillis());
        if (this.isStarted()) {
            if (this.isFine()) {
                this.logFine("Aborting. Received multiple upload start messages: " + this);
            }
            this.abort();
            return;
        }
        if (this.isFiner()) {
            this.logFiner("Uploader supports partial transfers for " + fileInfo.toDetailString());
        }
        this.setStarted();
        this.dlManager.readyForRequests(this);
    }

    void requestFilePartsRecord() {
        assert (Util.useDeltaSync(this.getController(), this)) : "Requesting FilePartsRecord from a client that doesn't support that!";
        this.requestCheckState();
        this.getPartner().sendMessagesAsynchron(new RequestFilePartsRecord(this.getFile()));
    }

    public void receivedFilePartsRecord(FileInfo fileInfo, FilePartsRecord filePartsRecord) {
        Reject.ifNull(filePartsRecord, "Record is null");
        this.checkFileInfo(fileInfo);
        this.lastTouch.setTime(System.currentTimeMillis());
        if (this.isFine()) {
            this.logFine("Received parts record for " + fileInfo.toDetailString() + ": " + filePartsRecord);
        }
        this.dlManager.filePartsRecordReceived(this, filePartsRecord);
    }

    boolean requestPart(Range range) throws BrokenDownloadException {
        RequestPart requestPart;
        Validate.notNull(range);
        this.requestCheckState();
        if (this.pendingRequests.size() >= this.getTransferManager().getMaxRequestsQueued()) {
            if (this.isFiner()) {
                this.logFiner("X Skipping request. Already got too many pending requests: " + range);
            }
            return false;
        }
        if (this.isFiner()) {
            this.logFiner("X requestPart: " + range);
        }
        try {
            requestPart = this.getPartner().getProtocolVersion() >= 110 ? new RequestPartExt(this.getFile(), range, Math.max(0.0, this.state.getProgress())) : new RequestPart(this.getFile(), range, Math.max(0.0, this.state.getProgress()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.isWarning()) {
                this.logWarning("Concurrent file change while requesting:" + illegalArgumentException);
            }
            throw new BrokenDownloadException("Concurrent file change while requesting: " + illegalArgumentException);
        }
        this.pendingRequests.add(requestPart);
        this.getPartner().sendMessagesAsynchron(requestPart);
        return true;
    }

    public Collection<RequestPart> getPendingRequests() {
        return Collections.unmodifiableCollection(this.pendingRequests);
    }

    public boolean addChunk(FileChunk fileChunk) {
        Reject.ifNull(fileChunk, "Chunk is null");
        this.checkFileInfo(fileChunk.file);
        this.getTransferManager().chunkAdded(this, fileChunk);
        if (this.isBroken()) {
            this.setBroken(TransferProblem.BROKEN_DOWNLOAD, "isBroken()");
            return false;
        }
        if (!this.isStarted()) {
            if (Util.useSwarming(this.getController(), this.getPartner())) {
                this.setStarted();
            } else {
                if (this.isWarning()) {
                    this.logWarning("Ignoring file chunk for non-started " + this);
                }
                return false;
            }
        }
        this.lastTouch.setTime(System.currentTimeMillis());
        Range range = Range.getRangeByLength(fileChunk.offset, fileChunk.data.length);
        Iterator iterator = this.pendingRequests.iterator();
        while (iterator.hasNext()) {
            RequestPart requestPart = (RequestPart)iterator.next();
            if (!requestPart.getRange().contains(range)) continue;
            iterator.remove();
        }
        this.getCounter().chunkTransferred(fileChunk);
        this.dlManager.chunkReceived(this, fileChunk);
        return true;
    }

    void request(long l) {
        Reject.ifTrue(l < 0L || l >= this.getFile().getSize(), "Invalid startOffset: " + l);
        this.requestCheckState();
        if (this.isFiner()) {
            this.logFiner("request(" + l + "): " + this.getFile().toDetailString());
        }
        if (this.getPartner().getProtocolVersion() >= 110) {
            this.getPartner().sendMessagesAsynchron(new RequestDownloadExt(this.getFile(), l));
        } else {
            this.getPartner().sendMessagesAsynchron(new RequestDownload(this.getFile(), l));
        }
    }

    void abort() {
        this.abort(true);
    }

    void abort(boolean bl) {
        this.shutdown();
        if (this.getPartner() != null && this.getPartner().isCompletelyConnected() && bl) {
            this.getPartner().sendMessageAsynchron(new AbortDownload(this.getFile()));
        }
        if (this.getDownloadManager() == null) {
            this.logSevere(this + " has no DownloadManager! (abort before start?)");
            this.getController().getTransferManager().downloadAborted(this);
            return;
        }
        this.getController().getTransferManager().downloadAborted(this);
    }

    public void setQueued(FileInfo fileInfo) {
        Reject.ifNull(fileInfo, "fInfo is null!");
        this.checkFileInfo(fileInfo);
        if (this.isFiner()) {
            this.logFiner("DL queued by remote side: " + this);
        }
        this.queued = true;
        this.getTransferManager().downloadQueued(this, this.getPartner());
    }

    @Override
    void setCompleted() {
        super.setCompleted();
        if (this.getPartner().getProtocolVersion() >= 110) {
            this.getPartner().sendMessagesAsynchron(new StopUploadExt(this.getFile()));
        } else {
            this.getPartner().sendMessagesAsynchron(new StopUpload(this.getFile()));
        }
        this.getTransferManager().doWork(() -> this.getTransferManager().setCompleted(this));
    }

    public boolean isPending() {
        return !this.isCompleted() && this.getPartner() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setBroken(TransferProblem transferProblem, String string) {
        Loggable loggable = this;
        synchronized (loggable) {
            if (this.markedBroken) {
                if (this.isFiner()) {
                    this.logFiner("Not breaking already marked broken download");
                }
                return;
            }
            this.markedBroken = true;
        }
        loggable = this.getPartner();
        if (loggable != null && ((Member)loggable).isCompletelyConnected()) {
            ((Member)loggable).sendMessageAsynchron(new AbortDownload(this.getFile()));
        }
        this.shutdown();
        this.getTransferManager().downloadBroken(this, transferProblem, string);
    }

    @Override
    public boolean isBroken() {
        boolean bl;
        if (this.markedBroken) {
            return true;
        }
        if (super.isBroken()) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastBrokenCheck < 1000L) {
            return this.brokenCache;
        }
        this.lastBrokenCheck = System.currentTimeMillis();
        if (this.stateCanTimeout()) {
            boolean bl2 = bl = System.currentTimeMillis() - 180000L > this.lastTouch.getTime() && !this.queued;
            if (bl) {
                if (this.isFine()) {
                    this.logFine("Break cause: Timeout. " + this.getFile().toDetailString());
                }
                this.brokenCache = true;
                return true;
            }
        }
        if (!(bl = this.stillQueuedAtPartner())) {
            if (this.isFine()) {
                this.logFine("Break cause: not queued.");
            }
            this.brokenCache = true;
            return true;
        }
        boolean bl3 = this.getFile().isNewerAvailable(this.getController().getFolderRepository());
        if (bl3) {
            if (this.isFine()) {
                this.logFine("Break cause: Newer version available. " + this.getFile().toDetailString());
            }
            this.brokenCache = true;
            return true;
        }
        this.brokenCache = false;
        return false;
    }

    private boolean stateCanTimeout() {
        Transfer.TransferState transferState = this.getTransferState();
        return transferState != Transfer.TransferState.FILERECORD_REQUEST && transferState != Transfer.TransferState.VERIFYING && transferState != Transfer.TransferState.MATCHING;
    }

    public boolean isQueued() {
        return this.queued && !this.isBroken();
    }

    public int hashCode() {
        int n = 37;
        if (this.getFile() != null) {
            n += this.getFile().hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof Download) {
            Download download = (Download)object;
            return Util.equals(this.getFile(), download.getFile());
        }
        return false;
    }

    public String toString() {
        String string = "Download: " + this.getFile().toDetailString();
        if (this.getPartner() != null) {
            string = string + " from '" + this.getPartner().getNick() + "'";
            if (this.getPartner().isOnLAN()) {
                string = string + " (local-net)";
            }
        } else {
            string = string + " (pending)";
        }
        return string;
    }

    private void requestCheckState() {
        if (this.dlManager == null) {
            throw new IllegalStateException("DownloadManager not set!");
        }
    }

    private void checkFileInfo(FileInfo fileInfo) {
        Reject.ifFalse(fileInfo.isVersionDateAndSizeIdentical(this.getFile()), "FileInfo mismatch!");
    }
}

