/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.transfer;

import de.dal33t.powerfolder.transfer.BandwidthLimiterInfo;
import de.dal33t.powerfolder.transfer.BandwidthStat;
import java.util.Date;

public class BandwidthLimiter {
    public static final long UNLIMITED = -1L;
    public static final BandwidthLimiter WAN_OUTPUT_BANDWIDTH_LIMITER = new BandwidthLimiter(BandwidthLimiterInfo.WAN_OUTPUT);
    public static final BandwidthLimiter WAN_INPUT_BANDWIDTH_LIMITER = new BandwidthLimiter(BandwidthLimiterInfo.WAN_INPUT);
    public static final BandwidthLimiter LAN_OUTPUT_BANDWIDTH_LIMITER = new BandwidthLimiter(BandwidthLimiterInfo.LAN_OUTPUT);
    public static final BandwidthLimiter LAN_INPUT_BANDWIDTH_LIMITER = new BandwidthLimiter(BandwidthLimiterInfo.LAN_INPUT);
    private long initialAvailable = -1L;
    private long available = -1L;
    private final Object monitor = new Object();
    private final BandwidthLimiterInfo id;

    public BandwidthLimiter(BandwidthLimiterInfo bandwidthLimiterInfo) {
        this.id = bandwidthLimiterInfo;
    }

    public BandwidthLimiterInfo getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long requestBandwidth(long l) throws InterruptedException {
        if (this.isUnlimited()) {
            return l;
        }
        Object object = this.monitor;
        synchronized (object) {
            long l2;
            while (this.available == 0L) {
                this.monitor.wait();
            }
            long l3 = l2 = this.available < 0L ? l : Math.min(this.available, l);
            if (this.available >= 0L) {
                this.available -= l2;
            }
            return l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BandwidthStat setAvailable(long l) {
        BandwidthStat bandwidthStat;
        Object object = this.monitor;
        synchronized (object) {
            bandwidthStat = new BandwidthStat(new Date(), this.id, this.initialAvailable, this.available);
            this.initialAvailable = l;
            this.available = l;
            if (this.available != 0L) {
                this.monitor.notifyAll();
            }
        }
        return bandwidthStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailable() {
        Object object = this.monitor;
        synchronized (object) {
            return this.available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnAvailable(int n) {
        if (this.isUnlimited()) {
            return;
        }
        if (n == 0) {
            return;
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.available >= 0L) {
                this.available += (long)n;
            }
        }
    }

    private boolean isUnlimited() {
        return this.available == -1L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BandwidthLimiter bandwidthLimiter = (BandwidthLimiter)object;
        return this.id == bandwidthLimiter.id;
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "BandwidthLimiter{id=" + this.id + "}";
    }
}

