/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.clientserver.RemoteCallException;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.clientserver.ServerClientEvent;
import de.dal33t.powerfolder.clientserver.ServerClientListener;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.task.PersistentTask;
import de.dal33t.powerfolder.util.Reject;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerRemoteCallTask
extends PersistentTask {
    private static final Logger LOG = Logger.getLogger(ServerRemoteCallTask.class.getName());
    private static final long serialVersionUID = 100L;
    private transient ServerClientListener listener;
    private final AccountInfo issuer;

    protected ServerRemoteCallTask(AccountInfo accountInfo, int n) {
        super(n);
        Reject.ifNull(accountInfo, "Account issuer");
        this.issuer = accountInfo;
    }

    protected ServerRemoteCallTask(int n) {
        super(n);
        this.issuer = null;
    }

    protected AccountInfo getIssuer() {
        return this.issuer;
    }

    @Override
    public void initialize() {
        if (this.isExpired()) {
            this.remove();
            return;
        }
        ServerClient serverClient = this.getController().getOSClient();
        this.listener = new MyServerClientListener();
        serverClient.addListener(this.listener);
        if (!this.checkAndExecute(serverClient)) {
            this.getController().schedule(() -> this.checkAndExecute(serverClient), 3000L);
        }
    }

    @Override
    public void remove() {
        super.remove();
        if (this.listener != null) {
            this.getController().getOSClient().removeListener(this.listener);
        }
    }

    protected abstract boolean executeRemoteCall(ServerClient var1) throws Exception;

    private synchronized boolean checkAndExecute(ServerClient serverClient) {
        if (!serverClient.isConnected()) {
            return false;
        }
        if (this.issuer != null) {
            AccountInfo accountInfo = serverClient.getAccountInfo();
            if (accountInfo == null) {
                return false;
            }
            if (!this.issuer.equals(accountInfo)) {
                return false;
            }
        }
        try {
            return this.executeRemoteCall(serverClient);
        }
        catch (RemoteCallException remoteCallException) {
            LOG.log(Level.WARNING, "Exception while executing remote call. " + remoteCallException);
            return false;
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Exception while executing remote call. " + exception, exception);
            return false;
        }
    }

    private class MyServerClientListener
    implements ServerClientListener {
        private MyServerClientListener() {
        }

        @Override
        public void accountUpdated(ServerClientEvent serverClientEvent) {
            ServerRemoteCallTask.this.checkAndExecute(serverClientEvent.getClient());
        }

        @Override
        public void login(ServerClientEvent serverClientEvent) {
            ServerRemoteCallTask.this.checkAndExecute(serverClientEvent.getClient());
        }

        @Override
        public void serverConnected(ServerClientEvent serverClientEvent) {
            ServerRemoteCallTask.this.checkAndExecute(serverClientEvent.getClient());
        }

        @Override
        public void nodeServerStatusChanged(ServerClientEvent serverClientEvent) {
            ServerRemoteCallTask.this.checkAndExecute(serverClientEvent.getClient());
        }

        @Override
        public void childClientSpawned(ServerClientEvent serverClientEvent) {
        }

        @Override
        public void serverDisconnected(ServerClientEvent serverClientEvent) {
        }

        @Override
        public boolean fireInEventDispatchThread() {
            return false;
        }
    }
}

