/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.task;

import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.task.ServerRemoteCallTask;
import de.dal33t.powerfolder.util.Reject;
import java.util.logging.Logger;

public class FolderObtainPermissionTask
extends ServerRemoteCallTask {
    private static final long serialVersionUID = 100L;
    private static final Logger LOG = Logger.getLogger(FolderObtainPermissionTask.class.getName());
    private FolderInfo foInfo;

    public FolderObtainPermissionTask(AccountInfo accountInfo, FolderInfo folderInfo) {
        super(accountInfo, 30);
        Reject.ifNull(folderInfo, "FolderInfo");
        this.foInfo = folderInfo;
    }

    @Override
    public boolean executeRemoteCall(ServerClient serverClient) throws Exception {
        if (!this.getController().getFolderRepository().hasJoinedFolder(this.foInfo)) {
            this.remove();
            return true;
        }
        if (this.getController().getOSClient().getServer().isMySelf()) {
            this.remove();
            return true;
        }
        FolderPermission folderPermission = serverClient.getSecurityService().obtainFolderPermission(this.foInfo);
        LOG.fine("Obtained permission on " + this.foInfo + ": " + folderPermission);
        this.remove();
        return true;
    }
}

