/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.security.ComputersAppPermission;
import de.dal33t.powerfolder.security.ConfigAppPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.OrganizationCreatePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SystemSettingsPermission;
import de.dal33t.powerfolder.util.StringUtils;
import java.lang.reflect.Field;

public class SingletonPermission
implements Permission,
D2DObject {
    public static final String PERMISSION_PACKAGE_PREFIX = "de.dal33t.powerfolder.security.";
    private static final long serialVersionUID = 100L;

    public static SingletonPermission getByID(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        String string2 = PERMISSION_PACKAGE_PREFIX + string;
        if (!string2.endsWith("Permission")) {
            string2 = string2 + "Permission";
        }
        try {
            Object object;
            Class<?> clazz = Class.forName(string2);
            try {
                Field field = clazz.getField("INSTANCE");
                object = field.get(null);
            }
            catch (Exception exception) {
                object = clazz.newInstance();
            }
            return (SingletonPermission)object;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean implies(Permission permission) {
        return false;
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    public final int hashCode() {
        return 31;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass().isInstance(object);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
    }

    @Override
    public AbstractMessage toD2D() {
        PermissionInfoProto.PermissionInfo.Builder builder = PermissionInfoProto.PermissionInfo.newBuilder();
        builder.setClazzName("PermissionInfo");
        if (this instanceof AdminPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.ADMIN);
        } else if (this instanceof ChangePreferencesPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.CHANGE_PREFERENCES);
        } else if (this instanceof ChangeTransferModePermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.CHANGE_TRANSFER_MODE);
        } else if (this instanceof ComputersAppPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.COMPUTERS_APP);
        } else if (this instanceof ConfigAppPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.CONFIG_APP);
        } else if (this instanceof FolderCreatePermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_CREATE);
        } else if (this instanceof FolderRemovePermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.FOLDER_REMOVE);
        } else if (this instanceof OrganizationCreatePermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.ORGANIZATION_CREATE);
        } else if (this instanceof SystemSettingsPermission) {
            builder.setPermissionType(PermissionTypeProto.PermissionType.SYSTEM_SETTINGS);
        }
        return builder.build();
    }
}

