/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.FolderDeletePermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.util.Translation;

public class FolderReadWritePermission
extends FolderPermission {
    private static final long serialVersionUID = 100L;

    FolderReadWritePermission(FolderInfo folderInfo) {
        super(folderInfo);
    }

    public FolderReadWritePermission(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    @Override
    public String getName() {
        return Translation.get("permissions.folder.read_write");
    }

    @Override
    public AccessMode getMode() {
        return AccessMode.READ_WRITE;
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission instanceof FolderReadPermission) {
            FolderReadPermission folderReadPermission = (FolderReadPermission)permission;
            return folderReadPermission.getFolder().equals(this.getFolder());
        }
        if (permission instanceof FolderDeletePermission) {
            FolderDeletePermission folderDeletePermission = (FolderDeletePermission)permission;
            return folderDeletePermission.getFolder().equals(this.getFolder());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.folder == null ? 0 : this.folder.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FolderReadWritePermission)) {
            return false;
        }
        FolderReadWritePermission folderReadWritePermission = (FolderReadWritePermission)object;
        return !(this.folder == null ? folderReadWritePermission.folder != null : !this.folder.equals(folderReadWritePermission.folder));
    }
}

