/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.SyncProfile;
import de.dal33t.powerfolder.light.AccountInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.light.ServerInfo;
import de.dal33t.powerfolder.protocol.AccountInfoProto;
import de.dal33t.powerfolder.protocol.GroupInfoProto;
import de.dal33t.powerfolder.protocol.PermissionInfoProto;
import de.dal33t.powerfolder.security.AccessMode;
import de.dal33t.powerfolder.security.AdminPermission;
import de.dal33t.powerfolder.security.AuditFields;
import de.dal33t.powerfolder.security.Auditable;
import de.dal33t.powerfolder.security.ChangePreferencesPermission;
import de.dal33t.powerfolder.security.ChangeTransferModePermission;
import de.dal33t.powerfolder.security.ComputersAppPermission;
import de.dal33t.powerfolder.security.ConfigAppPermission;
import de.dal33t.powerfolder.security.CustomFields;
import de.dal33t.powerfolder.security.FolderAdminPermission;
import de.dal33t.powerfolder.security.FolderCreatePermission;
import de.dal33t.powerfolder.security.FolderOwnerPermission;
import de.dal33t.powerfolder.security.FolderPermission;
import de.dal33t.powerfolder.security.FolderReadPermission;
import de.dal33t.powerfolder.security.FolderReadWritePermission;
import de.dal33t.powerfolder.security.FolderRemovePermission;
import de.dal33t.powerfolder.security.Group;
import de.dal33t.powerfolder.security.GroupAdminPermission;
import de.dal33t.powerfolder.security.OnlineStorageSubscription;
import de.dal33t.powerfolder.security.OrganizationAdminPermission;
import de.dal33t.powerfolder.security.OrganizationCreatePermission;
import de.dal33t.powerfolder.security.Permission;
import de.dal33t.powerfolder.security.SingletonPermission;
import de.dal33t.powerfolder.security.SystemSettingsPermission;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.LoginUtil;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.db.PermissionUserType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.IndexColumn;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.hibernate.annotations.MapKeyManyToMany;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.json.JSONException;
import org.json.JSONObject;

@TypeDef(name="permissionType", typeClass=PermissionUserType.class)
@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class Account
implements Serializable,
D2DObject,
Auditable {
    private static final Logger LOG = Logger.getLogger(Account.class.getName());
    private static final long serialVersionUID = 100L;
    public static final String PROPERTYNAME_OID = "oid";
    public static final String PROPERTYNAME_USERNAME = "username";
    public static final String PROPERTYNAME_PASSWORD = "password";
    public static final String PROPERTYNAME_OTP = "otp";
    public static final String PROPERTYNAME_LDAPDN = "ldapDN";
    public static final String PROPERTYNAME_SHIBBOLETH_PERSISTENT_ID = "shibbolethPersistentID";
    public static final String PROPERTYNAME_LANGUAGE = "language";
    public static final String PROPERTYNAME_PERMISSIONS = "permissions";
    public static final String PROPERTYNAME_REGISTER_DATE = "registerDate";
    public static final String PROPERTYNAME_LAST_LOGIN_DATE = "lastLoginDate";
    public static final String PROPERTYNAME_LAST_LOGIN_FROM = "lastLoginFrom";
    public static final String PROPERTYNAME_NEWSLETTER = "newsLetter";
    public static final String PROPERTYNAME_PRO_USER = "proUser";
    public static final String PROPERTYNAME_NOTES = "notes";
    public static final String PROPERTYNAME_SERVER = "server";
    public static final String PROPERTYNAME_BASE_PATH = "basePath";
    public static final String PROPERTYNAME_DEFAULT_SYNCHRONIZED_FOLDER = "defaultSynchronizedFolder";
    public static final String PROPERTYNAME_OS_SUBSCRIPTION = "osSubscription";
    public static final String PROPERTYNAME_LICENSE_KEY_FILES = "licenseKeyFiles";
    public static final String PROPERTYNAME_COMPUTERS = "computers";
    public static final String PROPERTYNAME_GROUPS = "groups";
    public static final String PROPERTYNAME_DISPLAYNAME = "displayName";
    public static final String PROPERTYNAME_FIRSTNAME = "firstname";
    public static final String PROPERTYNAME_SURNAME = "surname";
    public static final String PROPERTYNAME_TELEPHONE = "telephone";
    public static final String PROPERTYNAME_EMAILS = "emails";
    public static final String PROPERTYNAME_ORGANIZATION_ID = "organizationOID";
    public static final String PROPERTYNAME_AGREED_TOS_VERSION = "agreedToSVersion";
    public static final String PROPERTYNAME_JSON_DATA = "jsonData";
    @Id
    private String oid;
    @Index(name="IDX_USERNAME")
    @Column(nullable=false, unique=true)
    private String username;
    private String password;
    @Index(name="IDX_AOTP")
    @Column(length=127)
    private String otp;
    @CollectionOfElements(targetElement=String.class)
    @MapKeyManyToMany(targetEntity=ServerInfo.class, joinColumns={@JoinColumn(name="serviceInfo_id")})
    @JoinTable(name="Account_tokens", joinColumns={@JoinColumn(name="oid")})
    @Column(name="tokenSecret")
    @BatchSize(size=1337)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Map<ServerInfo, String> tokens;
    @Column(length=15)
    private String language;
    @Index(name="IDX_LDAPDN")
    @Column(length=511)
    private String ldapDN;
    @Index(name="IDX_SHIB_PID")
    @Column(length=2047)
    private String shibbolethPersistentID;
    private Date registerDate;
    private Date lastLoginDate;
    @ManyToOne
    @JoinColumn(name="lastLoginFrom_id")
    private MemberInfo lastLoginFrom;
    private boolean proUser;
    private Integer maxFolders;
    @Column(length=63)
    private String title;
    @Column(length=127)
    @Index(name="IDX_ACC_FIRSTNAME")
    private String firstname;
    @Column(length=127)
    @Index(name="IDX_ACC_SURNAME")
    private String surname;
    @Column(length=63)
    private String telephone;
    @Column(length=511)
    private String twoFactorAuthenticationToken;
    @Column(length=255)
    private String encodedRecoveryPhrase;
    @Column(length=2047)
    private String jsonData;
    @Column(length=2047)
    private String notes;
    @Column(length=511)
    private String basePath;
    @Index(name="IDX_ACC_ORG_ID")
    @Column(nullable=true, unique=false)
    private String organizationOID;
    private Date activated;
    @ManyToMany
    @JoinTable(name="Account_Computers", joinColumns={@JoinColumn(name="oid")}, inverseJoinColumns={@JoinColumn(name="id")})
    @BatchSize(size=1337)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Collection<MemberInfo> computers;
    @ManyToOne
    @JoinColumn(name="serverInfo_id")
    private ServerInfo server;
    private boolean serverStatic;
    @Deprecated
    @Transient
    private Collection<String> licenseKeyFiles;
    @CollectionOfElements
    @IndexColumn(name="IDX_LICENSE", base=0, nullable=false)
    @Cascade(value={CascadeType.ALL})
    @BatchSize(size=1337)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<String> licenseKeyFileList;
    private int autoRenewDevices;
    private Date autoRenewTill;
    @ManyToOne
    @JoinColumn(name="defaultSyncFolder_id")
    private FolderInfo defaultSynchronizedFolder;
    @CollectionOfElements
    @Type(type="permissionType")
    @BatchSize(size=1337)
    @Cache(usage=CacheConcurrencyStrategy.NONE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Collection<Permission> permissions;
    @ManyToMany
    @JoinTable(name="Account_Groups", joinColumns={@JoinColumn(name="Account_oid")}, inverseJoinColumns={@JoinColumn(name="AGroup_oid")})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private Collection<Group> groups;
    @CollectionOfElements
    @IndexColumn(name="IDX_EMAIL", base=0, nullable=false)
    @Cascade(value={CascadeType.ALL})
    @BatchSize(size=1337)
    @Column(name="element", length=512)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @LazyCollection(value=LazyCollectionOption.FALSE)
    private List<String> emails;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    private CustomFields customFields;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    private OnlineStorageSubscription osSubscription;
    private int agreedToSVersion;
    @Embedded
    @Fetch(value=FetchMode.JOIN)
    public AuditFields auditFields = new AuditFields();

    Account() {
        this(IdGenerator.makeId());
    }

    Account(String string) {
        Reject.ifBlank(string, "OID");
        this.oid = string;
        this.permissions = new CopyOnWriteArrayList<Permission>();
        this.osSubscription = new OnlineStorageSubscription();
        this.customFields = new CustomFields();
        this.licenseKeyFiles = new CopyOnWriteArrayList<String>();
        this.computers = new CopyOnWriteArrayList<MemberInfo>();
        this.licenseKeyFileList = new CopyOnWriteArrayList<String>();
        this.groups = new CopyOnWriteArrayList<Group>();
        this.emails = new CopyOnWriteArrayList<String>();
        this.tokens = new ConcurrentHashMap<ServerInfo, String>();
    }

    public Account(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public AccountInfo createInfo() {
        return new AccountInfo(this.oid, this.username, this.getDisplayName());
    }

    public synchronized void grant(Permission ... permissionArray) {
        Reject.ifNull(permissionArray, "Permission is null");
        for (Permission permission : permissionArray) {
            Reject.ifNull(permission, "Permission is null");
            if (this.hasPermission(permission)) continue;
            if (permission instanceof FolderPermission) {
                FolderInfo folderInfo = ((FolderPermission)permission).getFolder();
                this.revokeAllFolderPermission(folderInfo);
                if (folderInfo.isMetaFolder()) {
                    LOG.severe(this + ": Not allowed to grant permissions " + folderInfo);
                    continue;
                }
            }
            this.permissions.add(permission);
        }
        LOG.fine("Granted permission to " + this + ": " + Arrays.asList(permissionArray));
    }

    public synchronized void revoke(Permission ... permissionArray) {
        Reject.ifNull(permissionArray, "Permission is null");
        for (Permission permission : permissionArray) {
            Reject.ifNull(permission, "Permission is null");
            if (!this.permissions.remove(permission)) continue;
            LOG.fine("Revoked permission from " + this + ": " + permission);
        }
    }

    public void revokeAllFolderPermission(FolderInfo folderInfo) {
        this.revoke(FolderPermission.read(folderInfo), FolderPermission.readWrite(folderInfo), FolderPermission.admin(folderInfo), FolderPermission.owner(folderInfo));
    }

    public void revokeAllFolderPermission() {
        for (Permission permission : this.permissions) {
            if (!(permission instanceof FolderPermission)) continue;
            this.revoke(permission);
        }
    }

    public synchronized void revokeAllPermissions() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Revoking all permission from " + this + ": " + this.permissions);
        }
        this.permissions.clear();
    }

    public boolean hasPermission(Permission permission) {
        Reject.ifNull(permission, "Permission is null");
        if (this.permissions == null) {
            LOG.severe("Illegal account " + this.username + ", permissions is null");
            return false;
        }
        for (Permission serializable : this.permissions) {
            if (serializable == null) {
                LOG.severe("Got null permission on " + this);
                continue;
            }
            if (serializable.equals(permission)) {
                return true;
            }
            if (!serializable.implies(permission)) continue;
            return true;
        }
        for (Group group : this.groups) {
            if (!group.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnyFolderAdmin() {
        for (Permission serializable : this.permissions) {
            Object object;
            if (serializable == null || !(serializable instanceof FolderPermission) || !((Enum)(object = ((FolderPermission)serializable).getMode())).equals((Object)AccessMode.ADMIN) && !((Enum)object).equals((Object)AccessMode.OWNER)) continue;
            return true;
        }
        for (Group group : this.groups) {
            for (Permission permission : group.getPermissions()) {
                AccessMode accessMode;
                if (permission == null || !(permission instanceof FolderPermission) || !(accessMode = ((FolderPermission)permission).getMode()).equals((Object)AccessMode.ADMIN) && !accessMode.equals((Object)AccessMode.OWNER)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Permission> getPermissions() {
        return Collections.unmodifiableCollection(this.permissions);
    }

    public FolderPermission getPermissionFor(FolderInfo folderInfo) {
        for (Permission permission : this.permissions) {
            FolderPermission folderPermission;
            if (!(permission instanceof FolderPermission) || !(folderPermission = (FolderPermission)permission).getFolder().equals(folderInfo)) continue;
            return folderPermission;
        }
        return FolderPermission.get(folderInfo, AccessMode.NO_ACCESS);
    }

    public Collection<OrganizationAdminPermission> getOrgAdminPermissions() {
        ArrayList<OrganizationAdminPermission> arrayList = new ArrayList<OrganizationAdminPermission>();
        for (Permission permission : this.permissions) {
            if (!(permission instanceof OrganizationAdminPermission)) continue;
            arrayList.add((OrganizationAdminPermission)permission);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public AccessMode getAllowedAccess(FolderInfo folderInfo) {
        if (this.hasPermission(FolderPermission.owner(folderInfo))) {
            return FolderPermission.owner(folderInfo).getMode();
        }
        if (this.hasPermission(FolderPermission.admin(folderInfo))) {
            return FolderPermission.admin(folderInfo).getMode();
        }
        if (this.hasPermission(FolderPermission.readWrite(folderInfo))) {
            return FolderPermission.readWrite(folderInfo).getMode();
        }
        if (this.hasPermission(FolderPermission.read(folderInfo))) {
            return FolderPermission.read(folderInfo).getMode();
        }
        return AccessMode.NO_ACCESS;
    }

    public boolean isAdminOfOwnOrganization() {
        if (StringUtils.isBlank(this.organizationOID)) {
            return false;
        }
        return this.hasPermission(new OrganizationAdminPermission(this.organizationOID));
    }

    public boolean isAdminOfAnyOrganization() {
        if (this.hasPermission(OrganizationCreatePermission.INSTANCE)) {
            return true;
        }
        for (Permission permission : this.permissions) {
            if (!(permission instanceof OrganizationAdminPermission)) continue;
            return true;
        }
        return false;
    }

    public boolean isInSameOrganization(Account account) {
        return Util.equals(this.organizationOID, account.getOrganizationOID());
    }

    public Collection<FolderInfo> getFoldersCharged() {
        if (this.permissions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FolderInfo> arrayList = new ArrayList<FolderInfo>(this.permissions.size());
        for (Permission serializable : this.permissions) {
            if (!(serializable instanceof FolderOwnerPermission)) continue;
            FolderPermission folderPermission = (FolderPermission)serializable;
            arrayList.add(folderPermission.getFolder());
        }
        for (Group group : this.groups) {
            for (Permission permission : group.getPermissions()) {
                if (!(permission instanceof FolderOwnerPermission)) continue;
                FolderPermission folderPermission = (FolderPermission)permission;
                arrayList.add(folderPermission.getFolder());
            }
        }
        return arrayList;
    }

    public FolderInfo getFolderPersonalFiles() {
        for (FolderInfo folderInfo : this.getFoldersCharged()) {
            if (!folderInfo.getName().equals("$personal_files")) continue;
            return folderInfo;
        }
        return null;
    }

    public Collection<FolderInfo> getFolders() {
        ArrayList<FolderInfo> arrayList = new ArrayList<FolderInfo>(this.permissions.size());
        for (Permission serializable : this.permissions) {
            Object object;
            if (!(serializable instanceof FolderPermission) || ((FolderPermission)(object = (FolderPermission)serializable)).getFolder() == null) continue;
            arrayList.add(((FolderPermission)object).getFolder());
        }
        for (Group group : this.groups) {
            for (Permission permission : group.getPermissions()) {
                FolderPermission folderPermission;
                if (!(permission instanceof FolderPermission) || (folderPermission = (FolderPermission)permission).getFolder() == null || arrayList.contains(folderPermission.getFolder())) continue;
                arrayList.add(folderPermission.getFolder());
            }
        }
        return arrayList;
    }

    public void internFolderInfos() {
        for (Permission permission : this.permissions) {
            if (!(permission instanceof FolderPermission)) continue;
            FolderPermission folderPermission = (FolderPermission)permission;
            folderPermission.folder = folderPermission.folder.intern();
        }
    }

    public void addGroup(Group ... groupArray) {
        Reject.ifNull(groupArray, "Group is null");
        for (Group group : groupArray) {
            if (this.groups.contains(group)) continue;
            this.groups.add(group);
        }
    }

    public void removeGroup(Group ... groupArray) {
        Reject.ifNull(groupArray, "Group is null");
        for (Group group : groupArray) {
            this.groups.remove(group);
        }
    }

    public boolean isValid() {
        return this.username != null;
    }

    public String getOID() {
        return this.oid;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getDisplayName() {
        if (StringUtils.isNotBlank(this.firstname) || StringUtils.isNotBlank(this.surname)) {
            String string = StringUtils.isBlank(this.title) ? "" : this.title.trim() + " ";
            String string2 = (this.firstname == null ? "" : this.firstname).trim();
            String string3 = (this.surname == null ? "" : this.surname).trim();
            if (StringUtils.isBlank(string2)) {
                return string + string3;
            }
            if (StringUtils.isBlank(string3)) {
                return string + string2;
            }
            return (string + string2 + " " + string3).trim();
        }
        if (StringUtils.isNotBlank(this.username) && this.authByShibboleth() && !this.emails.isEmpty()) {
            return this.getEmails().get(0);
        }
        if (!this.emails.isEmpty() && StringUtils.isNotBlank(this.emails.get(0))) {
            return this.getEmails().get(0);
        }
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPasswordPlain(String string, String string2) {
        this.password = string + string2;
    }

    public void setPasswordSalted(String string) {
        this.password = LoginUtil.hashAndSalt(string);
    }

    public boolean passwordMatches(char[] cArray) {
        return LoginUtil.matches(cArray, this.password);
    }

    public String getOTP() {
        return this.otp;
    }

    public String generateAndSetOTP() {
        this.otp = LoginUtil.generateOTP();
        return this.otp;
    }

    public void invalidateOTP() {
        this.otp = null;
    }

    public void setToken(ServerInfo serverInfo, String string) {
        Reject.ifNull(serverInfo, "fedServiceInfo");
        Reject.ifFalse(serverInfo.isFederatedService(), "Setting token only possible for federation services");
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.username + ": setToken for " + serverInfo + " to " + string);
        }
        this.tokens.put(serverInfo, string);
    }

    public void removeToken(ServerInfo serverInfo) {
        Reject.ifNull(serverInfo, "fedServiceInfo");
        Reject.ifFalse(serverInfo.isFederatedService(), "Setting token only possible for federation services");
        this.tokens.remove(serverInfo);
    }

    public String getToken(ServerInfo serverInfo) {
        return this.tokens.get(serverInfo);
    }

    public Map<ServerInfo, String> getTokens() {
        return Collections.unmodifiableMap(this.tokens);
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public String getLdapDN() {
        return this.ldapDN;
    }

    public void setLdapDN(String string) {
        this.ldapDN = string;
    }

    public String getShibbolethPersistentID() {
        return this.shibbolethPersistentID;
    }

    public void setShibbolethPersistentID(String string) {
        this.shibbolethPersistentID = string;
    }

    public Date getRegisterDate() {
        return this.registerDate;
    }

    public void setRegisterDate(Date date) {
        this.registerDate = date;
    }

    public OnlineStorageSubscription getOSSubscription() {
        return this.osSubscription;
    }

    public void setOSSubscription(OnlineStorageSubscription onlineStorageSubscription) {
        this.osSubscription = onlineStorageSubscription;
    }

    public boolean hasOwnStorage() {
        return this.osSubscription.getStorageSize() != 0L;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getOrganizationOID() {
        return this.organizationOID;
    }

    public void setOrganizationOID(String string) {
        this.organizationOID = string;
    }

    public boolean isMemberOfOrganization() {
        return StringUtils.isNotBlank(this.organizationOID);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String string) {
        this.firstname = string;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String string) {
        this.surname = string;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public void setTelephone(String string) {
        this.telephone = string;
    }

    public CustomFields getCustomFields() {
        if (this.customFields == null) {
            this.customFields = new CustomFields();
        }
        return this.customFields;
    }

    public String getCustom1() {
        return this.getCustomFields().getCustom1();
    }

    public void setCustom1(String string) {
        this.getCustomFields().setCustom1(string);
    }

    public String getCustom2() {
        return this.getCustomFields().getCustom2();
    }

    public void setCustom2(String string) {
        this.getCustomFields().setCustom2(string);
    }

    public String getCustom3() {
        return this.getCustomFields().getCustom3();
    }

    public void setCustom3(String string) {
        this.getCustomFields().setCustom3(string);
    }

    public String getJSONData() {
        return this.jsonData;
    }

    public void setJSONData(String string) {
        this.jsonData = string;
    }

    public JSONObject getJSONObject() {
        if (StringUtils.isBlank(this.jsonData)) {
            return new JSONObject();
        }
        try {
            return new JSONObject(this.jsonData);
        }
        catch (JSONException jSONException) {
            LOG.warning("Resetting JSON data for " + this.username + ". Illegal value '" + this.jsonData + "'. " + jSONException.getMessage());
            return new JSONObject();
        }
    }

    public void setJSONObject(JSONObject jSONObject) {
        if (jSONObject == null) {
            this.jsonData = null;
            return;
        }
        this.jsonData = jSONObject.toString();
    }

    public void put(String string, String string2) {
        JSONObject jSONObject = this.getJSONObject();
        try {
            jSONObject.put(string, string2);
        }
        catch (JSONException jSONException) {
            LOG.severe("Unable to set extra information in JSON format to " + this.username + ": " + string + "=" + string2 + ". " + jSONException);
            return;
        }
        this.setJSONObject(jSONObject);
    }

    public void put(String string, long l) {
        JSONObject jSONObject = this.getJSONObject();
        try {
            jSONObject.put(string, l);
        }
        catch (JSONException jSONException) {
            LOG.severe("Unable to set extra information in JSON format to " + this.username + ": " + string + "=" + l + ". " + jSONException);
            return;
        }
        this.setJSONObject(jSONObject);
    }

    public boolean authByShibboleth() {
        return StringUtils.isNotBlank(this.shibbolethPersistentID);
    }

    public boolean authByLDAP() {
        return StringUtils.isNotBlank(this.ldapDN);
    }

    public boolean authByRADIUS() {
        return this.notes != null && this.notes.toLowerCase().contains("radius");
    }

    public boolean authByDatabase() {
        return !this.authByLDAP() && !this.authByRADIUS() && !this.authByShibboleth();
    }

    public String getAuthType() {
        if (this.authByShibboleth()) {
            return "shibboleth";
        }
        if (this.authByLDAP()) {
            return "ldap";
        }
        if (this.authByRADIUS()) {
            return "radius";
        }
        if (this.authByDatabase()) {
            return "database";
        }
        return "unknown";
    }

    public boolean isSendEmail() {
        if (StringUtils.isBlank(this.getCustom2())) {
            return true;
        }
        return !this.getCustom2().toUpperCase().contains("NOEMAIL");
    }

    public void setSendEmail(boolean bl) {
        if (!bl) {
            this.setCustom2("NOEMAIL");
        } else {
            this.setCustom2(null);
        }
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String string) {
        this.notes = StringUtils.cutNotes(string);
    }

    public void addNotesWithDate(String string) {
        if (StringUtils.isBlank(string)) {
            return;
        }
        Object object = Format.formatDateCanonical(new Date());
        object = (String)object + ": ";
        object = (String)object + string;
        Object object2 = StringUtils.isBlank(this.notes) ? object : this.notes + "\n" + (String)object;
        this.setNotes((String)object2);
    }

    public ServerInfo getServer() {
        return this.server;
    }

    public void setServer(ServerInfo serverInfo) {
        this.server = serverInfo;
    }

    public boolean isServerStatic() {
        return this.serverStatic;
    }

    public void setServerStatic(boolean bl) {
        this.serverStatic = bl;
    }

    public FolderInfo getDefaultSynchronizedFolder() {
        return this.defaultSynchronizedFolder;
    }

    public void setDefaultSynchronizedFolder(FolderInfo folderInfo) {
        this.defaultSynchronizedFolder = folderInfo;
    }

    public MemberInfo getLastLoginFrom() {
        return this.lastLoginFrom;
    }

    public boolean setLastLoginFrom(MemberInfo memberInfo) {
        this.lastLoginFrom = memberInfo;
        this.touchLogin();
        this.getDevices();
        if (memberInfo != null && !this.computers.contains(memberInfo)) {
            this.computers.add(memberInfo);
            return true;
        }
        return false;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void touchLogin() {
        this.lastLoginDate = new Date();
    }

    public Collection<MemberInfo> getDevices() {
        return Collections.unmodifiableCollection(this.computers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDevice(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "NodeInfo");
        Collection<MemberInfo> collection = this.computers;
        synchronized (collection) {
            if (!this.computers.contains(memberInfo)) {
                this.computers.add(memberInfo);
            }
        }
    }

    public boolean removeDevice(MemberInfo memberInfo) {
        Reject.ifNull(memberInfo, "NodeInfo");
        return this.computers.remove(memberInfo);
    }

    public Collection<Group> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    public Collection<Group> getLdapGroups() {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (Group group : this.groups) {
            if (!StringUtils.isNotBlank(group.getLdapDN())) continue;
            arrayList.add(group);
        }
        return arrayList;
    }

    public void addLicenseKeyFile(String string) {
        if (this.licenseKeyFileList.contains(string)) {
            return;
        }
        this.licenseKeyFileList.add(string);
    }

    public List<String> getLicenseKeyFiles() {
        return this.licenseKeyFileList;
    }

    public boolean addEmail(String string) {
        Reject.ifBlank(string, "Email");
        string = string.trim().toLowerCase();
        if (this.emails.contains(string)) {
            return false;
        }
        this.emails.add(string);
        return true;
    }

    public boolean addEmailAsFirst(String string) {
        Reject.ifBlank(string, "Email");
        string = string.trim().toLowerCase();
        if (this.emails.contains(string)) {
            return false;
        }
        this.emails.add(0, string);
        return true;
    }

    public boolean addEmail(String string, String string2) {
        Reject.ifBlank(string, "Email");
        Reject.ifBlank(string2, "LDAP");
        string = string.trim().toLowerCase();
        string2 = string2.trim().toLowerCase();
        if (this.emails.contains(string + ":" + string2)) {
            boolean bl = false;
            while (this.emails.contains(string)) {
                this.emails.remove(string);
                bl = true;
            }
            return bl;
        }
        if (this.emails.contains(string)) {
            int n = this.emails.indexOf(string);
            this.emails.remove(n);
            this.emails.add(n, string + ":" + string2);
            return true;
        }
        this.emails.add(string + ":" + string2);
        return true;
    }

    public boolean removeEmail(String string) {
        Reject.ifBlank(string, "Email");
        string = string.toLowerCase().trim();
        for (String string2 : this.emails) {
            if (!string2.startsWith(string)) continue;
            return this.emails.remove(string2);
        }
        return this.emails.remove(string);
    }

    public boolean removeNonExistingLdapEmails(List<String> list, String string) {
        string = string.trim().toLowerCase();
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            String string2 = listIterator.next().trim().toLowerCase();
            listIterator.set((String)string2 + ":" + string);
        }
        boolean bl = false;
        for (String string3 : this.emails) {
            if (string3.indexOf(":") <= 0 || !string3.split(":")[1].equalsIgnoreCase(string) || list.contains(string3)) continue;
            this.emails.remove(string3);
            bl = true;
        }
        return bl;
    }

    public List<String> getEmails() {
        if (this.emails == null || this.emails.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.emails) {
            if (string == null) continue;
            int n = string.indexOf(58);
            if (n > 0) {
                arrayList.add(string.substring(0, n));
                continue;
            }
            arrayList.add(string);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public List<String> getRawEmails() {
        return Collections.unmodifiableList(this.emails);
    }

    public String getEmail() {
        if (Util.isValidEmail(this.username) && !this.authByShibboleth()) {
            return this.username;
        }
        if (!this.emails.isEmpty()) {
            return this.getEmails().get(0);
        }
        return null;
    }

    public void clearEmails() {
        this.emails.clear();
    }

    public int getAutoRenewDevices() {
        return this.autoRenewDevices;
    }

    public Date getAutoRenewTill() {
        return this.autoRenewTill;
    }

    public boolean isProUser() {
        return this.proUser;
    }

    public boolean isLimitedUser() {
        if (!this.authByDatabase()) {
            return false;
        }
        if (this.isFederatedAccount()) {
            return false;
        }
        return this.osSubscription.getStorageSize() <= 0L;
    }

    public void setAutoRenew(int n, Date date, boolean bl) {
        this.autoRenewDevices = n;
        this.autoRenewTill = date;
        this.proUser = bl;
    }

    public boolean willAutoRenew() {
        if (this.autoRenewDevices <= 0) {
            return false;
        }
        if (this.autoRenewTill == null) {
            return true;
        }
        return this.autoRenewTill.after(new Date());
    }

    public Integer getMaxFolders() {
        return this.maxFolders;
    }

    public void setMaxFolders(int n) {
        this.maxFolders = n;
    }

    public boolean isMaxFoldersUnlimited() {
        return this.maxFolders == null || this.maxFolders < 0;
    }

    public void setMaxFoldersUnlimited() {
        this.maxFolders = null;
    }

    public int getAgreedToSVersion() {
        return this.agreedToSVersion;
    }

    public void setAgreedToSVersion(int n) {
        this.agreedToSVersion = n;
    }

    public int getDaysSinceRegistration() {
        if (this.registerDate == null) {
            return -1;
        }
        long l = (System.currentTimeMillis() - this.registerDate.getTime()) / 86400000L;
        return (int)l;
    }

    public String toString() {
        return "Account " + this.username + "/" + this.oid + ", " + this.permissions.size() + " permissions";
    }

    public String toDetailString() {
        return this.toString() + ", pro? " + this.proUser + ", regdate: " + Format.formatDateShort(this.registerDate) + ", licenses: " + (Serializable)(this.licenseKeyFileList != null ? Integer.valueOf(this.licenseKeyFileList.size()) : "n/a") + ", " + this.osSubscription;
    }

    public void mergeAccounts(Account account) {
        boolean bl;
        Reject.ifNull(account, "Account is null");
        Reject.ifTrue(this.equals(account), "Unable to merge account with itself");
        if (Util.isValidEmail(account.getUsername()) && !account.authByShibboleth()) {
            this.addEmail(account.getUsername());
        }
        for (String object : account.emails) {
            this.addEmail(object);
        }
        if (account.getOSSubscription().getStorageSizeGB() > this.osSubscription.getStorageSizeGB()) {
            this.osSubscription = account.osSubscription;
        }
        this.licenseKeyFileList.addAll(account.licenseKeyFileList);
        if (StringUtils.isBlank(this.organizationOID)) {
            this.organizationOID = account.organizationOID;
        }
        if (StringUtils.isBlank(this.ldapDN)) {
            this.ldapDN = account.ldapDN;
        }
        if (StringUtils.isBlank(this.basePath)) {
            this.basePath = account.basePath;
        }
        if (StringUtils.isBlank(this.shibbolethPersistentID)) {
            this.shibbolethPersistentID = account.shibbolethPersistentID;
        }
        this.grant(account.permissions.toArray(new Permission[0]));
        for (Group group : account.groups) {
            if (this.groups.contains(group)) continue;
            this.groups.add(group);
        }
        for (MemberInfo memberInfo : account.computers) {
            if (this.computers.contains(memberInfo)) continue;
            this.computers.add(memberInfo);
        }
        boolean bl2 = bl = StringUtils.isNotBlank(account.notes) && StringUtils.isNotBlank(this.notes) && this.notes.contains("Merged with account '" + account.getUsername() + "'");
        if (!bl) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.notes != null) {
                stringBuilder.append(this.notes);
                stringBuilder.append("\n");
            }
            if (StringUtils.isNotBlank(account.notes)) {
                stringBuilder.append("Begin of notes of ");
                stringBuilder.append(account.getUsername());
                stringBuilder.append("\n");
                stringBuilder.append(account.notes);
                stringBuilder.append("\nEND of notes of ");
                stringBuilder.append(account.getUsername());
            }
            this.notes = stringBuilder.toString();
            this.addNotesWithDate("Merged with account " + account.getUsername());
            int n = stringBuilder.length();
            if (n >= 1000) {
                int n2 = n - 1000;
                stringBuilder.replace(0, n2, "");
                this.notes = stringBuilder.toString().trim();
            }
        }
        if (account.lastLoginDate != null && (this.lastLoginDate == null || this.lastLoginDate.before(account.lastLoginDate))) {
            this.lastLoginDate = account.lastLoginDate;
        }
        if (account.agreedToSVersion > this.agreedToSVersion) {
            this.agreedToSVersion = account.agreedToSVersion;
        }
    }

    public void enable(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        this.getOSSubscription().setWarnedUsageDate(null);
        this.getOSSubscription().setDisabledUsageDate(null);
        this.getOSSubscription().setWarnedExpirationDate(null);
        this.getOSSubscription().setDisabledExpirationDate(null);
        this.enableSync(controller);
    }

    public int enableSync(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        int n = 0;
        for (FolderInfo folderInfo : this.getFoldersCharged()) {
            Folder folder = folderInfo.getFolder(controller);
            if (folder == null || !folder.getSyncProfile().equals(SyncProfile.DISABLED)) continue;
            ++n;
            SyncProfile syncProfile = SyncProfile.getDefault(controller);
            folder.setSyncProfile(syncProfile);
        }
        return n;
    }

    public int disableSync(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        int n = 0;
        for (FolderInfo folderInfo : this.getFoldersCharged()) {
            Folder folder = folderInfo.getFolder(controller);
            if (folder == null) continue;
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("Disable download of new files for folder: " + folder + " for " + this.getUsername());
            }
            if (folder.getSyncProfile().equals(SyncProfile.DISABLED)) continue;
            folder.setSyncProfile(SyncProfile.DISABLED);
            ++n;
        }
        if (n > 0) {
            LOG.info("Disabled " + n + " folder for " + this.getUsername());
        }
        return n;
    }

    public boolean hasReadPermissions(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder info is null");
        return this.hasPermission(FolderPermission.read(folderInfo));
    }

    public boolean hasReadWritePermissions(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder info is null");
        return this.hasPermission(FolderPermission.readWrite(folderInfo));
    }

    public boolean hasWritePermissions(FolderInfo folderInfo) {
        return this.hasReadWritePermissions(folderInfo);
    }

    public boolean hasAdminPermission(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder info is null");
        return this.hasPermission(FolderPermission.admin(folderInfo));
    }

    public boolean hasTwoFactorAuthenticationToken() {
        return StringUtils.isNotBlank(this.twoFactorAuthenticationToken);
    }

    public String getTwoFactorAuthenticationToken() {
        return this.twoFactorAuthenticationToken;
    }

    public void setTwoFactorAuthenticationToken(String string) {
        this.twoFactorAuthenticationToken = string;
    }

    public void setEncodedRecoveryPhrase(String string) {
        this.encodedRecoveryPhrase = string;
    }

    public String getEncodedRecoveryPhrase() {
        return this.encodedRecoveryPhrase;
    }

    public boolean recoveryPhraseMatches(char[] cArray) {
        return LoginUtil.matches(cArray, this.encodedRecoveryPhrase);
    }

    public boolean hasOwnerPermission(FolderInfo folderInfo) {
        Reject.ifNull(folderInfo, "Folder info is null");
        return this.hasPermission(FolderPermission.owner(folderInfo));
    }

    public boolean isFederatedAccount() {
        return this.getServer() != null && this.getServer().isFederatedService();
    }

    public boolean isClusterAccount() {
        return this.getServer().isClusterServer();
    }

    public Date getActivationDate() {
        return this.activated;
    }

    public void setActivationDate(Date date) {
        this.activated = date;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Account)) {
            return false;
        }
        Account account = (Account)object;
        return this.oid.equals(account.oid);
    }

    public int hashCode() {
        return this.oid.hashCode();
    }

    public synchronized void convertCollections() {
        if (!(this.permissions instanceof CopyOnWriteArrayList)) {
            this.permissions = new CopyOnWriteArrayList<Permission>(this.permissions);
        }
        if (!(this.groups instanceof CopyOnWriteArrayList)) {
            this.groups = new CopyOnWriteArrayList<Group>(this.groups);
            for (Group group : this.groups) {
                group.convertCollections();
            }
        }
        if (!(this.computers instanceof CopyOnWriteArrayList)) {
            this.computers = new CopyOnWriteArrayList<MemberInfo>(this.computers);
        }
        if (!(this.licenseKeyFileList instanceof CopyOnWriteArrayList)) {
            this.licenseKeyFileList = new CopyOnWriteArrayList<String>(this.licenseKeyFileList);
        }
        if (!(this.licenseKeyFiles instanceof CopyOnWriteArrayList)) {
            this.licenseKeyFiles = new CopyOnWriteArrayList<String>(this.licenseKeyFiles);
        }
        if (!(this.emails instanceof CopyOnWriteArrayList)) {
            this.emails = new CopyOnWriteArrayList<String>(this.emails);
        }
        if (!(this.tokens instanceof ConcurrentHashMap)) {
            this.tokens = new ConcurrentHashMap<ServerInfo, String>(this.tokens);
        }
    }

    public void migrate() {
        if (this.permissions == null) {
            this.permissions = new CopyOnWriteArrayList<Permission>();
        }
        if (this.groups == null) {
            this.groups = new CopyOnWriteArrayList<Group>();
        }
        if (this.computers == null) {
            this.computers = new CopyOnWriteArrayList<MemberInfo>();
        }
        if (this.licenseKeyFileList == null) {
            this.licenseKeyFileList = new CopyOnWriteArrayList<String>();
        }
        if (this.licenseKeyFiles == null) {
            this.licenseKeyFiles = new CopyOnWriteArrayList<String>();
        }
        if (this.emails == null) {
            this.emails = new CopyOnWriteArrayList<String>();
        }
        if (this.tokens == null) {
            this.tokens = new ConcurrentHashMap<ServerInfo, String>();
        }
        if (this.server != null) {
            this.server.migrateId();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.licenseKeyFiles = new CopyOnWriteArrayList<String>(this.licenseKeyFileList);
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.oid == null) {
            this.oid = IdGenerator.makeId();
        }
        if (this.groups == null) {
            this.groups = new CopyOnWriteArrayList<Group>();
        }
        if (this.emails == null) {
            this.emails = new CopyOnWriteArrayList<String>();
        }
        if (this.tokens == null) {
            this.tokens = new ConcurrentHashMap<ServerInfo, String>();
        }
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AccountInfoProto.AccountInfo) {
            AccountInfoProto.AccountInfo accountInfo = (AccountInfoProto.AccountInfo)abstractMessage;
            this.oid = accountInfo.getId();
            this.agreedToSVersion = (int)accountInfo.getTosVersion();
            this.username = accountInfo.getUsername();
            this.firstname = accountInfo.getFirstname();
            this.surname = accountInfo.getSurname();
            this.telephone = accountInfo.getTelephone();
            this.emails = new CopyOnWriteArrayList<String>();
            this.emails.addAll(accountInfo.getEmailsList());
            this.organizationOID = accountInfo.getOrganizationId();
            this.permissions = new CopyOnWriteArrayList<Permission>();
            for (PermissionInfoProto.PermissionInfo permissionInfo : accountInfo.getPermissionInfosList()) {
                switch (permissionInfo.getPermissionType()) {
                    case ADMIN: {
                        this.permissions.add(new AdminPermission(permissionInfo));
                        break;
                    }
                    case CHANGE_PREFERENCES: {
                        this.permissions.add(new ChangePreferencesPermission(permissionInfo));
                        break;
                    }
                    case CHANGE_TRANSFER_MODE: {
                        this.permissions.add(new ChangeTransferModePermission(permissionInfo));
                        break;
                    }
                    case COMPUTERS_APP: {
                        this.permissions.add(new ComputersAppPermission(permissionInfo));
                        break;
                    }
                    case CONFIG_APP: {
                        this.permissions.add(new ConfigAppPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_ADMIN: {
                        this.permissions.add(new FolderAdminPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_CREATE: {
                        this.permissions.add(new FolderCreatePermission(permissionInfo));
                        break;
                    }
                    case FOLDER_OWNER: {
                        this.permissions.add(new FolderOwnerPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_READ: {
                        this.permissions.add(new FolderReadPermission(permissionInfo));
                        break;
                    }
                    case FOLDER_READ_WRITE: {
                        this.permissions.add(new FolderReadWritePermission(permissionInfo));
                        break;
                    }
                    case FOLDER_REMOVE: {
                        this.permissions.add(new FolderRemovePermission(permissionInfo));
                        break;
                    }
                    case GROUP_ADMIN: {
                        this.permissions.add(new GroupAdminPermission(permissionInfo));
                        break;
                    }
                    case ORGANIZATION_ADMIN: {
                        this.permissions.add(new OrganizationAdminPermission(permissionInfo));
                        break;
                    }
                    case ORGANIZATION_CREATE: {
                        this.permissions.add(new OrganizationCreatePermission(permissionInfo));
                        break;
                    }
                    case SYSTEM_SETTINGS: {
                        this.permissions.add(new SystemSettingsPermission(permissionInfo));
                        break;
                    }
                    case UNRECOGNIZED: {
                        break;
                    }
                }
            }
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AccountInfoProto.AccountInfo.Builder builder = AccountInfoProto.AccountInfo.newBuilder();
        builder.setClazzName("AccountInfo");
        if (this.oid != null) {
            builder.setId(this.oid);
        }
        builder.setTosVersion(this.agreedToSVersion);
        if (this.username != null) {
            builder.setUsername(this.username);
        }
        builder.setDisplayName(this.getDisplayName());
        if (this.firstname != null) {
            builder.setFirstname(this.firstname);
        }
        if (this.surname != null) {
            builder.setSurname(this.surname);
        }
        if (this.telephone != null) {
            builder.setTelephone(this.telephone);
        }
        for (String object : this.getEmails()) {
            builder.addEmails(object);
        }
        if (this.organizationOID != null) {
            builder.setOrganizationId(this.organizationOID);
        }
        for (Group group : this.groups) {
            builder.addGroupInfos((GroupInfoProto.GroupInfo)group.toD2D());
        }
        for (Permission permission : this.permissions) {
            if (permission instanceof FolderPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((FolderPermission)permission).toD2D());
                continue;
            }
            if (permission instanceof GroupAdminPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((GroupAdminPermission)permission).toD2D());
                continue;
            }
            if (permission instanceof OrganizationAdminPermission) {
                builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((OrganizationAdminPermission)permission).toD2D());
                continue;
            }
            if (!(permission instanceof SingletonPermission)) continue;
            builder.addPermissionInfos((PermissionInfoProto.PermissionInfo)((SingletonPermission)permission).toD2D());
        }
        return builder.build();
    }

    public String getETHAddress() {
        try {
            if (!this.getJSONObject().has("ethAddress")) {
                return null;
            }
            return this.getJSONObject().getString("ethAddress");
        }
        catch (JSONException jSONException) {
            LOG.warning(jSONException.toString());
            return null;
        }
    }

    public void setETHAddress(String string) {
        JSONObject jSONObject = this.getJSONObject();
        if (StringUtils.isNotBlank(string)) {
            try {
                jSONObject.put("ethAddress", string);
            }
            catch (JSONException jSONException) {
                LOG.warning(jSONException.toString());
            }
        } else {
            jSONObject.remove("ethAddress");
        }
        this.setJSONObject(jSONObject);
    }

    @Override
    public void setCreatedNowBy(Account account) {
        this.auditFields().setCreatedNowBy(account);
    }

    @Override
    public void setModifiedNowBy(Account account) {
        this.auditFields().setModifiedNowBy(account);
    }

    private AuditFields auditFields() {
        if (this.auditFields == null) {
            this.auditFields = new AuditFields();
        }
        return this.auditFields;
    }
}

