/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.security;

import de.dal33t.powerfolder.disk.FolderSettings;
import de.dal33t.powerfolder.protocol.PermissionTypeProto;
import de.dal33t.powerfolder.util.StringUtils;
import java.util.logging.Logger;
import org.jetbrains.annotations.Nullable;

public enum AccessMode {
    NO_ACCESS("permissions.no_access"),
    READ("permissions.read"),
    READ_WRITE("permissions.read_write"),
    ADMIN("permissions.admin"),
    OWNER("permissions.owner");

    final String translationKey;

    private AccessMode(String string2) {
        this.translationKey = string2;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public static AccessMode fromString(String string, String string2) {
        AccessMode accessMode = AccessMode.valueOf(string2);
        String string3 = string;
        try {
            accessMode = StringUtils.isBlank(string3) ? NO_ACCESS : AccessMode.valueOf(string3.toUpperCase().trim());
        }
        catch (Exception exception) {
            Logger.getLogger(FolderSettings.class.getName()).severe("Malformed value for folder permission: " + string + ". Using fallback: " + accessMode + ". " + exception);
        }
        return accessMode;
    }

    @Nullable
    public PermissionTypeProto.PermissionType toD2D() {
        switch (this) {
            case READ: {
                return PermissionTypeProto.PermissionType.FOLDER_READ;
            }
            case READ_WRITE: {
                return PermissionTypeProto.PermissionType.FOLDER_READ_WRITE;
            }
            case ADMIN: {
                return PermissionTypeProto.PermissionType.FOLDER_ADMIN;
            }
            case OWNER: {
                return PermissionTypeProto.PermissionType.FOLDER_OWNER;
            }
        }
        return null;
    }

    @Nullable
    public static AccessMode getEnum(PermissionTypeProto.PermissionType permissionType) {
        switch (permissionType) {
            case FOLDER_OWNER: {
                return OWNER;
            }
            case FOLDER_ADMIN: {
                return ADMIN;
            }
            case FOLDER_READ_WRITE: {
                return READ_WRITE;
            }
            case FOLDER_READ: {
                return READ;
            }
        }
        return null;
    }
}

