/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.loader;

import com.jgoodies.binding.beans.Model;
import de.dal33t.powerfolder.pro.loader.C;
import de.dal33t.powerfolder.util.Format;
import de.dal33t.powerfolder.util.PathUtils;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LicenseKey
extends Model {
    private static final long serialVersionUID = 100L;
    public static final int CHECK_PART_LENGHT = 24;
    public static final String NODE_ID_TAG = "N$ID-";
    public static final String LICENSE_KEY_PREFIX = "License Key";
    public static final String NUMBER_OF_COMPUTERS_PREFIX = "Number of Computers";
    public static final String NUMBER_OF_USERS_PREFIX = "Number of Users";
    public static final String NUMBER_OF_SUB_DEVICES_PREFIX = "Number of Sub-Devices";
    public static final String EMAIL_PREFIX = "Email";
    public static final String ORDER_NUMBER_PREFIX = "Order Number";
    public static final String VALID_FROM_PREFIX = "Valid from";
    public static final String VALID_TO_PREFIX = "Valid to";
    public static final String TYPE_PREFIX = "Installation Type";
    public static final String GB_SPACE_PREFIX = "Allowed GB";
    public static final String UPDATE_SERVICE_USERNAME_PREFIX = "UpdateService username";
    public static final String UPDATE_SERVICE_PASSWORD_PREFIX = "UpdateService password";
    public static final String PLUGINS_PREFIX = "Plugins";
    public static final String LICENSE_INFO_START = "#LICENSE INFORMATION START------";
    public static final String LICENSE_INFO_END = "#LICENSE INFORMATION END--------";
    public static final String PROPERTYNAME_EMAIL = "email";
    public static final String PROPERTYNAME_N_COMPUTERS = "ncomputers";
    private static final String PROPERTYNAME_N_DEVICES = "nDevices";
    private static final String PROPERTYNAME_N_USERS = "nUsers";
    public static final String PROPERTYNAME_TYPE = "type";
    public static final String PROPERTYNAME_GB_SPACE = "gbSpace";
    public static final String PROPERTYNAME_ORDER_NUMBER = "orderNumber";
    public static final String PROPERTYNAME_VALID = "valid";
    public static final String PROPERTYNAME_LICENSE_KEY = "licenseKey";
    public static final String PROPERTYNAME_LICENSE_KEY_CONTENTS = "licenseKeyContents";
    public static final String PROPERTYNAME_UPDATE_SERVICE_USERNAME = "updateServiceUsername";
    public static final String PROPERTYNAME_UPDATE_SERVICE_PASSWORD = "updateServicePassword";
    public static final String PROPERTY_VALID_FROM = "validFrom";
    public static final String PROPERTY_VALID_TO = "validTo";
    private static final String PROPERTYNAME_EXPIRED = "expired";
    public static final String TRIAL_LICENSE_KEY_PREFIX = "TRIAL";
    public static final int TRIAL_LICENSE_MB = 5120;
    public static final int TRIAL_LICENSE_COMPUTER = 999;
    public static final int TRIAL_LICENSE_DAYS_VALID = 372;
    private static final String[] DISABLED_ORDERS_KEYS = new String[]{"O-1022", "O-1036", "O-1039", "O-1065", "O-1066", "O-1067", "O-1068", "O-1069", "O-1087", "O-1106", "O-1110", "O-1113", "O-1116", "O-1127", "O-1131", "O-1155", "O-1157", "O-1172", "O-1202", "O-1202", "O-PP-2008-02-24-80F06479YB318551D", "O-PP-2008-03-20-7P33939530418501N", "O-PP-2008-04-06-67220811M2977664L", "O-PP-2008-03-20-7P33939530418501N", "O-PP-2008-04-20-5R065484GX361615C", "O-PP-2008-04-24-3A825897VK7781928", "O-PP-2008-05-07-26U67983NL553010N", "O-PP-2008-05-14-1NS27546C67975250", "O-PP-2008-05-18-2WB94745NY026282X", "O-PP-2008-06-07-6DK74665XG448152L", "O-PP-2008-06-22-7PK94151VW659300U", "O-PP-2008-06-25-1736785636515015X", "O-PP-2008-06-25-6V656348Y95746125", "O-PP-2008-07-01-96F32964JU833241G", "O-PP-2008-07-10-3A795151DH6098812", "O-ISC-2010-05-30-ID929-1", "2013-GWDG-07", "2013-GWDG-06", "O-ISC-2013-05-03-ID4679"};
    private String orderNumber;
    private int nComputers;
    private int gbSpace;
    private int nSubDevices;
    private int nUsers;
    private _A type;
    private String email;
    private Date validFrom;
    private Date validTo;
    private String updateServiceUsername;
    private String updateServicePassword;
    private boolean expired;
    private String licenseKeyContents;
    private String licenseKey;
    private boolean valid;

    public static boolean B(String string) {
        for (String string2 : DISABLED_ORDERS_KEYS) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public String H() {
        return this.updateServicePassword;
    }

    public void H(String string) {
        String string2 = this.H();
        this.updateServicePassword = string;
        this.firePropertyChange(PROPERTYNAME_UPDATE_SERVICE_PASSWORD, string2, this.updateServicePassword);
    }

    public String B() {
        return this.updateServiceUsername;
    }

    public void F(String string) {
        String string2 = this.B();
        this.updateServiceUsername = string;
        this.firePropertyChange(PROPERTYNAME_UPDATE_SERVICE_USERNAME, string2, this.updateServiceUsername);
    }

    public String R() {
        return this.email;
    }

    public void I(String string) {
        String string2 = this.R();
        this.email = string;
        if (this.email != null) {
            this.email = this.email.trim();
        }
        this.firePropertyChange(PROPERTYNAME_EMAIL, string2, this.email);
    }

    public int I() {
        return this.nComputers;
    }

    public void C(int n) {
        Integer n2 = this.I();
        this.nComputers = n;
        this.firePropertyChange(PROPERTYNAME_N_COMPUTERS, n2, (Object)this.nComputers);
    }

    public int S() {
        return this.nSubDevices;
    }

    public void D(int n) {
        Integer n2 = this.S();
        this.nSubDevices = n;
        this.firePropertyChange(PROPERTYNAME_N_DEVICES, n2, (Object)n);
    }

    public int P() {
        return this.nUsers;
    }

    public boolean L() {
        return this.nUsers > 0;
    }

    public void A(int n) {
        Integer n2 = this.P();
        this.nUsers = n;
        this.firePropertyChange(PROPERTYNAME_N_USERS, n2, (Object)n);
    }

    public int D() {
        return this.gbSpace;
    }

    public void B(int n) {
        Reject.ifTrue(String.valueOf(n).length() > 20, "Size must not be longer than 20 chars. Got " + n);
        Integer n2 = this.D();
        this.gbSpace = n;
        this.firePropertyChange(PROPERTYNAME_GB_SPACE, n2, (Object)this.gbSpace);
    }

    public _A G() {
        return this.type;
    }

    public void A(_A _A2) {
        Reject.ifTrue(_A2 != null && _A2.name().length() > 10, "Type must not be longer than 10 chars. Got " + _A2);
        _A _A3 = this.G();
        this.type = _A2;
        this.firePropertyChange(PROPERTYNAME_TYPE, (Object)_A3, (Object)this.type);
    }

    public String O() {
        return this.orderNumber;
    }

    public void D(String string) {
        Reject.ifTrue(string != null && string.length() >= 50, "Order number must not be longer than 50 chars. Got " + string);
        String string2 = this.O();
        this.orderNumber = string;
        this.firePropertyChange(PROPERTYNAME_ORDER_NUMBER, string2, this.orderNumber);
    }

    public boolean Q() {
        return this.valid;
    }

    public void A(boolean bl) {
        Boolean bl2 = this.Q();
        this.valid = bl;
        this.firePropertyChange(PROPERTYNAME_VALID, bl2, (Object)this.valid);
    }

    public String F() {
        return this.licenseKey;
    }

    public void A(String string) {
        String string2 = this.F();
        this.licenseKey = string;
        this.firePropertyChange(PROPERTYNAME_LICENSE_KEY, string2, this.licenseKey);
    }

    public String C() {
        return this.licenseKeyContents;
    }

    public void E(String string) {
        String string2 = this.C();
        this.licenseKeyContents = string;
        this.firePropertyChange(PROPERTYNAME_LICENSE_KEY_CONTENTS, string2, this.licenseKey);
    }

    public boolean K() {
        return this.expired;
    }

    public void C(boolean bl) {
        boolean bl2 = this.K();
        this.expired = bl;
        this.firePropertyChange(PROPERTYNAME_EXPIRED, (Object)bl2, this.licenseKey);
    }

    public Date U() {
        return this.validFrom;
    }

    public void B(Date date) {
        Date date2 = this.U();
        this.validFrom = date;
        this.firePropertyChange(PROPERTY_VALID_FROM, date2, this.validFrom);
    }

    public Date T() {
        return this.validTo;
    }

    public void A(Date date) {
        Date date2 = this.T();
        this.validTo = date;
        this.firePropertyChange(PROPERTY_VALID_TO, date2, this.validTo);
    }

    public boolean E() {
        if (StringUtils.isEmpty(this.F())) {
            return false;
        }
        C.H().A(this, this.F(), this.R());
        return this.Q();
    }

    public boolean M() {
        if (StringUtils.isBlank(this.O())) {
            return false;
        }
        return this.O().startsWith(TRIAL_LICENSE_KEY_PREFIX);
    }

    public void B(boolean bl) {
        if (bl && !this.orderNumber.startsWith(TRIAL_LICENSE_KEY_PREFIX)) {
            this.D("TRIAL-" + this.orderNumber);
        } else if (!bl && this.orderNumber.startsWith(TRIAL_LICENSE_KEY_PREFIX)) {
            this.D(this.orderNumber.substring(TRIAL_LICENSE_KEY_PREFIX.length()));
        }
    }

    public int A() {
        if (this.validTo == null) {
            return -1;
        }
        long l = this.validTo.getTime() - System.currentTimeMillis();
        if (l > 0L) {
            return (int)((double)l / 8.64E7);
        }
        return 0;
    }

    public boolean C(String string) {
        Reject.ifBlank(string, "NodeID");
        if (this.orderNumber == null) {
            return false;
        }
        int n = this.orderNumber.indexOf(NODE_ID_TAG);
        if (n < 0) {
            return !this.type.B();
        }
        String string2 = this.orderNumber.substring(n + NODE_ID_TAG.length(), this.orderNumber.length());
        return string2.equals(PathUtils.removeInvalidFilenameChars(string).replace("+", ""));
    }

    public boolean G(String string) {
        Reject.ifBlank(string, "NodeID");
        if (this.orderNumber == null) {
            return false;
        }
        int n = this.orderNumber.indexOf(NODE_ID_TAG);
        if (n < 0) {
            return false;
        }
        String string2 = this.orderNumber.substring(n + NODE_ID_TAG.length(), this.orderNumber.length());
        return string2.equals(PathUtils.removeInvalidFilenameChars(string).replace("+", ""));
    }

    public boolean J() {
        return this.orderNumber != null && this.orderNumber.contains(NODE_ID_TAG);
    }

    protected DateFormat N() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.email == null ? 0 : this.email.hashCode());
        n = 31 * n + (this.licenseKey == null ? 0 : this.licenseKey.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LicenseKey licenseKey = (LicenseKey)object;
        if (this.email == null ? licenseKey.email != null : !this.email.equals(licenseKey.email)) {
            return false;
        }
        return !(this.licenseKey == null ? licenseKey.licenseKey != null : !this.licenseKey.equals(licenseKey.licenseKey));
    }

    public String toString() {
        Object object = "";
        if (!this.Q()) {
            object = (String)object + "INVALID: ";
        }
        if (this.nComputers == 0 && this.T() == null) {
            object = (String)object + "DISABLED";
            return object;
        }
        object = (String)object + this.I();
        object = this.type != null && this.type.B() ? (String)object + " server" : (String)object + " device";
        if (this.I() != 1) {
            object = (String)object + "s";
        }
        if (this.J()) {
            object = (String)object + "*";
        }
        if (this.L()) {
            object = (String)object + " / ";
            object = (String)object + this.nUsers + " Users";
        }
        object = (String)object + " ";
        if (this.M()) {
            object = (String)object + "TRIAL ";
        }
        if (this.D() > 0) {
            object = (String)object + "/ ";
            object = (String)object + this.D();
            object = (String)object + " GB ";
        }
        object = this.T() == null ? (String)object + "valid perpetual" : (String)object + "valid to " + Format.formatDateCanonical(this.T());
        if (this.type != null && this.type != _A.F && !this.type.B()) {
            object = (String)object + this.G().name();
            object = (String)object + " / ";
        }
        return object;
    }

    public static final class _A
    extends Enum<_A> {
        public static final /* enum */ _A F = new _A(false);
        public static final /* enum */ _A C = new _A(false);
        public static final /* enum */ _A G = new _A(true);
        public static final /* enum */ _A B = new _A(true);
        public static final /* enum */ _A D = new _A(true);
        private boolean A;
        private static final /* synthetic */ _A[] E;

        public static _A[] values() {
            return (_A[])E.clone();
        }

        public static _A valueOf(String string) {
            return Enum.valueOf(_A.class, string);
        }

        private _A(boolean bl) {
            this.A = bl;
        }

        public boolean B() {
            return this.A;
        }

        private static /* synthetic */ _A[] A() {
            return new _A[]{F, C, G, B, D};
        }

        static {
            E = _A.A();
        }
    }
}

