/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.A;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.pro.E.F;
import de.dal33t.powerfolder.pro.F.G;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.Waiter;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class B
extends PFComponent
implements de.dal33t.powerfolder.pro.E.B {
    private final boolean \u00e8;
    private final Queue<Message> \u00ee;
    private boolean \u00ed;
    private String \u00ec;
    private ByteSerializer \u00f5;
    private final MemberInfo \u00e7;
    private final URI \u00e6;
    private final WebSocketClient \u00eb;
    private Session \u00f3;
    private Member \u00ef;
    private Identity \u00f4;
    private Identity \u00f2;
    private IdentityReply \u00ea;
    private final Object \u00f1 = new Object();
    private final Object \u00e9 = new Object();
    private final F \u00f0;
    private Date \u00f6;

    public B(Controller controller, de.dal33t.powerfolder.pro.F.B b, MemberInfo memberInfo, URI uRI) {
        super(controller);
        Reject.ifNull(memberInfo, "nodeInfo");
        Reject.ifNull(uRI, "clientWebSocketURI is null");
        if (Feature.CORRECT_LAN_DETECTION.isDisabled()) {
            this.logWarning("ON LAN because of correct connection analyse disabled");
            this.\u00e8 = true;
        } else {
            this.\u00e8 = false;
        }
        this.\u00e7 = memberInfo;
        this.\u00e6 = uRI;
        this.\u00ee = new ConcurrentLinkedQueue<Message>();
        this.\u00f5 = new ByteSerializer();
        this.\u00f0 = new F(b, this, this.\u00f5);
        this.\u00eb = new WebSocketClient();
    }

    @Override
    public Date getLastKeepaliveMessageTime() {
        return this.\u00f6;
    }

    @Override
    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.GOOD;
    }

    @Override
    public void init() throws ConnectionException {
        this.\u00ed = false;
        try {
            int n = 2 * ConfigurationEntry.TRANSFERS_MAX_FILE_CHUNK_SIZE.getValueInt(this.getController());
            this.\u00eb.getPolicy().setMaxBinaryMessageSize(n);
            this.\u00eb.getPolicy().setIdleTimeout(120000L);
            this.\u00eb.setMaxIdleTimeout(120000L);
            this.\u00eb.getPolicy().setAsyncWriteTimeout(120000L);
            this.\u00eb.setAsyncWriteTimeout(120000L);
            this.\u00eb.start();
            _B _B2 = new _B();
            this.\u00eb.connect(_B2, this.\u00e6);
            Waiter waiter = new Waiter(30000L);
            while (!waiter.isTimeout() && this.\u00f3 == null) {
                waiter.waitABit();
            }
            if (waiter.isTimeout()) {
                throw new ConnectionException("Timeout while connecting to " + this.\u00e6);
            }
            if (_B2.getSession() == null || !_B2.getSession().isOpen()) {
                throw new ConnectionException("Unable to connect to " + this.\u00e6);
            }
            if (this.isFine()) {
                this.logFine("Got session: " + this.\u00f3);
            }
        }
        catch (Exception exception) {
            throw new ConnectionException("Unable to open connection to websocket endpoint " + this.\u00e6 + ". " + exception);
        }
        this.getController().getIOProvider().startIO(new _A());
        this.\u00ec = IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId();
        this.\u00f4 = new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), true, true, this);
        if (this.isFiner()) {
            this.logFiner("Sending my identity, nick: '" + this.\u00f4.getMemberInfo().nick + "', ID: " + this.\u00f4.getMemberInfo().id);
        }
        this.sendMessagesAsynchron(this.\u00f4);
        if (!this.isConnected()) {
            this.shutdown();
            throw new ConnectionException("Remote peer disconnected while waiting for his identity").with(this);
        }
        this.\u00f0.\u00db();
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    public void shutdown() {
        if (this.\u00ed) {
            return;
        }
        this.\u00ed = true;
        this.\u00ee.clear();
        this.\u00f0.\u00da();
        try {
            this.\u00eb.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getController().getIOProvider().removeKeepAliveCheck(this);
        if (this.\u00ef != null) {
            this.\u00ef.shutdown();
        }
        this.\u00f5 = null;
    }

    @Override
    public void shutdownWithMember() {
        if (this.getMember() != null) {
            this.getMember().shutdown();
        }
        if (!this.\u00ed) {
            this.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(Message message) {
        this.\u00ee.offer(message);
        Object object = this.\u00ee;
        synchronized (object) {
            this.\u00ee.notifyAll();
        }
        if (this.\u00ee.size() > 2000) {
            object = "Disconnecting " + this.getIdentity() + ": Too many messages in send queue: " + this.\u00ee.size();
            this.logWarning((String)object);
            Runnable runnable = this::shutdownWithMember;
            this.getController().getIOProvider().startIO(runnable);
        }
    }

    @Override
    public void sendMessagesAsynchron(Message ... messageArray) {
        for (Message message : messageArray) {
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForEmptySendQueue() {
        long l = 0L;
        int n = this.\u00ee.size();
        while (!this.\u00ee.isEmpty() && this.isConnected()) {
            try {
                Queue<Message> queue = this.\u00ee;
                synchronized (queue) {
                    this.\u00ee.wait(1L);
                }
                ++l;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (l > 0L && this.isFiner()) {
            this.logFiner(this.getMember() + ": Waited " + l + "ms for empty send buffer. " + n + " messages were in queue.");
        }
        return this.\u00ee.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIdentity(Member member) {
        if (!this.\u00f0.\u00d8()) {
            return false;
        }
        Reject.ifNull(member, "Node is null");
        this.\u00ef = member;
        this.logFine("Sending accept of identity to " + this);
        this.sendMessagesAsynchron(IdentityReply.accept());
        Object object = this.\u00e9;
        synchronized (object) {
            if (this.\u00ea == null) {
                try {
                    this.\u00e9.wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
        if (!this.isConnected()) {
            this.logWarning("Remote member disconnected while waiting for handshake. " + this.\u00f2);
            return false;
        }
        if (this.\u00ea == null) {
            this.logWarning("Remote peer timed out, while waiting for accept");
            return false;
        }
        if (this.\u00ea.accepted) {
            this.logFine("Identity accepted by remote peer. " + this);
        } else {
            this.\u00ef = null;
            this.logWarning("Identity rejected by remote peer. " + this);
        }
        return this.\u00ea.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void B(Object object) {
        if (object instanceof Identity) {
            Object object2 = this.\u00f1;
            synchronized (object2) {
                this.\u00f2 = (Identity)object;
                this.\u00f1.notifyAll();
            }
            if (this.isFiner()) {
                this.logFiner("Received remote identity: " + object + ". Magic ID: " + this.\u00f2.getMagicId());
            }
        } else {
            if (object instanceof IdentityReply) {
                if (this.isFiner()) {
                    this.logFiner("Received identity reply: " + object);
                }
                Object object3 = this.\u00e9;
                synchronized (object3) {
                    this.\u00ea = (IdentityReply)object;
                    this.\u00e9.notifyAll();
                }
            }
            if (!(object instanceof Pong)) {
                if (object instanceof Problem) {
                    Problem problem = (Problem)object;
                    if (this.\u00ef != null) {
                        this.\u00ef.handleMessage(problem, this);
                    } else {
                        this.logFine("(" + (this.\u00f2 != null ? this.\u00f2.getMemberInfo().nick : "-") + ") Problem received: " + problem.message);
                        if (problem.fatal) {
                            this.shutdown();
                        }
                    }
                } else if (object instanceof Message) {
                    boolean bl = false;
                    try {
                        bl = this.\u00f0.B((Message)object);
                    }
                    catch (G g) {
                        this.logSevere("Problem initalizing encryption, connection closed", g);
                        this.shutdown();
                    }
                    if (!bl) {
                        if (this.\u00ef != null) {
                            this.\u00ef.handleMessage((Message)object, this);
                        } else if (!this.isConnected()) {
                            this.shutdown();
                        } else {
                            if (this.\u00f6 == null) {
                                this.logWarning("Connection closed, message received, before peer identified itself: " + object);
                            }
                            this.shutdown();
                        }
                    }
                } else {
                    this.logWarning("Received unknown message from peer: " + object);
                }
            }
        }
    }

    private void A(Message message) throws ConnectionException {
        Reject.ifNull(message, "Message");
        if (this.\u00ed) {
            return;
        }
        byte[] byArray = this.\u00f0.C(message);
        this.A(Convert.convert2Bytes(byArray.length));
        this.A(byArray);
        this.getController().getTransferManager().getTotalUploadTrafficCounter().bytesTransferred(byArray.length);
        if (this.isFiner()) {
            this.logFiner("-> Send via WebSocket (" + byArray.length + "): " + message);
        }
    }

    private void A(byte[] byArray) throws ConnectionException {
        if (this.\u00f3 == null || !this.\u00f3.isOpen()) {
            throw new ConnectionException("Unable to send. Connection/Session is not opened.");
        }
        try {
            this.\u00f3.getRemote().sendBytes(ByteBuffer.wrap(byArray));
        }
        catch (IOException iOException) {
            throw new ConnectionException("Problem while sending: " + iOException);
        }
    }

    private void B(InputStream inputStream) throws IOException, ClassNotFoundException, ConnectionException {
        int n = StreamUtils.readInt(inputStream);
        if (n <= 0) {
            this.logFiner("<- Received via WebSocket (" + n + "): nothing");
            if (n < 0) {
                this.logWarning("<- Received via WebSocket (" + n + "): nothing");
            }
            return;
        }
        if (this.isFiner()) {
            this.logFiner("<- Read expects " + n + " bytes");
        }
        if (this.\u00ed) {
            return;
        }
        byte[] byArray = this.\u00f5.read(inputStream, n);
        Object object = this.\u00f0.A(byArray, n);
        this.\u00f6 = new Date();
        this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n);
        if (this.isFiner()) {
            this.logFiner("<- Received via WebSocket (" + n + "): " + object);
        }
        try {
            this.B(object);
        }
        catch (RuntimeException runtimeException) {
            this.logSevere(runtimeException);
            this.shutdownWithMember();
            throw runtimeException;
        }
    }

    public String toString() {
        if (this.\u00ed) {
            return "-disconnected-";
        }
        return this.\u00e6.toString();
    }

    @Override
    public F \u00ca() {
        return this.\u00f0;
    }

    @Override
    public boolean isEncrypted() {
        return this.\u00f0.\u00e1();
    }

    @Override
    public boolean canMeasureTimeDifference() {
        return false;
    }

    @Override
    public long getTimeDeltaMS() {
        return 0L;
    }

    @Override
    public Identity getIdentity() {
        return this.\u00f2;
    }

    @Override
    public Member getMember() {
        return this.\u00ef;
    }

    public void C(Member member) {
        this.\u00ef = member;
    }

    @Override
    public String getMyMagicId() {
        return this.\u00ec;
    }

    @Override
    public Identity getMyIdentity() {
        return this.\u00f4;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.\u00e7.getConnectAddress();
    }

    @Override
    public int getRemoteListenerPort() {
        return this.\u00e7.getConnectAddress().getPort();
    }

    @Override
    public String getRemoteMagicId() {
        return this.\u00f2.getMagicId();
    }

    @Override
    public boolean acceptHandshake() {
        return this.\u00f0.\u00d8();
    }

    @Override
    public boolean isConnected() {
        return !this.\u00ed;
    }

    @Override
    public boolean isOnLAN() {
        return this.\u00e8;
    }

    @Override
    public void setOnLAN(boolean bl) {
    }

    private class _B
    extends WebSocketAdapter {
        private _B() {
        }

        @Override
        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            if (B.this.isFine()) {
                B.this.logFine(B.this + ": onWebSocketConnect. " + session);
            }
            B.this.\u00f3 = session;
        }

        @Override
        public void onWebSocketClose(int n, String string) {
            super.onWebSocketClose(n, string);
            B.this.logInfo(B.this + ": onWebSocketClose. statusCode=" + n + ", reason=" + string);
            B.this.\u00f3 = null;
        }

        @Override
        public void onWebSocketError(Throwable throwable) {
            super.onWebSocketError(throwable);
            if (throwable instanceof UpgradeException) {
                B.this.logWarning(B.this + ": Connection upgrade failed. " + throwable.getMessage());
            } else {
                B.this.logWarning(B.this + ": onWebSocketError. cause=" + throwable);
            }
            B.this.\u00ed = true;
        }

        @Override
        public void onWebSocketBinary(byte[] byArray, int n, int n2) {
            if (B.this.isFiner()) {
                B.this.logFiner(B.this + ": onWebSocketBinary: " + n + "-" + n2);
            }
            try {
                B.this.B(new ByteArrayInputStream(byArray, n, n2));
            }
            catch (EOFException eOFException) {
                B.this.logWarning("Connection EOF from " + B.this.\u00e6);
                B.this.logFiner(eOFException);
                B.this.shutdownWithMember();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                B.this.logWarning("Timeout to " + B.this.\u00e6);
                B.this.logFiner(socketTimeoutException);
                B.this.shutdownWithMember();
            }
            catch (ClassNotFoundException classNotFoundException) {
                B.this.logFiner("ClassNotFoundException", classNotFoundException);
                B.this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + B.this);
            }
            catch (Exception exception) {
                B.this.logWarning("Connection broken to " + B.this.\u00e6 + ". " + exception);
                B.this.shutdownWithMember();
            }
        }

        @Override
        public void onWebSocketText(String string) {
            throw new UnsupportedOperationException();
        }
    }

    private class _A
    implements Runnable {
        private _A() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!B.this.\u00ed) {
                    Queue queue;
                    Message message;
                    while ((message = (Message)B.this.\u00ee.poll()) == null) {
                        queue = B.this.\u00ee;
                        synchronized (queue) {
                            B.this.\u00ee.wait(1L);
                        }
                        if (!B.this.\u00ed) continue;
                    }
                    queue = B.this.\u00ee;
                    synchronized (queue) {
                        B.this.\u00ee.notifyAll();
                    }
                    if (B.this.\u00ed) {
                    } else {
                        if (message != null) {
                            B.this.A(message);
                        }
                        if (!B.this.\u00ed) continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                B.this.logFiner(interruptedException);
                B.this.shutdownWithMember();
            }
            catch (Exception exception) {
                B.this.logWarning("Connection broken to " + B.this.\u00e6 + ". " + exception);
                B.this.shutdownWithMember();
            }
            finally {
                B.this.shutdown();
            }
        }
    }
}

