/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.pro.A;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Feature;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Pong;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionQuality;
import de.dal33t.powerfolder.pro.E.B;
import de.dal33t.powerfolder.pro.E.F;
import de.dal33t.powerfolder.pro.F.G;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.IdGenerator;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StreamUtils;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import de.dal33t.powerfolder.util.net.NetworkUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;

public class A
extends PFComponent
implements B {
    public static final String \u00d4 = "SUCCESS";
    private static final long \u00d9 = 5000L;
    protected long \u00da;
    private _A \u00d3;
    private boolean \u00d6;
    private String \u00db;
    private Queue<Message> \u00d5;
    private InetSocketAddress \u00e4;
    private boolean \u00df;
    private String \u00d8;
    private ByteSerializer \u00e3;
    private Member \u00d2;
    private Identity \u00e1;
    private Identity \u00e5;
    private IdentityReply \u00e0;
    private final Object \u00de = new Object();
    private final Object \u00e2 = new Object();
    private F \u00dd;
    private Date \u00dc;

    public A(Controller controller, de.dal33t.powerfolder.pro.F.B b, InetSocketAddress inetSocketAddress, String string) {
        super(controller);
        Reject.ifNull(inetSocketAddress, "Remote address is null");
        Reject.ifBlank(string, "Server url is blank");
        if (Feature.CORRECT_LAN_DETECTION.isDisabled()) {
            this.logWarning("ON LAN because of correct connection analyse disabled");
            this.\u00d6 = true;
        } else {
            this.\u00d6 = false;
        }
        this.\u00e4 = inetSocketAddress;
        this.\u00db = Util.removeLastSlashFromURI(string);
        this.\u00d5 = new ConcurrentLinkedQueue<Message>();
        this.\u00e3 = new ByteSerializer();
        this.\u00dd = new F(b, this, this.\u00e3);
        this.\u00d3 = new _A();
    }

    @Override
    public F \u00ca() {
        return this.\u00dd;
    }

    @Override
    public boolean isEncrypted() {
        return this.\u00dd.\u00e1();
    }

    public boolean \u00ce() {
        return false;
    }

    @Override
    public boolean canMeasureTimeDifference() {
        return false;
    }

    @Override
    public long getTimeDeltaMS() {
        return 0L;
    }

    @Override
    public Identity getIdentity() {
        return this.\u00e5;
    }

    @Override
    public Member getMember() {
        return this.\u00d2;
    }

    public void B(Member member) {
        this.\u00d2 = member;
    }

    @Override
    public String getMyMagicId() {
        return this.\u00d8;
    }

    @Override
    public Identity getMyIdentity() {
        return this.\u00e1;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.\u00e4;
    }

    @Override
    public int getRemoteListenerPort() {
        return this.\u00e4.getPort();
    }

    @Override
    public String getRemoteMagicId() {
        return this.\u00e5.getMagicId();
    }

    @Override
    public boolean acceptHandshake() {
        return this.\u00dd.\u00d8();
    }

    @Override
    public boolean isConnected() {
        return !this.\u00df && this.\u00da >= 0L;
    }

    @Override
    public boolean isOnLAN() {
        return this.\u00d6;
    }

    @Override
    public void setOnLAN(boolean bl) {
    }

    @Override
    public Date getLastKeepaliveMessageTime() {
        return this.\u00dc;
    }

    @Override
    public ConnectionQuality getConnectionQuality() {
        return ConnectionQuality.POOR;
    }

    @Override
    public void init() throws ConnectionException {
        this.\u00df = false;
        this.\u00da = -1L;
        try {
            this.\u00da = this.\u00cd();
        }
        catch (Exception exception) {
            throw new ConnectionException("Unable to open connection via HTTP relay " + this.\u00db + ". " + exception);
        }
        this.getController().getIOProvider().startIO(new _B());
        this.\u00d8 = IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId() + IdGenerator.makeId();
        this.\u00e1 = new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), true, true, this);
        if (this.isFiner()) {
            this.logFiner("Sending my identity, nick: '" + this.\u00e1.getMemberInfo().nick + "', ID: " + this.\u00e1.getMemberInfo().id);
        }
        this.sendMessagesAsynchron(this.\u00e1);
        this.\u00cc();
        if (!this.isConnected()) {
            this.shutdown();
            throw new ConnectionException("Remote peer disconnected while waiting for his identity").with(this);
        }
        if (this.\u00e5 == null || this.\u00e5.getMemberInfo() == null) {
            throw new ConnectionException("Did not receive a valid identity from peer after 60s").with(this);
        }
        if (this.isFiner()) {
            this.logFiner("Connect, remote ident: " + this.getIdentity());
        }
        this.\u00dd.\u00db();
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    public void shutdown() {
        if (this.\u00df) {
            return;
        }
        this.\u00df = true;
        this.\u00d5.clear();
        this.\u00dd.\u00da();
        this.getController().getIOProvider().removeKeepAliveCheck(this);
        if (this.\u00da >= 0L) {
            this.\u00cf();
        }
        if (this.\u00d2 != null) {
            this.\u00d2.shutdown();
        }
        this.\u00e3 = null;
    }

    @Override
    public void shutdownWithMember() {
        if (this.getMember() != null) {
            this.getMember().shutdown();
        }
        if (!this.\u00df) {
            this.shutdown();
        }
    }

    @Override
    public void sendMessage(Message message) {
        Object object;
        this.\u00d5.offer(message);
        if (this.\u00d5.size() > 1998 && this.isWarning()) {
            object = "Many messages in send queue: " + this.\u00d5.size() + ": " + this.\u00d5;
            if (((String)object).length() > 300) {
                object = ((String)object).substring(0, 300);
                object = (String)object + "...";
            }
            this.logFine((String)object);
        }
        if (this.\u00d5.size() > 2000) {
            object = "Disconnecting " + this.getIdentity() + ": Too many messages in send queue: " + this.\u00d5.size();
            this.logWarning((String)object);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    A.this.shutdownWithMember();
                }
            };
            this.getController().getIOProvider().startIO(runnable);
        }
    }

    @Override
    public void sendMessagesAsynchron(Message ... messageArray) {
        for (Message message : messageArray) {
            this.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForEmptySendQueue() {
        long l = 0L;
        int n = this.\u00d5.size();
        while (!this.\u00d5.isEmpty() && this.isConnected()) {
            try {
                Queue<Message> queue = this.\u00d5;
                synchronized (queue) {
                    this.\u00d5.wait(1L);
                }
                ++l;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
        }
        if (l > 0L && this.isFiner()) {
            this.logFiner(this.getMember() + ": Waited " + l + "ms for empty send buffer. " + n + " messages were in queue.");
        }
        return this.\u00d5.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acceptIdentity(Member member) {
        if (!this.\u00dd.\u00d8()) {
            return false;
        }
        Reject.ifNull(member, "Node is null");
        this.\u00d2 = member;
        this.logFine("Sending accept of identity to " + this);
        this.sendMessagesAsynchron(IdentityReply.accept());
        Object object = this.\u00e2;
        synchronized (object) {
            if (this.\u00e0 == null) {
                try {
                    this.\u00e2.wait(20000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
        if (!this.isConnected()) {
            this.logWarning("Remote member disconnected while waiting for handshake. " + this.\u00e5);
            return false;
        }
        if (this.\u00e0 == null) {
            this.logWarning("Remote peer timed out, while waiting for accept");
            return false;
        }
        if (this.\u00e0.accepted) {
            this.logFine("Identity accepted by remote peer. " + this);
        } else {
            this.\u00d2 = null;
            this.logWarning("Identity rejected by remote peer. " + this);
        }
        return this.\u00e0.accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void \u00cc() {
        Object object = this.\u00de;
        synchronized (object) {
            if (this.\u00e5 == null) {
                try {
                    this.\u00de.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logFiner(interruptedException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(Object object) {
        if (object instanceof Identity) {
            Object object2 = this.\u00de;
            synchronized (object2) {
                this.\u00e5 = (Identity)object;
                this.\u00de.notifyAll();
            }
            if (this.isFiner()) {
                this.logFiner("Received remote identity: " + object + ". Magic ID:  " + this.\u00e5.getMagicId());
            }
        } else {
            if (object instanceof IdentityReply) {
                if (this.isFiner()) {
                    this.logFiner("Received identity reply: " + object);
                }
                Object object3 = this.\u00e2;
                synchronized (object3) {
                    this.\u00e0 = (IdentityReply)object;
                    this.\u00e2.notifyAll();
                }
            }
            if (!(object instanceof Pong)) {
                if (object instanceof Problem) {
                    Problem problem = (Problem)object;
                    if (this.\u00d2 != null) {
                        this.\u00d2.handleMessage(problem, this);
                    } else {
                        this.logFine("(" + (this.\u00e5 != null ? this.\u00e5.getMemberInfo().nick : "-") + ") Problem received: " + problem.message);
                        if (problem.fatal) {
                            this.shutdown();
                        }
                    }
                } else if (object instanceof Message) {
                    boolean bl = false;
                    try {
                        bl = this.\u00dd.B((Message)object);
                    }
                    catch (G g) {
                        this.logSevere("Problem initalizing encryption, connection closed", g);
                        this.shutdown();
                    }
                    if (!bl) {
                        if (this.\u00d2 != null) {
                            this.\u00d2.handleMessage((Message)object, this);
                        } else if (!this.isConnected()) {
                            this.shutdown();
                        } else {
                            if (this.\u00dc == null) {
                                this.logWarning("Connection closed, message received, before peer identified itself: " + object);
                            }
                            this.shutdown();
                        }
                    }
                } else {
                    this.logWarning("Received unknown message from peer: " + object);
                }
            }
        }
    }

    private void \u00cf() {
        try {
            HttpURLConnection httpURLConnection = this.\u00cb();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
            bufferedWriter.write("action=close");
            bufferedWriter.write("&");
            bufferedWriter.write("id=" + this.\u00da);
            bufferedWriter.flush();
            bufferedWriter.close();
            httpURLConnection.connect();
            httpURLConnection.getInputStream();
            this.\u00d3.B(httpURLConnection);
        }
        catch (Exception exception) {
            this.logFiner("Problem shutting down propertly", exception);
        }
    }

    private long \u00cd() throws Exception {
        String string = this.\u00e4.getHostString();
        if (StringUtils.isBlank(string) && this.\u00e4.getAddress() != null && !NetworkUtil.isNullIP(this.\u00e4.getAddress())) {
            string = this.\u00e4.getAddress().getHostAddress();
        }
        HttpURLConnection httpURLConnection = this.\u00cb();
        Object object = "action=open";
        object = (String)object + "&";
        object = (String)object + "host=" + string;
        object = (String)object + "&";
        object = (String)object + "port=" + this.\u00e4.getPort();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
        bufferedWriter.write((String)object);
        bufferedWriter.flush();
        bufferedWriter.close();
        httpURLConnection.connect();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
            String string2 = bufferedReader.readLine();
            if (string2.startsWith(\u00d4)) {
                long l = Long.parseLong(bufferedReader.readLine());
                this.logFine("Connection Successful. connectionID: " + l);
                this.\u00d3.B(httpURLConnection);
                long l2 = l;
                return l2;
            }
            throw new Exception("Unable to connect to remote host. Result: " + string2);
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private HttpURLConnection \u00cb() throws IOException {
        URL uRL = new URL(this.\u00db);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setInstanceFollowRedirects(false);
        httpURLConnection.setDoOutput(true);
        this.\u00d3.A(httpURLConnection);
        return httpURLConnection;
    }

    private boolean A(byte by) {
        boolean bl = true;
        if (by >= 33 && by <= 126) {
            bl = by == 37 || by == 63 || by == 64 || by == 38 || by == 61 || by == 43 || by == 58 || by == 35;
        }
        return bl;
    }

    private void A(Writer writer, byte[] byArray, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (this.A(byArray[i])) {
                this.A(writer, byArray[i]);
                continue;
            }
            writer.append((char)byArray[i]);
        }
    }

    private void A(Writer writer, byte n) throws IOException {
        writer.append('#');
        int n2 = n;
        String string = Integer.toHexString(n2 &= 0xFF);
        if (string.length() == 1) {
            writer.append('0');
        }
        writer.append(string);
    }

    private void A(OutputStream outputStream, Message message) throws IOException, ConnectionException {
        int n;
        byte[] byArray;
        if (message != null) {
            if (this.\u00df) {
                return;
            }
            byArray = this.\u00dd.C(message);
            n = byArray.length + 4;
        } else {
            byArray = null;
            n = 0;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream), 1024);
        bufferedWriter.write("action=readwrite");
        bufferedWriter.write("&");
        bufferedWriter.write("id=" + this.\u00da);
        bufferedWriter.write("&");
        bufferedWriter.write("datalength=" + n);
        bufferedWriter.write("&");
        bufferedWriter.write("data=");
        if (byArray != null && n > 0) {
            this.A(bufferedWriter, Convert.convert2Bytes(byArray.length), 4);
            this.A(bufferedWriter, byArray, byArray.length);
            this.getController().getTransferManager().getTotalUploadTrafficCounter().bytesTransferred(n);
        }
        if (this.isFiner()) {
            String string = this.isEncrypted() ? "s" : "";
            this.logFiner("-> Send via HTTP" + string + " (" + n + "): " + (message != null ? message.toString() : "nothing"));
        }
        ((Writer)bufferedWriter).flush();
        ((Writer)bufferedWriter).close();
    }

    private boolean A(InputStream inputStream) throws IOException, ClassNotFoundException, ConnectionException {
        int n = inputStream.read();
        if (n == 0) {
            if (this.isFiner()) {
                this.logFiner("Status byte 0 received, breaking connection");
            }
            this.shutdown();
            return false;
        }
        String string = this.isEncrypted() ? "s" : "";
        int n2 = StreamUtils.readInt(inputStream);
        if (n2 <= 0) {
            this.logFiner("<- Received via HTTP" + string + " (0): nothing");
            return false;
        }
        if (this.isFiner()) {
            this.logFiner("<- Read expects " + n2 + " bytes");
        }
        if (this.\u00df) {
            return false;
        }
        byte[] byArray = this.\u00e3.read(inputStream, n2);
        Object object = this.\u00dd.A(byArray, n2);
        this.\u00dc = new Date();
        this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n2);
        if (this.isFiner()) {
            this.logFiner("<- Received via HTTP" + string + " (" + n2 + "): " + object);
        }
        try {
            this.A(object);
        }
        catch (RuntimeException runtimeException) {
            this.logSevere(runtimeException);
            this.shutdownWithMember();
            throw runtimeException;
        }
        return true;
    }

    public String toString() {
        if (this.\u00df) {
            return "HTTP:-disconnected-";
        }
        return "HTTP:" + (Serializable)(this.\u00e4.getAddress() != null ? this.\u00e4.getAddress() : this.\u00e4.getHostString()) + ":" + this.\u00e4.getPort();
    }

    private class _A {
        private final Map<String, Map<String, Map<String, String>>> F = new HashMap<String, Map<String, Map<String, String>>>();
        private static final String B = "Set-Cookie";
        private static final String K = ";";
        private static final String J = "path";
        private static final String D = "expires";
        private static final String L = "EEE, dd-MMM-yyyy hh:mm:ss z";
        private static final String H = "; ";
        private static final String G = "Cookie";
        private static final char I = '=';
        private static final char E = '.';
        private DateFormat A = new SimpleDateFormat("EEE, dd-MMM-yyyy hh:mm:ss z");

        public void B(URLConnection uRLConnection) {
            try {
                Map<Object, Object> map;
                String string = this.B(uRLConnection.getURL().getHost());
                if (this.F.containsKey(string)) {
                    map = this.F.get(string);
                } else {
                    map = new HashMap();
                    this.F.put(string, map);
                }
                String string2 = null;
                int n = 1;
                while ((string2 = uRLConnection.getHeaderFieldKey(n)) != null) {
                    block10: {
                        String string3;
                        String string4;
                        int n2;
                        String string5;
                        StringTokenizer stringTokenizer;
                        HashMap<String, String> hashMap;
                        block11: {
                            if (!string2.equalsIgnoreCase(B)) break block10;
                            hashMap = new HashMap<String, String>();
                            stringTokenizer = new StringTokenizer(uRLConnection.getHeaderField(n), K);
                            if (!stringTokenizer.hasMoreTokens()) break block11;
                            string5 = stringTokenizer.nextToken();
                            n2 = string5.indexOf(61);
                            if (n2 < 0) break block10;
                            string4 = string5.substring(0, n2);
                            string3 = string5.substring(n2 + 1);
                            map.put(string4, hashMap);
                            hashMap.put(string4, string3);
                        }
                        while (stringTokenizer.hasMoreTokens()) {
                            string5 = stringTokenizer.nextToken();
                            n2 = string5.indexOf(61);
                            if (n2 < 0) continue;
                            string4 = string5.substring(0, n2).toLowerCase();
                            string3 = string5.substring(n2 + 1);
                            hashMap.put(string4, string3);
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                A.this.logWarning("Unable to get/retrieve cookies from request. " + exception, exception);
            }
        }

        public void A(URLConnection uRLConnection) {
            try {
                URL uRL = uRLConnection.getURL();
                String string = this.B(uRL.getHost());
                String string2 = uRL.getPath();
                Map<String, Map<String, String>> map = this.F.get(string);
                if (map == null) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                Iterator<String> iterator = map.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = iterator.next();
                    Map<String, String> map2 = map.get(string3);
                    if (!this.A(map2.get(J), string2) || !this.A(map2.get(D))) continue;
                    stringBuffer.append(string3);
                    stringBuffer.append("=");
                    stringBuffer.append(map2.get(string3));
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(H);
                }
                try {
                    uRLConnection.setRequestProperty(G, stringBuffer.toString());
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IOException("Illegal State! Cookies cannot be set on a URLConnection that is already connected. Only call setCookies(java.net.URLConnection) AFTER calling java.net.URLConnection.connect().");
                }
            }
            catch (Exception exception) {
                A.this.logWarning("Unable to restore/set cookies. " + exception);
            }
        }

        private String B(String string) {
            if (string.indexOf(46) != string.lastIndexOf(46)) {
                return string.substring(string.indexOf(46) + 1);
            }
            return string;
        }

        private boolean A(String string) {
            if (string == null) {
                return true;
            }
            Date date = new Date();
            try {
                return date.compareTo(this.A.parse(string)) <= 0;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return false;
            }
        }

        private boolean A(String string, String string2) {
            if (string == null) {
                return true;
            }
            if (string.equals("/")) {
                return true;
            }
            return string2.regionMatches(0, string, 0, string.length());
        }
    }

    private class _B
    implements Runnable {
        private _B() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean bl = true;
                while (!A.this.\u00df) {
                    Message message;
                    long l;
                    long l2 = l = bl ? 0L : 5000L;
                    while ((message = (Message)A.this.\u00d5.poll()) == null && l > 0L) {
                        Thread.sleep(1L);
                        --l;
                    }
                    Queue queue = A.this.\u00d5;
                    synchronized (queue) {
                        A.this.\u00d5.notifyAll();
                    }
                    if (A.this.\u00df) {
                        break;
                    }
                    HttpURLConnection httpURLConnection = A.this.\u00cb();
                    A.this.A(httpURLConnection.getOutputStream(), message);
                    A.this.\u00d3.B(httpURLConnection);
                    if (A.this.\u00df) {
                        break;
                    }
                    bl = A.this.A(httpURLConnection.getInputStream());
                }
            }
            catch (InterruptedException interruptedException) {
                A.this.logFiner(interruptedException);
                A.this.shutdownWithMember();
            }
            catch (EOFException eOFException) {
                A.this.logWarning("Connection EOF from " + A.this.\u00e4);
                A.this.logFiner(eOFException);
                A.this.shutdownWithMember();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                A.this.logWarning("Timeout to " + A.this.\u00e4);
                A.this.logFiner(socketTimeoutException);
                A.this.shutdownWithMember();
            }
            catch (ClassNotFoundException classNotFoundException) {
                A.this.logFiner("ClassNotFoundException", classNotFoundException);
                A.this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + A.this);
            }
            catch (Exception exception) {
                A.this.logWarning("Connection broken to " + A.this.\u00e4 + ". " + exception);
                A.this.shutdownWithMember();
            }
            finally {
                A.this.shutdown();
            }
        }
    }
}

