/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.net.AbstractRelayedConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.util.ByteSerializer;
import java.io.IOException;

public class PlainRelayedConnectionHandler
extends AbstractRelayedConnectionHandler {
    protected PlainRelayedConnectionHandler(Controller controller, MemberInfo memberInfo, long l, Member member) {
        super(controller, memberInfo, l, member);
    }

    @Override
    protected Identity createOwnIdentity() {
        return new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), false, true, this);
    }

    @Override
    protected byte[] serialize(Message message) throws ConnectionException {
        try {
            return this.getSerializer().serialize(message, this.getMyIdentity().isUseCompressedStream(), -1);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this);
        }
    }

    @Override
    protected Object deserialize(byte[] byArray, int n) throws ConnectionException, ClassNotFoundException {
        boolean bl;
        boolean bl2 = bl = !this.isOnLAN();
        if (this.getIdentity() != null && this.getIdentity().isUseCompressedStream() != null) {
            bl = this.getIdentity().isUseCompressedStream();
        }
        try {
            return ByteSerializer.deserializeStatic(byArray, bl);
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to send message to peer, connection closed", iOException).with(this);
        }
    }
}

