/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.net;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PFComponent;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.util.Profiling;
import de.dal33t.powerfolder.util.ProfilingEntry;
import de.dal33t.powerfolder.util.Reject;
import java.util.Date;

public abstract class AbstractAcceptor
extends PFComponent
implements Runnable {
    private Date startTime;
    private ConnectionHandler handler;

    protected AbstractAcceptor(Controller controller) {
        super(controller);
    }

    public abstract String getConnectionInfo();

    protected abstract void shutdown();

    protected abstract void accept() throws ConnectionException;

    boolean hasTimeout() {
        Date date;
        if (this.startTime == null) {
            return false;
        }
        Date date2 = date = this.handler != null ? this.handler.getLastKeepaliveMessageTime() : null;
        if (date == null) {
            return System.currentTimeMillis() > this.startTime.getTime() + 120000L;
        }
        return System.currentTimeMillis() > date.getTime() + 120000L;
    }

    boolean isShutdown() {
        return this.handler != null && !this.handler.isConnected();
    }

    @Override
    public final void run() {
        block9: {
            if (!this.getController().getNodeManager().isStarted()) {
                this.logWarning("NodeManager not started. Closing incoming connection attempt: " + this);
                return;
            }
            ProfilingEntry profilingEntry = Profiling.start();
            this.startTime = new Date();
            try {
                this.accept();
            }
            catch (ConnectionException connectionException) {
                this.logFiner("Unable to accept incoming connection handler " + this, connectionException);
                this.shutdown();
            }
            catch (RuntimeException runtimeException) {
                if (runtimeException.getCause() instanceof InterruptedException) {
                    this.logFiner("Acceptor interrupted, closing. " + this);
                    this.shutdown();
                    break block9;
                }
                throw runtimeException;
            }
            finally {
                this.getController().getNodeManager().acceptors.remove(this);
                Profiling.end(profilingEntry);
            }
        }
    }

    public void acceptConnection(ConnectionHandler connectionHandler) {
        Reject.ifNull(connectionHandler, "ConnectionHandler");
        try {
            this.handler = connectionHandler;
            this.getController().getNodeManager().acceptConnection(connectionHandler);
        }
        catch (ConnectionException connectionException) {
            this.logFiner("Unable to accept incoming connection handler " + connectionHandler, connectionException);
            connectionHandler.shutdown();
            this.shutdown();
            this.getController().getNodeManager().acceptors.remove(this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getConnectionInfo();
    }
}

