/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.StatusCode;
import de.dal33t.powerfolder.d2d.D2DRequestMessage;
import de.dal33t.powerfolder.d2d.NodeEvent;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.dao.FileInfoCriteria;
import de.dal33t.powerfolder.light.DirectoryInfo;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FileInfoFactory;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.light.FolderInfoFactory;
import de.dal33t.powerfolder.message.clientserver.FileListReply;
import de.dal33t.powerfolder.protocol.FileListRequestProto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class D2DFileListRequest
extends D2DRequestMessage {
    private String folderId;
    private Collection<String> fileIds;
    private boolean recursive;

    public D2DFileListRequest() {
    }

    public D2DFileListRequest(AbstractMessage abstractMessage) {
        this.initFromD2D(abstractMessage);
    }

    public String getFolderId() {
        return this.folderId;
    }

    public Collection<String> getFileIds() {
        return this.fileIds;
    }

    public void setFileIds(Collection<String> collection) {
        this.fileIds = collection;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof FileListRequestProto.FileListRequest) {
            FileListRequestProto.FileListRequest fileListRequest = (FileListRequestProto.FileListRequest)abstractMessage;
            this.requestCode = fileListRequest.getRequestCode();
            this.folderId = fileListRequest.getFolderId();
            this.fileIds = new CopyOnWriteArrayList<String>();
            this.fileIds.addAll(fileListRequest.getFileIdsList());
            this.recursive = fileListRequest.getRecursive();
        }
    }

    @Override
    public AbstractMessage toD2D() {
        FileListRequestProto.FileListRequest.Builder builder = FileListRequestProto.FileListRequest.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        if (this.requestCode != null) {
            builder.setRequestCode(this.getRequestCode());
        }
        if (this.folderId != null) {
            builder.setFolderId(this.folderId);
        }
        if (this.fileIds != null) {
            for (String string : this.fileIds) {
                builder.addFileIds(string);
            }
        }
        builder.setRecursive(this.recursive);
        return builder.build();
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.folderId != null;
    }

    @Override
    public NodeEvent getNodeEvent() {
        return NodeEvent.FILE_LIST_REQUEST;
    }

    @Override
    public void handle(Member member) {
        ArrayList<FileInfo> arrayList;
        if (!this.isValid()) {
            member.sendMessagesAsynchron(new FileListReply(this.requestCode, StatusCode.FORBIDDEN, null));
            return;
        }
        if (this.folderId == null) {
            member.sendMessagesAsynchron(new FileListReply(this.requestCode, StatusCode.BAD_REQUEST, null));
            return;
        }
        FolderInfo folderInfo = FolderInfoFactory.lookupInstance(this.folderId);
        Folder folder = member.getController().getFolderRepository().getFolder(folderInfo);
        if (folder == null) {
            member.sendMessagesAsynchron(new FileListReply(this.requestCode, StatusCode.BAD_REQUEST, null));
            return;
        }
        if (!folder.hasReadPermission(member)) {
            member.sendMessagesAsynchron(new FileListReply(this.requestCode, StatusCode.BAD_REQUEST, null));
            return;
        }
        folder.waitForScan();
        if (this.fileIds == null || this.fileIds.size() == 0) {
            FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
            fileInfoCriteria.addConnectedAndMyself(folder);
            fileInfoCriteria.setIncludeDeleted(true);
            if (this.recursive) {
                fileInfoCriteria.setRecursive(true);
            }
            arrayList = folder.getDAO().findFilesFast(fileInfoCriteria);
        } else {
            arrayList = new ArrayList();
            for (String string : this.fileIds) {
                String string2 = string.replaceFirst(this.folderId + "/", "");
                FileInfo fileInfo = folder.getDAO().find(FileInfoFactory.lookupInstance(folderInfo, string2), member.getController().getMySelf().getId());
                if (fileInfo != null) {
                    arrayList.add(fileInfo);
                }
                if (!(fileInfo instanceof DirectoryInfo)) continue;
                FileInfoCriteria fileInfoCriteria = new FileInfoCriteria();
                fileInfoCriteria.addConnectedAndMyself(folder);
                fileInfoCriteria.setPath(fileInfo.getRelativeName());
                fileInfoCriteria.setIncludeDeleted(true);
                if (this.recursive) {
                    fileInfoCriteria.setRecursive(true);
                }
                arrayList.addAll(folder.getDAO().findFilesFast(fileInfoCriteria));
            }
        }
        member.sendMessagesAsynchron(new FileListReply(this.requestCode, StatusCode.OK, arrayList));
    }
}

