/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message.clientserver;

import com.google.protobuf.AbstractMessage;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.light.MemberInfo;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.protocol.AccountStateChangedProto;
import de.dal33t.powerfolder.protocol.NodeInfoProto;
import de.dal33t.powerfolder.util.Reject;

public class AccountStateChanged
extends Message
implements D2DObject {
    private static final long serialVersionUID = 100L;
    private MemberInfo node;
    private int ttl;

    public AccountStateChanged(MemberInfo memberInfo, int n) {
        Reject.ifNull(memberInfo, "Node is null");
        Reject.ifFalse(n > 0 && n < 10, "Illegal value for ttl");
        this.node = memberInfo;
        this.ttl = n;
    }

    public MemberInfo getNode() {
        return this.node;
    }

    public int getTTL() {
        return this.ttl;
    }

    public void decreaseTTL() {
        --this.ttl;
    }

    public boolean isAlive() {
        return !this.isDead();
    }

    public boolean isDead() {
        return this.ttl <= 0;
    }

    public String toString() {
        return "AccountStateChanged on " + this.node + " TTL=" + this.ttl;
    }

    @Override
    public void initFromD2D(AbstractMessage abstractMessage) {
        if (abstractMessage instanceof AccountStateChangedProto.AccountStateChanged) {
            AccountStateChangedProto.AccountStateChanged accountStateChanged = (AccountStateChangedProto.AccountStateChanged)abstractMessage;
            this.node = new MemberInfo(accountStateChanged.getNodeInfo());
        }
    }

    @Override
    public AbstractMessage toD2D() {
        AccountStateChangedProto.AccountStateChanged.Builder builder = AccountStateChangedProto.AccountStateChanged.newBuilder();
        builder.setClazzName(this.getClass().getSimpleName());
        builder.setNodeInfo((NodeInfoProto.NodeInfo)this.node.toD2D());
        return builder.build();
    }
}

