/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.message;

import de.dal33t.powerfolder.EncryptionPolicy;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.pro.F.D;
import de.dal33t.powerfolder.pro.F.G;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.Util;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class EncryptionChallenge
extends Message {
    private static final long serialVersionUID = 101L;
    private static final String SHA1_WITH_RSA = "SHA1withRSA";
    public EncryptionPolicy policy;
    public PublicKey publicKey;
    public List<byte[]> checkBytes;
    public byte[] signature;

    public EncryptionChallenge(EncryptionPolicy encryptionPolicy, KeyPair keyPair, String string) throws G {
        Reject.ifNull((Object)encryptionPolicy, "Policy is null");
        Reject.ifNull(keyPair, "Keypair is null");
        this.policy = encryptionPolicy;
        this.publicKey = keyPair.getPublic();
        try {
            Cipher cipher = D.B(keyPair.getPrivate());
            byte[] byArray = string.getBytes("UTF-8");
            List<byte[]> list = Util.splitArray(byArray, 100);
            this.checkBytes = D.A(list, cipher);
            Signature signature = Signature.getInstance(SHA1_WITH_RSA);
            signature.initSign(keyPair.getPrivate());
            signature.update(byArray);
            this.signature = signature.sign();
        }
        catch (Exception exception) {
            throw new G("Problem while generating encryption challenge", exception);
        }
    }

    public void validateIdentity(String string) throws G {
        try {
            Cipher cipher = D.C(this.publicKey);
            List<byte[]> list = D.A(this.checkBytes, cipher);
            byte[] byArray = Util.mergeArrayList(list);
            String string2 = new String(byArray, "UTF-8");
            if (!string2.equals(string)) {
                throw new G("Problem while validating identity: magic id mismatch");
            }
            if (this.signature == null) {
                throw new G("Signature missing");
            }
            Signature signature = Signature.getInstance(SHA1_WITH_RSA);
            signature.initVerify(this.publicKey);
            signature.update(byArray);
            if (!signature.verify(this.signature)) {
                throw new G("Unable to verify signature");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new G("Problem while checking encryption challenge", unsupportedEncodingException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new G("Problem while checking encryption challenge", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new G("Problem while checking encryption challenge", badPaddingException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new G("Problem while checking encryption challenge", noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new G("Problem while checking encryption challenge", signatureException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new G("Problem while checking encryption challenge", invalidKeyException);
        }
    }
}

