/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.event;

import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.transfer.Download;
import de.dal33t.powerfolder.transfer.TransferManager;
import de.dal33t.powerfolder.transfer.TransferProblem;
import de.dal33t.powerfolder.transfer.Upload;
import java.util.EventObject;

public class TransferManagerEvent
extends EventObject {
    private Download download;
    private FileInfo file;
    private Upload upload;
    private TransferProblem transferProblem;
    private String problemInformation;

    public TransferManagerEvent(TransferManager transferManager, Download download, TransferProblem transferProblem, String string) {
        super(transferManager);
        this.download = download;
        this.file = download.getFile();
        this.transferProblem = transferProblem;
        this.problemInformation = string;
    }

    public TransferManagerEvent(TransferManager transferManager, Download download) {
        super(transferManager);
        this.download = download;
        this.file = download.getFile();
    }

    public TransferManagerEvent(TransferManager transferManager, Download download, FileInfo fileInfo) {
        super(transferManager);
        this.download = download;
        this.file = fileInfo;
    }

    public TransferManagerEvent(TransferManager transferManager, Upload upload) {
        super(transferManager);
        this.upload = upload;
        this.file = upload.getFile();
    }

    public Download getDownload() {
        return this.download;
    }

    public FileInfo getFile() {
        if (this.file != null) {
            return this.file;
        }
        if (this.download != null) {
            return this.download.getFile();
        }
        if (this.upload != null) {
            return this.upload.getFile();
        }
        return null;
    }

    public Upload getUpload() {
        return this.upload;
    }

    public TransferProblem getTransferProblem() {
        return this.transferProblem;
    }

    public String getProblemInformation() {
        return this.problemInformation;
    }
}

