/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.distribution;

import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.PreferencesEntry;
import de.dal33t.powerfolder.clientserver.ServerClient;
import de.dal33t.powerfolder.distribution.AbstractDistribution;
import de.dal33t.powerfolder.skin.AbstractSyntheticaSkin;
import de.dal33t.powerfolder.skin.Origin;
import de.dal33t.powerfolder.ui.LookAndFeelSupport;
import de.dal33t.powerfolder.ui.dialog.ConfigurationLoaderDialog;
import de.dal33t.powerfolder.ui.util.Icons;
import de.dal33t.powerfolder.util.ConfigurationLoader;
import de.dal33t.powerfolder.util.StringUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;

public class Standard
extends AbstractDistribution {
    private static final String STANDARD_SKIN_NAME = "Standard";

    @Override
    public String getName() {
        if (this.getController() == null) {
            return STANDARD_SKIN_NAME;
        }
        String string = ConfigurationEntry.DIST_NAME.getValue(this.getController());
        if (StringUtils.isBlank(string)) {
            if (StringUtils.isNotBlank(this.getBinaryName())) {
                return this.getBinaryName();
            }
            this.logWarning("Using fallback value for name (PowerFolder)", new RuntimeException());
            string = "PowerFolder";
        }
        return string;
    }

    @Override
    public String getBinaryName() {
        if (this.getController() == null) {
            return STANDARD_SKIN_NAME;
        }
        String string = ConfigurationEntry.DIST_BINARY_NAME.getValue(this.getController());
        if (StringUtils.isBlank(string)) {
            this.logWarning("Using fallback value for binary name (PowerFolder)", new RuntimeException());
            string = "PowerFolder";
        }
        return string;
    }

    public String getDescription() {
        return ConfigurationEntry.DIST_DESCRIPTION.getValue(this.getController());
    }

    @Override
    public void init(Controller controller) {
        super.init(controller);
        this.loadPreConfigFromClasspath(controller, null);
        boolean bl = ConfigurationEntry.CONFIG_PROMPT_SERVER_IF_PF_COM.getValueBoolean(this.getController()) != false && ServerClient.isPowerFolderCloud(this.getController());
        String string = ConfigurationEntry.CONFIG_URL.getValue(controller);
        if (StringUtils.isNotBlank(string) && !ConfigurationLoader.loadAndMergeConfigURL(controller)) {
            boolean bl2 = ConfigurationEntry.SERVER_CONNECTION_URLS.hasNonBlankValue(this.getController());
            boolean bl3 = ConfigurationEntry.SERVER_HOST.hasNonBlankValue(this.getController());
            bl = !bl2 && !bl3;
        }
        ConfigurationLoader.loadAndMergePList(controller);
        ConfigurationLoader.loadAndMergeFromInstaller(controller);
        if (bl && controller.isUIEnabled()) {
            Standard.setAppName(this.getName());
            Standard.setAppDescription(this.getDescription());
            Standard.setFoldersBaseDirName(controller, ConfigurationEntry.DIST_FOLDERS_BASE_NAME.getValue(this.getController()));
            PreferencesEntry.SKIN_NAME.setValue(controller, STANDARD_SKIN_NAME);
            try {
                Skin skin = new Skin();
                Icons.setIconProperties(skin.getIconsProperties());
                LookAndFeelSupport.setLookAndFeel(skin.getLookAndFeel());
            }
            catch (Exception exception) {
                this.logSevere("Failed to set look and feel", exception);
            }
            new ConfigurationLoaderDialog(controller, string).openAndWait();
        }
        Standard.setAppName(this.getName());
        Standard.setAppDescription(this.getDescription());
        Standard.setFoldersBaseDirName(controller, ConfigurationEntry.DIST_FOLDERS_BASE_NAME.getValue(this.getController()));
        PreferencesEntry.SKIN_NAME.setValue(controller, STANDARD_SKIN_NAME);
    }

    @Override
    public boolean allowSkinChange() {
        return false;
    }

    public static class Skin
    extends AbstractSyntheticaSkin {
        @Override
        public String getName() {
            return Standard.STANDARD_SKIN_NAME;
        }

        @Override
        public String getID() {
            return Standard.STANDARD_SKIN_NAME;
        }

        @Override
        public Properties getIconsProperties() {
            Properties properties = Icons.getIconProperties();
            properties.putAll((Map<?, ?>)Icons.loadProperties(Origin.ICON_PROPERTIES_FILENAME));
            properties.putAll((Map<?, ?>)Icons.loadProperties("client/icons.properties"));
            return properties;
        }

        @Override
        public Path getDefaultSynthXMLPath() {
            return Paths.get("/client/synth.xml", new String[0]);
        }
    }
}

