/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.disk.problem;

import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.disk.Folder;
import de.dal33t.powerfolder.disk.problem.ResolvableProblem;
import de.dal33t.powerfolder.light.FileInfo;
import de.dal33t.powerfolder.light.FolderInfo;
import de.dal33t.powerfolder.ui.dialog.DialogFactory;
import de.dal33t.powerfolder.ui.dialog.GenericDialogType;
import de.dal33t.powerfolder.util.Translation;

public class LocalDeletionProblem
extends ResolvableProblem {
    private final FolderInfo folderInfo;
    private final FileInfo fileInfo;

    public LocalDeletionProblem(FolderInfo folderInfo, FileInfo fileInfo) {
        this.folderInfo = folderInfo;
        this.fileInfo = fileInfo;
    }

    @Override
    public Folder getFolder(Controller controller) {
        return this.folderInfo.getFolder(controller);
    }

    @Override
    public Runnable resolution(final Controller controller) {
        return new Runnable(){

            @Override
            public void run() {
                int n = DialogFactory.genericDialog(controller, Translation.get("local_delete_notice.title", LocalDeletionProblem.this.fileInfo.getFilenameOnly()), Translation.get("local_delete_notice.message"), new String[]{Translation.get("local_delete_notice.broadcast_deletions"), Translation.get("local_delete_notice.discard_deletions")}, 0, GenericDialogType.WARN);
                Folder folder = LocalDeletionProblem.this.folderInfo.getFolder(controller);
                if (folder == null) {
                    return;
                }
                if (n == 0) {
                    FileInfo fileInfo = folder.getFile(LocalDeletionProblem.this.fileInfo);
                    folder.scanChangedFile(fileInfo);
                } else if (n == 1) {
                    folder.getDAO().delete(null, LocalDeletionProblem.this.fileInfo);
                    controller.getFolderRepository().getFileRequestor().triggerFileRequesting(LocalDeletionProblem.this.folderInfo);
                }
                folder.removeProblem(LocalDeletionProblem.this);
            }
        };
    }

    @Override
    public String getResolutionDescription() {
        return Translation.get("local_delete_notice.resolution_description");
    }

    @Override
    public String getDescription() {
        return Translation.get("warning_notice.mass_deletion", this.fileInfo.getFilenameOnly());
    }

    @Override
    public String getWikiLinkKey() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        LocalDeletionProblem localDeletionProblem = (LocalDeletionProblem)object;
        return this.fileInfo.equals(localDeletionProblem.fileInfo);
    }

    public int hashCode() {
        return this.fileInfo.hashCode();
    }
}

