/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder.d2d;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.Member;
import de.dal33t.powerfolder.d2d.D2DEvent;
import de.dal33t.powerfolder.d2d.D2DObject;
import de.dal33t.powerfolder.d2d.NodeStateMachine;
import de.dal33t.powerfolder.message.AddFriendNotification;
import de.dal33t.powerfolder.message.FolderFilesChangedExt;
import de.dal33t.powerfolder.message.Identity;
import de.dal33t.powerfolder.message.IdentityReply;
import de.dal33t.powerfolder.message.Invitation;
import de.dal33t.powerfolder.message.KnownNodes;
import de.dal33t.powerfolder.message.Message;
import de.dal33t.powerfolder.message.Ping;
import de.dal33t.powerfolder.message.Problem;
import de.dal33t.powerfolder.message.RelayedMessageExt;
import de.dal33t.powerfolder.message.RequestNodeList;
import de.dal33t.powerfolder.message.TransferStatus;
import de.dal33t.powerfolder.message.UDTMessage;
import de.dal33t.powerfolder.net.AbstractAcceptor;
import de.dal33t.powerfolder.net.AbstractSocketConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionException;
import de.dal33t.powerfolder.net.ConnectionHandler;
import de.dal33t.powerfolder.net.ConnectionListener;
import de.dal33t.powerfolder.protocol.AnyMessageProto;
import de.dal33t.powerfolder.protocol.FolderFilesChangedProto;
import de.dal33t.powerfolder.transfer.LimitedInputStream;
import de.dal33t.powerfolder.transfer.LimitedOutputStream;
import de.dal33t.powerfolder.util.ByteSerializer;
import de.dal33t.powerfolder.util.Convert;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StackDump;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.squirrelframework.foundation.exception.TransitionException;

public class D2DSocketConnectionHandler
extends AbstractSocketConnectionHandler
implements ConnectionHandler {
    private NodeStateMachine nodeStateMachine = NodeStateMachine.build();
    private ConnectionListener.SocketAcceptor socketAcceptor;
    private final String[] PACKAGES = new String[]{"de.dal33t.powerfolder.message.%s", "de.dal33t.powerfolder.message.clientserver.%s", "de.dal33t.powerfolder.util.delta.%s"};

    public D2DSocketConnectionHandler(Controller controller, Socket socket) {
        super(controller, socket);
    }

    public NodeStateMachine getNodeStateMachine() {
        return this.nodeStateMachine;
    }

    private ConnectionListener.SocketAcceptor getSocketAcceptor() {
        return this.socketAcceptor;
    }

    public void setSocketAcceptor(ConnectionListener.SocketAcceptor socketAcceptor) {
        this.socketAcceptor = socketAcceptor;
    }

    @Override
    public void init() throws ConnectionException {
        if (this.socket == null) {
            throw new NullPointerException("Socket is null");
        }
        if (this.socket.isClosed() || !this.socket.isConnected()) {
            throw new ConnectionException("Connection to peer is closed").with(this);
        }
        this.started = true;
        this.identityReply = null;
        this.messagesToSendQueue = new ConcurrentLinkedQueue();
        this.senderSpawnLock = new ReentrantLock();
        try {
            this.out = new LimitedOutputStream(this.getController().getTransferManager().getOutputLimiter(this), this.socket.getOutputStream());
            this.in = new LimitedInputStream(this.getController().getTransferManager().getInputLimiter(this), this.socket.getInputStream());
            this.getController().getIOProvider().startIO(new Receiver());
            this.sendMessagesAsynchron(this.createOwnIdentity());
        }
        catch (IOException iOException) {
            throw new ConnectionException("Unable to open connection: " + iOException.getMessage(), iOException).with(this);
        }
        this.getController().getIOProvider().startKeepAliveCheck(this);
    }

    @Override
    protected Object deserialize(byte[] byArray, int n) throws ClassNotFoundException, ConnectionException {
        if (this.isFiner()) {
            this.logFiner("Got message; parsing it..");
        }
        String string = "unknown";
        try {
            AnyMessageProto.AnyMessage anyMessage = AnyMessageProto.AnyMessage.parseFrom(byArray);
            string = anyMessage.getClazzName();
            String string2 = String.format("de.dal33t.powerfolder.protocol.%sProto$%s", string, string);
            if (string.equals("FolderFilesChanged")) {
                FolderFilesChangedProto.FolderFilesChanged folderFilesChanged = FolderFilesChangedProto.FolderFilesChanged.parseFrom(byArray);
                FolderFilesChangedExt folderFilesChangedExt = new FolderFilesChangedExt();
                folderFilesChangedExt.initFromD2D(folderFilesChanged);
                return folderFilesChangedExt;
            }
            Class<?> clazz = Class.forName(string2);
            Method method = clazz.getMethod("parseFrom", byte[].class);
            AbstractMessage abstractMessage = (AbstractMessage)method.invoke(null, new Object[]{byArray});
            if (string.equals("DownloadAbort")) {
                string = "AbortDownload";
            } else if (string.equals("DownloadRequest")) {
                string = "RequestDownload";
            } else if (string.equals("FileListRequest")) {
                string = "D2DFileListRequest";
            } else if (string.equals("FilePartInfo")) {
                string = "PartInfo";
            } else if (string.equals("FilePartInfoList")) {
                string = "FilePartsRecord";
            } else if (string.equals("FilePartInfoListReply")) {
                string = "ReplyFilePartsRecord";
            } else if (string.equals("FilePartInfoListRequest")) {
                string = "RequestFilePartsRecord";
            } else if (string.equals("FilePartReply")) {
                string = "FileChunk";
            } else if (string.equals("FilePartRequest")) {
                string = "RequestPart";
            } else if (string.equals("NodeInfo")) {
                string = "MemberInfo";
            } else if (string.equals("NodeList")) {
                string = "KnownNodes";
            } else if (string.equals("NodeListRequest")) {
                string = "RequestNodeList";
            } else if (string.equals("UploadAbort")) {
                string = "AbortUpload";
            } else if (string.equals("UploadStart")) {
                string = "StartUpload";
            } else if (string.equals("UploadStop")) {
                string = "StopUpload";
            }
            for (String string3 : this.PACKAGES) {
                try {
                    clazz = Class.forName(String.format(string3, string));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = null;
                }
                if (null != clazz) break;
            }
            method = clazz.getMethod("initFromD2D", AbstractMessage.class);
            Object obj = clazz.newInstance();
            method.invoke(obj, abstractMessage);
            return obj;
        }
        catch (InvalidProtocolBufferException | IllegalAccessException | IllegalArgumentException | IllegalStateException | InstantiationException | NoSuchMethodException | NullPointerException | SecurityException | InvocationTargetException exception) {
            if (this.isFiner()) {
                this.logFiner("Cannot read message(" + string + "): " + exception);
            }
            throw new ConnectionException("Unable to read message (" + string + "), connection closed", exception).with(this);
        }
        catch (RuntimeException runtimeException) {
            this.logWarning(string + ": " + runtimeException.getMessage(), runtimeException);
            throw new ConnectionException("RuntimeException while reading message (" + string + "), connection closed", runtimeException).with(this);
        }
    }

    @Override
    protected byte[] serialize(Message message) throws ConnectionException {
        AbstractMessage abstractMessage;
        if (message instanceof AddFriendNotification) {
            message = new Ping();
        } else if (message instanceof KnownNodes) {
            message = new Ping();
        } else if (message instanceof RelayedMessageExt) {
            message = new Ping();
        } else if (message instanceof Invitation) {
            message = new Ping();
        } else if (message instanceof Problem) {
            message = new Ping();
        } else if (message instanceof RequestNodeList) {
            message = new Ping();
        } else if (message instanceof TransferStatus) {
            message = new Ping();
        } else if (message instanceof UDTMessage) {
            message = new Ping();
        }
        byte[] byArray = null;
        if (message instanceof D2DObject) {
            abstractMessage = ((D2DObject)((Object)message)).toD2D();
            if (this.isFiner()) {
                this.logFiner("Sent " + abstractMessage.getClass().getCanonicalName());
            }
        } else {
            this.logWarning("Message " + message.getClass().getSimpleName() + " does not implement D2Object: " + message, new StackDump());
            throw new ConnectionException("Message " + message.getClass().getSimpleName() + " does not implement D2Object: " + message).with(this);
        }
        byArray = abstractMessage.toByteArray();
        return byArray;
    }

    @Override
    protected Identity createOwnIdentity() {
        return new Identity(this.getController(), this.getController().getMySelf().getInfo(), this.getMyMagicId(), false, false, this);
    }

    @Override
    public boolean acceptIdentity(Member member) {
        if (member.isServer()) {
            this.sendMessagesAsynchron(IdentityReply.reject("Forbidden"));
            return false;
        }
        this.nodeStateMachine.setNode(member);
        Reject.ifNull(member, "node is null");
        this.member = member;
        if (this.isFiner()) {
            this.logFiner("Sending accept of identity to " + this);
        }
        this.sendMessagesAsynchron(IdentityReply.accept());
        return true;
    }

    class Receiver
    implements Runnable {
        Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = new byte[4];
            while (D2DSocketConnectionHandler.this.started && D2DSocketConnectionHandler.this.isConnected()) {
                Object object;
                Object object2 = null;
                try {
                    D2DSocketConnectionHandler.this.read(D2DSocketConnectionHandler.this.in, byArray, 0, byArray.length);
                    int n = Convert.convert2Int(byArray);
                    if (!D2DSocketConnectionHandler.this.started) break;
                    if (n <= 0) {
                        throw new IOException("Illegal packet size: " + n);
                    }
                    object = D2DSocketConnectionHandler.this.serializer;
                    if (object == null) {
                        throw new EOFException();
                    }
                    byte[] byArray2 = ((ByteSerializer)object).read(D2DSocketConnectionHandler.this.in, n);
                    object2 = D2DSocketConnectionHandler.this.deserialize(byArray2, n);
                    if (D2DSocketConnectionHandler.this.isFiner()) {
                        D2DSocketConnectionHandler.this.logFiner("Received: " + object2);
                    }
                    if (object2 instanceof D2DObject) {
                        if (object2 instanceof Identity) {
                            Object object3 = D2DSocketConnectionHandler.this.identityWaiter;
                            synchronized (object3) {
                                D2DSocketConnectionHandler.this.identity = (Identity)object2;
                                D2DSocketConnectionHandler.this.identityWaiter.notifyAll();
                            }
                            object3 = D2DSocketConnectionHandler.this.getSocketAcceptor();
                            if (object3 == null) {
                                D2DSocketConnectionHandler.this.logConnectionClose(null);
                                break;
                            }
                            ((AbstractAcceptor)object3).acceptConnection(D2DSocketConnectionHandler.this);
                        }
                        D2DSocketConnectionHandler.this.nodeStateMachine.fire((Object)((D2DEvent)object2).getNodeEvent(), object2);
                        continue;
                    }
                    D2DSocketConnectionHandler.this.lastKeepaliveMessage = new Date();
                    D2DSocketConnectionHandler.this.getController().getTransferManager().getTotalDownloadTrafficCounter().bytesTransferred(n);
                    if (D2DSocketConnectionHandler.this.getController().isStarted() && D2DSocketConnectionHandler.this.member != null && D2DSocketConnectionHandler.this.isConnected()) continue;
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    D2DSocketConnectionHandler.this.logFiner("Socket timeout on read, not disconnecting. " + socketTimeoutException);
                }
                catch (EOFException | SocketException iOException) {
                    D2DSocketConnectionHandler.this.logConnectionClose(iOException);
                    break;
                }
                catch (InvalidClassException invalidClassException) {
                    D2DSocketConnectionHandler.this.logFiner("InvalidClassException", invalidClassException);
                    object = D2DSocketConnectionHandler.this.getMember() != null ? D2DSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    D2DSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + invalidClassException.getMessage() + " from " + (String)object);
                }
                catch (InvalidObjectException invalidObjectException) {
                    D2DSocketConnectionHandler.this.logFiner("InvalidObjectException", invalidObjectException);
                    object = D2DSocketConnectionHandler.this.getMember() != null ? D2DSocketConnectionHandler.this.getMember().getNick() : this.toString();
                    D2DSocketConnectionHandler.this.logWarning("Received invalid object: " + invalidObjectException.getMessage() + " from " + (String)object);
                }
                catch (IOException iOException) {
                    D2DSocketConnectionHandler.this.logFiner("IOException", iOException);
                    D2DSocketConnectionHandler.this.logConnectionClose(iOException);
                    break;
                }
                catch (ConnectionException connectionException) {
                    D2DSocketConnectionHandler.this.logFiner("ConnectionException", connectionException);
                    D2DSocketConnectionHandler.this.logConnectionClose(connectionException);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    D2DSocketConnectionHandler.this.logFiner("ClassNotFoundException", classNotFoundException);
                    D2DSocketConnectionHandler.this.logWarning("Received unknown packet/class: " + classNotFoundException.getMessage() + " from " + D2DSocketConnectionHandler.this);
                }
                catch (TransitionException transitionException) {
                    D2DSocketConnectionHandler.this.logWarning(D2DSocketConnectionHandler.this.getMember() + ": Received unexpected message (" + object2 + "): " + transitionException.getMessage());
                    break;
                }
                catch (RuntimeException runtimeException) {
                    D2DSocketConnectionHandler.this.logWarning(runtimeException.toString(), runtimeException);
                    D2DSocketConnectionHandler.this.shutdownWithMember();
                    throw runtimeException;
                }
            }
            D2DSocketConnectionHandler.this.shutdownWithMember();
        }
    }
}

