/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import com.jgoodies.binding.adapter.PreferencesAdapter;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.ConfigurationEntry;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.os.OSUtil;
import de.dal33t.powerfolder.util.os.Win32.WinUtils;
import java.util.logging.Level;

public enum PreferencesEntry {
    LAST_NODE_ID("last_nodeID_obf", ""),
    NODE_MANAGER_MODEL_SHOW_OFFLINE("node_manager_model_show_offline", true),
    FRIEND_SEARCH_HIDE_OFFLINE("FriendsSearch_HideOfflineUsers", false),
    QUIT_ON_X("quitonx", false),
    ASK_FOR_QUIT_ON_X("AskForQuitOnX", true),
    WARN_ON_CLOSE("WarnOnClose", true),
    EXPERT_MODE("ExpertMode", false){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            if (WEBDAV_ONLY.getValueBoolean(controller).booleanValue()) {
                return false;
            }
            return super.getValueBoolean(controller);
        }
    }
    ,
    SHOW_DEVICES("show.devices", false),
    VIEW_ACHIVE("view.archive", true){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            if (WEBDAV_ONLY.getValueBoolean(controller).booleanValue()) {
                return false;
            }
            return super.getValueBoolean(controller);
        }
    }
    ,
    UNDERLINE_LINKS("UnderlineLinks", false),
    FILE_NAME_CHECK("folder.check_filenames", true),
    CHECK_UPDATE("updatechecker.askfornewreleaseversion", true),
    SHOW_SYSTEM_NOTIFICATIONS("show.system.notifications", true){

        @Override
        protected Object getDefaultValue(Controller controller) {
            return EXPERT_MODE.getValueBoolean(controller);
        }
    }
    ,
    WARN_ON_NO_DIRECT_CONNECTIVITY("warn_on_no_direct_connectivity", false),
    WARN_FULL_CLOUD("warn.poor.quality", true),
    SETUP_DEFAULT_FOLDER("setup_default_folder", false),
    SERVER_REMEMBER_PASSWORD("server_remind_password", true, true),
    DOCUMENT_LOGGING("document.logging", Level.WARNING.getName()),
    AUTO_EXPAND("auto.expand", false),
    USE_ONLINE_STORAGE("use.os", true),
    NOTIFICATION_DISPLAY("notification.display", 10),
    NOTIFICATION_TRANSLUCENT("notification.translucent", 0),
    SKIN_NAME("skin.name", "Origin"),
    SHOW_OFFLINE("show.offline", true),
    SHOW_ASK_FOR_PAUSE("show.ask.for.pause", true),
    MAIN_FRAME_MAXIMIZED("mainframe.maximized", false),
    FILE_SEARCH_MODE("file.search.mode", 10),
    SHOW_TYPICAL_FOLDERS("show.typical.folders", false),
    CREATE_BASEDIR_DESKTOP_SHORTCUT("display.powerfolders.shortcut", true),
    CREATE_FAVORITES_SHORTCUT("use.pf.link", true),
    PAUSED("paused", false),
    INCLUDE_DELETED_FILES("include.deleted.files", false),
    SHOW_HIDDEN_FILES("show.hidden.files", false),
    MODE_SELECT("mode.select.enabled", true){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            if (WEBDAV_ONLY.getValueBoolean(controller).booleanValue()) {
                return false;
            }
            return super.getValueBoolean(controller);
        }
    }
    ,
    SHOW_BROWSE("show.browse", true),
    ENABLE_CONTEXT_MENU("context_menu.enabled", true),
    FOLDER_BASE_PATH("foldersbase", ""),
    FOLDER_BASE_PATH_OVERWRITE("foldersbase.overwrite", true),
    MEMORY_LIMIT_INCREASE("memory_limit.increase", false),
    SHOW_UPDATE("show.update", true){

        @Override
        public Boolean getValueBoolean(Controller controller) {
            if (OSUtil.isWindowsSystem() && WinUtils.isMSI(controller)) {
                return Boolean.FALSE;
            }
            String string = controller.getPreferences().get(this.getPreferencesKey(), null);
            if (string == null) {
                return ConfigurationEntry.ENABLE_UPDATE.getValueBoolean(controller);
            }
            return super.getValueBoolean(controller);
        }
    }
    ,
    WEBDAV_ONLY("webdav.only", false);

    private Class<?> type;
    private String preferencesKey;
    private Object defaultValue;
    private boolean restartRequired;

    private PreferencesEntry(String string2, boolean bl) {
        this(string2, bl, false);
    }

    private PreferencesEntry(String string2, boolean bl, boolean bl2) {
        Reject.ifBlank(string2, "Preferences key is blank");
        this.type = Boolean.class;
        this.preferencesKey = string2;
        this.defaultValue = bl;
        this.restartRequired = bl2;
    }

    private PreferencesEntry(String string2, int n2) {
        Reject.ifBlank(string2, "Preferences key is blank");
        this.type = Integer.class;
        this.preferencesKey = string2;
        this.defaultValue = n2;
        this.restartRequired = false;
    }

    private PreferencesEntry(String string2, String string3) {
        Reject.ifBlank(string2, "Preferences key is blank");
        this.type = String.class;
        this.preferencesKey = string2;
        this.defaultValue = string3;
        this.restartRequired = false;
    }

    String getPreferencesKey() {
        return this.preferencesKey;
    }

    public String getValueString(Controller controller) {
        if (!this.type.isAssignableFrom(String.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot acces as String");
        }
        return controller.getPreferences().get(this.preferencesKey, (String)this.getDefaultValue(controller));
    }

    public Integer getDefaultValueInt() {
        return (Integer)this.defaultValue;
    }

    protected Object getDefaultValue(Controller controller) {
        return this.defaultValue;
    }

    public Integer getValueInt(Controller controller) {
        if (!this.type.isAssignableFrom(Integer.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot access as Integer");
        }
        return controller.getPreferences().getInt(this.preferencesKey, (Integer)this.getDefaultValue(controller));
    }

    public Boolean getValueBoolean(Controller controller) {
        if (!this.type.isAssignableFrom(Boolean.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot access as Boolean");
        }
        return controller.getPreferences().getBoolean(this.preferencesKey, (Boolean)this.getDefaultValue(controller));
    }

    public ValueModel getModel(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        return new PreferencesAdapter(controller.getPreferences(), this.preferencesKey, this.getDefaultValue(controller));
    }

    public void setValue(Controller controller, String string) {
        Reject.ifNull(controller, "Controller is null");
        if (!this.type.isAssignableFrom(String.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot set as String");
        }
        controller.getPreferences().put(this.preferencesKey, string);
    }

    public void setValue(Controller controller, boolean bl) {
        Reject.ifNull(controller, "Controller is null");
        if (!this.type.isAssignableFrom(Boolean.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot set as Boolean");
        }
        controller.getPreferences().putBoolean(this.preferencesKey, bl);
    }

    public void setValue(Controller controller, int n) {
        Reject.ifNull(controller, "Controller is null");
        if (!this.type.isAssignableFrom(Integer.class)) {
            throw new IllegalStateException("This preferences entry has type " + this.type.getName() + " cannot set as Integer");
        }
        controller.getPreferences().putInt(this.preferencesKey, n);
    }

    public void removeValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        controller.getPreferences().remove(this.preferencesKey);
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }
}

