/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import java.util.logging.Logger;

public enum Feature {
    OS_CLIENT,
    EXIT_ON_SHUTDOWN,
    CONFIGURATION_ALL_USERS(false),
    WINDOWS_MISC_DIR_USE_APP_DATA,
    P2P_REQUIRES_LOGIN_AT_SERVER,
    CLUSTER_NODES_CONNECT,
    CORRECT_LAN_DETECTION,
    CORRECT_INTERNET_DETECTION,
    CORRECT_MOVEMENT_DETECTION(false),
    DEBUG_WRITE_FILELIST_CSV(false),
    DEBUG_WRITE_NETSTAT(false),
    INTERNAL_USE(false),
    USER_DIRECTORIES_EMAIL_CLIENTS(false),
    MANUAL_SYNC_CB(false),
    SYSTRAY_ALL_FOLDERS(false),
    FILEBROWSER_INTEGRATION,
    UI_ENABLED,
    REGISTER_DONT_ACTIVATE_ACCOUNTS,
    NTFS_PRESERVE_FILE_OWNER(false),
    FILEINFO_LOG_MISSING_MODIFIED_BY_ACCOUNT;

    private static final Logger log;
    private boolean defValue;
    private Boolean enabled;

    private Feature(boolean bl) {
        this.defValue = bl;
    }

    private Feature() {
        this(true);
    }

    public void disable() {
        log.fine(this.name() + " disabled");
        System.setProperty(this.getSystemPropertyKey(), "disabled");
        this.enabled = false;
    }

    public void enable() {
        log.fine(this.name() + " enabled");
        System.setProperty(this.getSystemPropertyKey(), "enabled");
        this.enabled = true;
    }

    public String getSystemPropertyKey() {
        return "powerfolder.feature." + this.name();
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    public boolean isEnabled() {
        if (this.enabled == null) {
            String string = System.getProperty("powerfolder.feature." + this.name(), this.defValue ? "enabled" : "disabled");
            this.enabled = "enabled".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string);
        }
        return this.enabled;
    }

    public static void setupForTests() {
        for (Feature feature : Feature.values()) {
            feature.disable();
        }
        INTERNAL_USE.enable();
    }

    static {
        log = Logger.getLogger(Feature.class.getName());
    }
}

