/*
 * Decompiled with CFR 0.152.
 */
package de.dal33t.powerfolder;

import com.google.common.collect.Maps;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import de.dal33t.powerfolder.Controller;
import de.dal33t.powerfolder.EncryptionPolicy;
import de.dal33t.powerfolder.util.Reject;
import de.dal33t.powerfolder.util.StringUtils;
import de.dal33t.powerfolder.util.Util;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum ConfigurationProEntry {
    ENCRYPTION_POLICY_INET("plugin.encryption.inetpolicy", EncryptionPolicy.REQUIRED.name(), false),
    ENCRYPTION_POLICY_LAN("plugin.encryption.lanpolicy", EncryptionPolicy.REQUIRED.name(), false),
    AUTO_ACCEPT_FIRST_TIME_KEY_FROM_FRIENDS("plugin.encryption.autoacceptfirstkey.friends", true),
    AUTO_ACCEPT_FIRST_TIME_KEY_FROM_ALL("plugin.encryption.autoacceptfirstkey.all", true),
    LICENSE_CHECK_ENABLED("license.check.enabled", false),
    LICENSE_EMAIL("license.email"),
    LICENSE_KEY("license.key"),
    LICENSE_LIMIT_USER("license.limit.user"),
    LICENSE_SHUTDOWN_IF_MISSING("license.missing.shutdown", false),
    LICENSE_AUTO_SWITCH("license.autoswitch", true),
    LICENSE_REQUIRES_SERVER("license.server", false),
    LICENSE_SERVICE_USERNAME("license.service.username", null, true),
    LICENSE_SERVICE_PASSWORD_OBF("license.servicer.passwordobf", null, false),
    SYSTEM_SERVICE_AUTO_UPDATE("system.service.auto.update", false),
    NET_USE_TCP_CONNECTION("connections.tcp", true),
    NET_USE_WEBSOCKET_CONNECTION("connections.websocket", false),
    CONNECT_ON_DEMAND_PERIODIC_INTERVAL("connect_on_demand.interval", 3600),
    CONFLICT_NOTIFIER_TYPE("plugin.pro.conflict_notifier.type", "pf", false),
    CONFLICT_NOTIFIER_EXTENSION("plugin.pro.conflict_notifier.extension", "", false),
    MONITOR_FOLDER_ID("plugin.pro.monitor.folderid"),
    MONITOR_FOLDER_NAME_PATTERN("plugin.pro.monitor.foldername", "Remote monitor ($nick)", false),
    MONITOR_TRANSFER_LOG_DOWNLOADS_LOGFILE_PATTERN("plugin.pro.monitor.transfer.downloadlog", "yyyy/MM/dd/'Downloads.csv'", false),
    MONITOR_TRANSFER_LOG_UPLOADS_LOGFILE_PATTERN("plugin.pro.monitor.transfer.uploadslog", "yyyy/MM/dd/'Uploads.csv'", false),
    MONITOR_TRANSFER_USE_CSV("plugin.pro.monitor.transfer.use_csv", true),
    MONITOR_TRANSFER_USE_SQL("plugin.pro.monitor.transfer.use_sql", false);

    private String configKey;
    private String defaultValue;
    private boolean restartRequired;
    private static final Map<String, ConfigurationProEntry> LOOKUP;

    private ConfigurationProEntry(String string2) {
        this(string2, null, false);
    }

    private ConfigurationProEntry(String string2, String string3, boolean bl) {
        Reject.ifBlank(string2, "Config key is blank");
        this.configKey = string2;
        this.defaultValue = string3;
        this.restartRequired = bl;
    }

    private ConfigurationProEntry(String string2, int n2) {
        this(string2, "" + n2, false);
    }

    private ConfigurationProEntry(String string2, boolean bl) {
        this(string2, "" + bl, false);
    }

    public boolean hasValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        return this.hasValue(controller.getConfig());
    }

    public boolean hasValue(Properties properties) {
        Reject.ifNull(properties, "Config is null");
        return properties.getProperty(this.configKey) != null;
    }

    public ValueModel getModel(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        ValueHolder valueHolder = new ValueHolder(this.getValue(controller), false);
        valueHolder.addValueChangeListener(propertyChangeEvent -> this.setValue(controller, String.valueOf(propertyChangeEvent.getNewValue())));
        return valueHolder;
    }

    public String getValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        String string = controller.getConfig().getProperty(this.configKey);
        if (string == null) {
            string = this.defaultValue;
        }
        return string;
    }

    public Integer getValueInt(Controller controller) {
        String string = this.getValue(controller);
        if (string == null || StringUtils.isBlank(string)) {
            string = this.defaultValue;
        }
        try {
            return new Integer(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ConfigurationProEntry.class.getName()).log(Level.WARNING, "Unable to parse configuration entry '" + this.configKey + "' into a int. Value: " + string, numberFormatException);
            return new Integer(this.defaultValue);
        }
    }

    public Boolean getValueBoolean(Controller controller) {
        String string = this.getValue(controller);
        if (string == null || StringUtils.isBlank(string)) {
            string = this.defaultValue;
        }
        try {
            return string.trim().equalsIgnoreCase("true");
        }
        catch (NumberFormatException numberFormatException) {
            Logger.getLogger(ConfigurationProEntry.class.getName()).log(Level.WARNING, "Unable to parse configuration entry '" + this.configKey + "' into a boolean. Value: " + string, numberFormatException);
            return this.defaultValue.equalsIgnoreCase("true");
        }
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setValue(Controller controller, String string) {
        Reject.ifNull(controller, "Controller is null");
        if (string != null) {
            controller.getConfig().setProperty(this.configKey, string);
        } else {
            this.removeValue(controller);
        }
    }

    public void setValueInt(Controller controller, int n) {
        Reject.ifNull(controller, "Controller is null");
        controller.getConfig().setProperty(this.configKey, "" + n);
    }

    public void removeValue(Controller controller) {
        Reject.ifNull(controller, "Controller is null");
        controller.getConfig().remove(this.configKey);
    }

    public void removeValue(Properties properties) {
        Reject.ifNull(properties, "config is null");
        properties.remove(this.configKey);
    }

    public void setOverwrite(Properties properties, Boolean bl) {
        if (bl != null) {
            properties.setProperty(this.getConfigKey() + ".overwrite", String.valueOf(bl));
        } else {
            properties.remove(this.getConfigKey() + ".overwrite");
        }
    }

    public void copy(Controller controller, Properties properties) {
        String string = this.getValue(controller);
        if (string != null) {
            properties.setProperty(this.getConfigKey(), string);
        } else {
            properties.remove(this.getConfigKey());
        }
    }

    public void copyIfNotDefault(Controller controller, Properties properties) {
        String string = this.getValue(controller);
        if (!Util.equals(string, this.getDefaultValue())) {
            this.copy(controller, properties);
        } else {
            this.removeValue(properties);
        }
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public boolean isRestartRequired() {
        return this.restartRequired;
    }

    public static ConfigurationProEntry getEnum(String string) {
        return LOOKUP.get(string);
    }

    static {
        LOOKUP = Maps.uniqueIndex(Arrays.asList(ConfigurationProEntry.values()), ConfigurationProEntry::getConfigKey);
    }
}

