/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import dagger.producers.Producer;
import dagger.producers.internal.AbstractProducer;
import java.util.List;
import java.util.Map;

public final class MapProducer<K, V>
extends AbstractProducer<Map<K, V>> {
    private final Producer<Map<K, Producer<V>>> mapProducerProducer;
    private static final Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Object>>> ENTRY_UNWRAPPER = new Function<Map.Entry<Object, Producer<Object>>, ListenableFuture<Map.Entry<Object, Object>>>(){

        @Override
        public ListenableFuture<Map.Entry<Object, Object>> apply(final Map.Entry<Object, Producer<Object>> entry) {
            return Futures.transform(entry.getValue().get(), new Function<Object, Map.Entry<Object, Object>>(){

                @Override
                public Map.Entry<Object, Object> apply(Object object) {
                    return Maps.immutableEntry(entry.getKey(), object);
                }
            }, MoreExecutors.directExecutor());
        }
    };

    private MapProducer(Producer<Map<K, Producer<V>>> producer) {
        this.mapProducerProducer = producer;
    }

    public static <K, V> MapProducer<K, V> create(Producer<Map<K, Producer<V>>> producer) {
        return new MapProducer<K, V>(producer);
    }

    @Override
    public ListenableFuture<Map<K, V>> compute() {
        return Futures.transformAsync(this.mapProducerProducer.get(), new AsyncFunction<Map<K, Producer<V>>, Map<K, V>>(){

            @Override
            public ListenableFuture<Map<K, V>> apply(Map<K, Producer<V>> map) {
                return Futures.transform(Futures.allAsList(Iterables.transform(map.entrySet(), MapProducer.entryUnwrapper())), new Function<List<Map.Entry<K, V>>, Map<K, V>>(){

                    @Override
                    public Map<K, V> apply(List<Map.Entry<K, V>> list) {
                        return ImmutableMap.copyOf(list);
                    }
                }, MoreExecutors.directExecutor());
            }
        }, MoreExecutors.directExecutor());
    }

    private static <K, V> Function<Map.Entry<K, Producer<V>>, ListenableFuture<Map.Entry<K, V>>> entryUnwrapper() {
        return ENTRY_UNWRAPPER;
    }
}

